%define prefixpath /usr/X11R6
%define VERSION 2.6.2
Name: wmakerconf
Version: %{VERSION}
Release: 1
Summary: This is a GTK-based configuration tool for Window Maker
Group: X11/Window Managers
Copyright: GPL
Packager: Ullrich Hafner <hafner@bigfoot.de>
Vendor: NOP
Icon: wmakerconf.xpm
Source: wmakerconf-%{VERSION}.tar.gz
Requires: libPropList >= 0.8.3, WindowMaker >= 0.62.0, gtk+ >= 1.2, perl, gzip, lynx
BuildRoot: /var/tmp/wmakerconf-root

%description

wmakerconf is a GTK+ based configuration tool for the window manager
Window Maker. All attributes (including the application menu) can be
configured by wmakerconf, making it an alternative (or add-on) for the
built in Window Maker configuration tool WPrefs. Moreover, an easy
theme installation via WWW is available: a simple drag and drop
operation from your favorite browser to your wmakerconf themes
interface will do the job.

%prep
%setup
%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefixpath} \
	--with-wmakerprefix=%{prefixpath} --disable-gtktest\
	--disable-upgrade 
make

%install
rm -rf $RPM_BUILD_ROOT
make install prefix=$RPM_BUILD_ROOT%{prefixpath}
strip $RPM_BUILD_ROOT%{prefixpath}/bin/wmakerconf

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc ABOUT-NLS AUTHORS ChangeLog NLS-TEAM1 NLS-TEAM2 NEWS README TODO MANUAL
%{prefixpath}/bin/*
%{prefixpath}/share/wmakerconf/WMWmakerconf
%{prefixpath}/share/wmakerconf/wmaker-version
%{prefixpath}/share/wmakerconf/MANUAL
%{prefixpath}/share/wmakerconf/*.sh
%{prefixpath}/share/wmakerconf/*.pl
%{prefixpath}/share/wmakerconf/*.xpm
%{prefixpath}/share/locale/*/LC_MESSAGES/wmakerconf-data.*
%{prefixpath}/share/locale/*/LC_MESSAGES/wmakerconf.*

%changelog
* Fri Apr 02 2000 Ullrich Hafner <hafner@bigfoot.de>
- upgraded to wmakerconf 2.6

* Fri Jan 21 2000 Ullrich Hafner <hafner@bigfoot.de>
- upgraded to wmakerconf 2.5

* Sun Dec 5 1999 Ullrich Hafner <hafner@bigfoot.de>
- upgraded to wmakerconf 2.4
- make the data package part of wmakerconf 

* Mon Oct 18 1999 Steve Hamlin <steve@hamlinx.com>
- upgraded to wmakerconf 2.3
- applied preview crash patch (and fixed location mistake)
- added data package back, but now built separately 
- removed libPropList package
- relocated to /usr/X11R6 from /usr

* Sun Mar 14 1999 Ullrich Hafner <hafner@bigfoot.de>
- upgraded to wmakerconf 1.8
- removed data package
- new NLS structure

* Fri Feb 12 1999 Ullrich Hafner <hafner@bigfoot.de>
- upgraded to wmakerconf 1.7

* Wed Jan 20 1999 Ullrich Hafner <hafner@bigfoot.de>
- upgraded to wmakerconf 1.6

* Tue Dec 22 1998 Ullrich Hafner <hafner@bigfoot.de>
- upgraded to wmakerconf 1.5
- added prefix

* Thu Nov 19 1998 Ullrich Hafner <hafner@bigfoot.de>
- upgraded to wmakerconf 1.3
- updated data files for windowmaker 0.20.2 and above
- split into wmakerconf and wmakerconf-data package

* Sat Oct 10 1998 Cristian Gafton <gafton@redhat.com>
- strip binaries
- updated data files for windowmaker 0.20 and above

* Fri Sep 18 1998 Cristian Gafton <gafton@redhat.com>
- packaged for 5.2 to be used with WindowMaker
