/*
 *  dialog.h
 *
 *  Copyright (C) 1998 Ullrich Hafner <hafner@bigfoot.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 1999/10/23 17:43:25 $
 *  $Author: hafner $
 *  $Revision: 1.13 $
 *  $State: Exp $
 */

#ifndef _DIALOG_H
#define _DIALOG_H

#include <gtk/gtk.h>

typedef enum dialog {DIALOG_INFO, DIALOG_QUESTION, DIALOG_WARNING,
		    DIALOG_ERROR} dialog_e;

void
dialog_popup (dialog_e type, void (*ok_function) (GtkWidget *, gpointer),
	      gpointer dataptr_ok_function, const char *format, ...);
void
dialog (dialog_e type, const char *close_text, const char *ok_text,
	void (*ok_function) (GtkWidget *, gpointer), gpointer dataptr_ok_function,
	const char *format, ...);
GtkWidget *
generate_option_menu (const char *description,
		      GtkTooltips *tooltips, const char *info,
		      const char **entry, const char *current,
		      proplist_t *text,
		      void (*callback) (GtkWidget *, gpointer),
		      gpointer callback_data);
void
set_option_menu_default (GtkOptionMenu *menu, const char **list,
			 const char *value);
gint
progress_timer (gpointer data);
gint
delete_button (GtkWidget *widget, GdkEventAny  *event, gpointer ptr);

#endif /* not _DIALOG_H */

