/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphicsio.font.FontIncluder;

public abstract class FontEmbedder
extends FontIncluder {
    public static final String NOTDEF = ".notdef";
    private double[] widths;
    private GlyphVector glyphs;
    private Font font;

    protected abstract void writeGlyph(String var1, Shape var2, GlyphMetrics var3) throws IOException;

    protected abstract void writeWidths(double[] var1) throws IOException;

    protected void openGlyphs() throws IOException {
    }

    protected void closeGlyphs() throws IOException {
    }

    protected abstract void closeEmbedFont() throws IOException;

    public FontEmbedder(FontRenderContext fontRenderContext) {
        super(fontRenderContext);
    }

    protected double[] getAdvanceWidths() {
        if (this.widths == null) {
            this.widths = new double[256];
            for (int i2 = 0; i2 < this.widths.length; ++i2) {
                this.widths[i2] = this.glyphs.getGlyphMetrics(i2).getAdvance();
                if (this.getCharName(i2) != null) continue;
                this.widths[i2] = this.getUndefinedWidth();
            }
        }
        return this.widths;
    }

    protected double getAdvanceWidth(int n2) {
        return this.getAdvanceWidths()[n2];
    }

    protected Shape getGlyph(int n2) {
        FontRenderContext fontRenderContext = this.getContext();
        FontRenderContext fontRenderContext2 = new FontRenderContext(null, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics());
        Shape shape = this.font.createGlyphVector(fontRenderContext2, new char[]{this.getUnicode(n2)}).getGlyphOutline(0);
        return fontRenderContext.getTransform().createTransformedShape(shape);
    }

    protected GlyphMetrics getGlyphMetrics(int n2) {
        return this.glyphs.getGlyphMetrics(n2);
    }

    public void includeFont(Font font, CharTable charTable, String string) throws IOException {
        this.glyphs = null;
        this.widths = null;
        this.font = font;
        super.includeFont(font, charTable, string);
        this.glyphs = font.createGlyphVector(this.getContext(), this.getUnicode());
        this.writeWidths(this.getAdvanceWidths());
        try {
            this.openGlyphs();
            for (int i2 = 0; i2 < 256; ++i2) {
                if (this.getCharName(i2) == null) continue;
                this.writeGlyph(this.getCharName(i2), this.getGlyph(i2), this.getGlyphMetrics(i2));
            }
            this.writeGlyph(NOTDEF, this.createUndefined(), null);
            this.closeGlyphs();
            this.closeEmbedFont();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Shape createUndefined() {
        GeneralPath generalPath = new GeneralPath(0, 10);
        generalPath.append(new Rectangle2D.Double(0.0, 0.0, 1000.0, 1000.0), false);
        generalPath.append(new Rectangle2D.Double(50.0, 50.0, 900.0, 900.0), false);
        return generalPath;
    }
}

