/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.DrawMolecule;
import WIMSchem.MainApplet;
import WIMSchem.MainPanel;
import WIMSchem.MolSelectListener;
import WIMSchem.Molecule;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorPane
extends JComponent
implements MouseListener,
MouseMotionListener,
FocusListener,
KeyListener,
MouseWheelListener,
ComponentListener {
    Molecule mol;
    boolean editable = true;
    boolean hasBorder = false;
    boolean autoScale = false;
    static final double IDEALBOND = 1.5;
    double offsetX = 0.0;
    double offsetY = 0.0;
    double scale = 20.0;
    boolean[] selected = null;
    boolean[] dragged = null;
    double[] px = null;
    double[] py = null;
    double[] rw = null;
    double[] rh = null;
    double[][] bfx = null;
    double[][] bfy = null;
    double[][] btx = null;
    double[][] bty = null;
    int highlightAtom = 0;
    int highlightBond = 0;
    int showMode = 1;
    boolean showHydr = MainPanel.viewH;
    boolean viewC = MainPanel.viewC;
    public static boolean[] bondselection;
    public static boolean[] atomselection;
    boolean showSter = false;
    static final int TOOL_CURSOR = 1;
    static final int TOOL_ROTATOR = 2;
    static final int TOOL_ERASOR = 3;
    static final int TOOL_ATOM = 4;
    static final int TOOL_BOND = 5;
    static final int TOOL_CHARGE = 6;
    static final int TOOL_TEMPLATE = 7;
    static final int TOOL_SELECT = 8;
    static final int DRAG_SELECT = 1;
    static final int DRAG_MOVE = 2;
    static final int DRAG_COPY = 3;
    static final int DRAG_SCALE = 4;
    static final int DRAG_ROTATE = 5;
    int trackX = -1;
    int trackY = -1;
    boolean isSelectionPane = false;
    int selBoxW = 0;
    int selBoxH = 0;
    MolSelectListener selectListen = null;
    int tool = 0;
    int toolDragReason = 0;
    double toolDragX1;
    double toolDragY1;
    double toolDragX2;
    double toolDragY2;
    String toolAtomType = null;
    boolean toolAtomDrag;
    boolean toolAtomSnap;
    int toolAtomEditSel = 0;
    int toolAtomEditX;
    int toolAtomEditY;
    JTextField toolAtomEditBox = null;
    int toolBondOrder = 0;
    int toolBondType = 0;
    int toolBondFrom = 0;
    int toolBondHit = 0;
    double toolBondFromX = 0.0;
    double toolBondFromY = 0.0;
    double toolBondToX = 0.0;
    double toolBondToY = 0.0;
    boolean toolSnap;
    boolean toolBondDrag = false;
    int toolCharge = 0;
    static final int UNDO_LEVELS = 10;
    EditState[] undo = null;
    EditState[] redo = null;
    Molecule template = null;
    Molecule templDraw = null;
    int templateIdx = 0;
    Molecule lastCleanMol = null;
    boolean lastDirty = false;

    public EditorPane() {
        this.Init();
    }

    public EditorPane(int width, int height) {
        this.isSelectionPane = true;
        this.selBoxW = width;
        this.selBoxH = height;
        this.Init();
    }

    void Init() {
        this.mol = new Molecule();
        this.DetermineSize();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
        if (MainApplet.user_selection) {
            atomselection = new boolean[this.mol.NumAtoms() + 32];
            bondselection = new boolean[this.mol.NumBonds() + 32];
        }
    }

    public Molecule MolData() {
        return this.mol;
    }

    public boolean IsEmpty() {
        return this.mol.NumAtoms() == 0;
    }

    public void Clear() {
        this.CacheUndo();
        if (MainApplet.user_selection) {
            atomselection = new boolean[256];
            bondselection = new boolean[256];
        }
        this.mol = new Molecule();
        this.ClearTemporary();
        this.DetermineSize();
        this.repaint();
        this.CheckDirtiness();
    }

    public void Replace(Molecule Mol) {
        this.Replace(Mol, false, true);
    }

    public void Replace(Molecule Mol, boolean ClearSelection) {
        this.Replace(Mol, ClearSelection, true);
    }

    public void Replace(Molecule Mol, boolean ClearSelection, boolean Repaint) {
        if (this.mol.NumAtoms() != Mol.NumAtoms()) {
            ClearSelection = true;
        }
        this.mol = Mol;
        this.ClearTemporary(ClearSelection);
        if (Repaint) {
            this.repaint();
        }
    }

    public void SetMolSelectListener(MolSelectListener listen) {
        this.selectListen = listen;
    }

    public void SetEditable(boolean Editable) {
        this.editable = Editable;
    }

    public void SetBorder(boolean HasBorder) {
        this.hasBorder = HasBorder;
    }

    public void SetAutoScale(boolean AutoScale) {
        this.autoScale = AutoScale;
    }

    public void NotifySaved() {
        this.lastCleanMol = this.mol.Clone();
        this.lastDirty = false;
        if (this.selectListen != null) {
            this.selectListen.DirtyChanged(false);
        }
    }

    public boolean IsDirty() {
        return this.lastDirty;
    }

    void CheckDirtiness() {
        boolean nowDirty;
        boolean bl = nowDirty = this.mol.CompareTo(this.lastCleanMol) != 0;
        if (nowDirty != this.lastDirty) {
            if (this.selectListen != null) {
                this.selectListen.DirtyChanged(nowDirty);
            }
            this.lastDirty = nowDirty;
        }
    }

    public void SetShowMode(int ShowMode) {
        if (this.showMode == ShowMode) {
            return;
        }
        this.showMode = ShowMode;
        this.repaint();
    }

    public void SetShowHydrogens(boolean ShowHydr) {
        if (this.showHydr == ShowHydr) {
            return;
        }
        this.showHydr = ShowHydr;
        this.repaint();
    }

    public void SetShowStereolabels(boolean ShowSter) {
        if (this.showSter == ShowSter) {
            return;
        }
        this.showSter = ShowSter;
        this.repaint();
    }

    public void SetToolCursor() {
        this.tool = 1;
        this.repaint();
    }

    public void SetToolRotator() {
        this.tool = 2;
        this.repaint();
    }

    public void SetToolErasor() {
        this.tool = 3;
        this.repaint();
    }

    public void SetToolAtom(String Atom2) {
        this.tool = 4;
        this.toolAtomType = Atom2;
        this.toolAtomDrag = false;
        this.toolAtomSnap = false;
        this.toolBondFrom = 0;
        this.toolBondToX = 0.0;
        this.toolBondToY = 0.0;
        this.repaint();
    }

    public void SetToolBond(int Order) {
        this.tool = 5;
        this.toolBondFrom = 0;
        if (Order >= 0) {
            this.toolBondOrder = Order;
            this.toolBondType = 0;
        } else {
            this.toolBondOrder = 1;
            if (Order == -1) {
                this.toolBondType = 1;
            } else if (Order == -2) {
                this.toolBondType = 2;
            } else if (Order == -3) {
                this.toolBondType = 3;
            }
        }
        this.repaint();
    }

    public void SetToolCharge(int DChg) {
        this.tool = 6;
        this.toolCharge = DChg;
    }

    public void SetToolTemplate(Molecule Templ, int Idx) {
        this.tool = 7;
        this.template = Templ;
        this.templateIdx = Idx;
        this.repaint();
    }

    public boolean CanUndo() {
        return this.undo != null && this.undo[0] != null;
    }

    public boolean CanRedo() {
        return this.redo != null && this.redo[0] != null;
    }

    public void Undo() {
        int n;
        if (!this.CanUndo()) {
            return;
        }
        if (this.redo == null) {
            this.redo = new EditState[10];
        }
        for (n = 9; n > 0; --n) {
            this.redo[n] = this.redo[n - 1];
        }
        this.redo[0] = new EditState();
        this.redo[0].Molecule = this.mol;
        this.redo[0].Selected = this.selected;
        this.mol = this.undo[0].Molecule;
        this.selected = this.undo[0].Selected;
        for (n = 0; n < 9; ++n) {
            this.undo[n] = this.undo[n + 1];
        }
        this.ClearTemporary(false);
        this.DetermineSize();
        this.repaint();
        this.CheckDirtiness();
    }

    public void Redo() {
        int n;
        if (!this.CanRedo()) {
            return;
        }
        if (this.undo == null) {
            this.undo = new EditState[10];
        }
        for (n = 9; n > 0; --n) {
            this.undo[n] = this.undo[n - 1];
        }
        this.undo[0] = new EditState();
        this.undo[0].Molecule = this.mol;
        this.undo[0].Selected = this.selected;
        this.mol = this.redo[0].Molecule;
        this.selected = this.redo[0].Selected;
        for (n = 0; n < 9; ++n) {
            this.redo[n] = this.redo[n + 1];
        }
        this.ClearTemporary(false);
        this.DetermineSize();
        this.repaint();
        this.CheckDirtiness();
    }

    public void ScaleToFit() {
        this.ScaleToFit(20.0);
    }

    public void ScaleToFit(double MaxScale) {
        this.ClearTemporary();
        double mw = 2.0 + this.mol.RangeX();
        double mh = 2.0 + this.mol.RangeY();
        Rectangle vis = this.getVisibleRect();
        if (vis.getWidth() == 0.0 || vis.getHeight() == 0.0) {
            vis = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        double sw = (double)this.selBoxW > vis.getWidth() ? (double)this.selBoxW : vis.getWidth();
        double sh = (double)this.selBoxH > vis.getHeight() ? (double)this.selBoxH : vis.getHeight();
        this.scale = Math.min(Math.min(sw / mw, sh / mh), MaxScale);
        this.offsetX = 0.5 * (sw / this.scale - this.mol.RangeX()) - this.mol.MinX();
        this.offsetY = 0.5 * (sh / this.scale - this.mol.RangeY()) + this.mol.MaxY();
    }

    public void ZoomFull() {
        this.ScaleToFit();
        this.DetermineSize();
        this.repaint();
    }

    public void ZoomIn(double Mag) {
        this.scale *= Mag;
        this.DetermineSize();
        this.repaint();
    }

    public void ZoomOut(double Mag) {
        this.scale /= Mag;
        this.DetermineSize();
        this.repaint();
    }

    public void SelectAll() {
        this.selected = new boolean[this.mol.NumAtoms()];
        for (int n = 0; n < this.mol.NumAtoms(); ++n) {
            this.selected[n] = true;
        }
        this.repaint();
    }

    public void DeSelectAll() {
        atomselection = new boolean[this.mol.NumAtoms() + 32];
        bondselection = new boolean[this.mol.NumBonds() + 32];
        this.repaint();
    }

    public void Select() {
        this.tool = 8;
    }

    public void AddArbitraryFragment(Molecule Frag) {
        int n;
        if (Frag.NumAtoms() == 0) {
            return;
        }
        this.CacheUndo();
        if (this.mol.NumAtoms() == 0) {
            this.mol = Frag;
            this.ClearTemporary();
            this.ScaleToFit();
            this.DetermineSize();
            this.repaint();
            this.CheckDirtiness();
            return;
        }
        double[] dirX = new double[]{1.0, 0.0, -1.0, 1.0, -1.0, 1.0, 0.0, -1.0};
        double[] dirY = new double[]{1.0, 1.0, 1.0, 0.0, 0.0, -1.0, -1.0, -1.0};
        double[] dx = new double[8];
        double[] dy = new double[8];
        double[] score = new double[8];
        for (int n2 = 0; n2 < 8; ++n2) {
            double iscore;
            int iter;
            double vx = dirX[n2];
            double vy = dirY[n2];
            dx[n2] = n2 == 0 || n2 == 3 || n2 == 5 ? this.mol.MinX() - Frag.MaxX() : (n2 == 2 || n2 == 4 || n2 == 7 ? this.mol.MaxX() - Frag.MinX() : 0.5 * (this.mol.MinX() + this.mol.MaxX() - Frag.MinX() - Frag.MaxX()));
            dy[n2] = n2 == 5 || n2 == 6 || n2 == 7 ? this.mol.MinY() - Frag.MaxY() : (n2 == 0 || n2 == 1 || n2 == 2 ? this.mol.MaxY() - Frag.MinY() : 0.5 * (this.mol.MinY() + this.mol.MaxY() - Frag.MinY() - Frag.MaxY()));
            int n3 = n2;
            dx[n3] = dx[n3] - vx;
            int n4 = n2;
            dy[n4] = dy[n4] - vy;
            score[n2] = this.FragPosScore(Frag, dx[n2], dy[n2]);
            vx *= 0.25;
            vy *= 0.25;
            for (iter = 100; iter > 0 && !((iscore = this.FragPosScore(Frag, dx[n2] + vx, dy[n2] + vy)) <= score[n2]); --iter) {
                score[n2] = iscore;
                int n5 = n2;
                dx[n5] = dx[n5] + vx;
                int n6 = n2;
                dy[n6] = dy[n6] + vy;
            }
            for (iter = 100; iter > 0; --iter) {
                double iscore2;
                for (int d = 0; d < 8 && !((iscore2 = this.FragPosScore(Frag, dx[n2] + (vx = dirX[d] * 0.1), dy[n2] + (vy = dirY[d] * 0.1))) <= score[n2]); ++d) {
                    score[n2] = iscore2;
                    int n7 = n2;
                    dx[n7] = dx[n7] + vx;
                    int n8 = n2;
                    dy[n8] = dy[n8] + vy;
                }
            }
        }
        int best = 0;
        for (n = 1; n < 8; ++n) {
            if (!(score[n] > score[best])) continue;
            best = n;
        }
        for (n = 1; n <= Frag.NumAtoms(); ++n) {
            Frag.SetAtomPos(n, Frag.AtomX(n) + dx[best], Frag.AtomY(n) + dy[best]);
        }
        int base = this.mol.NumAtoms();
        this.mol.Append(Frag);
        this.ClearTemporary();
        this.ScaleToFit();
        this.DetermineSize();
        this.selected = new boolean[this.mol.NumAtoms()];
        for (int n9 = 0; n9 < this.mol.NumAtoms(); ++n9) {
            this.selected[n9] = n9 >= base;
        }
        this.repaint();
        this.CheckDirtiness();
    }

    double FragPosScore(Molecule Frag, double DX, double DY) {
        double score = 0.0;
        for (int i = 1; i <= this.mol.NumAtoms(); ++i) {
            for (int j = 1; j <= Frag.NumAtoms(); ++j) {
                double dy;
                double dx = Frag.AtomX(j) + DX - this.mol.AtomX(i);
                double dist2 = dx * dx + (dy = Frag.AtomY(j) + DY - this.mol.AtomY(i)) * dy;
                if (dist2 < 1.0) {
                    return 0.0;
                }
                score += 1.0 / dist2;
            }
        }
        double minX = Math.min(Frag.MinX() + DX, this.mol.MinX());
        double maxX = Math.max(Frag.MaxX() + DX, this.mol.MaxX());
        double minY = Math.min(Frag.MinY() + DY, this.mol.MinY());
        double maxY = Math.max(Frag.MaxY() + DY, this.mol.MaxY());
        double rangeX = Math.max(1.0, maxX - minX);
        double rangeY = Math.max(1.0, maxY - minY);
        double ratio = Math.max(rangeX / rangeY, rangeY / rangeX);
        return score / ratio;
    }

    public int CountSelected() {
        if (this.selected == null) {
            return 0;
        }
        int num = 0;
        for (int n = 0; n < this.mol.NumAtoms(); ++n) {
            if (!this.selected[n]) continue;
            ++num;
        }
        return num;
    }

    public ArrayList<Integer> SelectedIndices() {
        int n;
        ArrayList<Integer> selidx = new ArrayList<Integer>();
        if (this.selected != null) {
            for (n = 0; n < this.mol.NumAtoms(); ++n) {
                if (!this.selected[n]) continue;
                selidx.add(n + 1);
            }
        }
        if (selidx.size() == 0) {
            for (n = 1; n <= this.mol.NumAtoms(); ++n) {
                selidx.add(n);
            }
        }
        return selidx;
    }

    public Molecule SelectedSubgraph() {
        if (this.selected == null) {
            return this.mol.Clone();
        }
        int sum = 0;
        for (int n = 0; n < this.mol.NumAtoms(); ++n) {
            if (!this.selected[n]) continue;
            ++sum;
        }
        if (sum == 0) {
            return this.mol.Clone();
        }
        return this.mol.Subgraph(this.selected);
    }

    public void DeleteSelected() {
        int n;
        this.CacheUndo();
        boolean anySelected = false;
        if (this.selected != null) {
            for (n = 0; n < this.mol.NumAtoms(); ++n) {
                if (!this.selected[n]) continue;
                anySelected = true;
                break;
            }
        }
        if (!anySelected) {
            return;
        }
        for (n = this.mol.NumAtoms() - 1; n >= 0; --n) {
            if (!this.selected[n]) continue;
            this.mol.DeleteAtomAndBonds(n + 1);
        }
        this.ClearTemporary();
        if (MainApplet.user_selection) {
            bondselection = new boolean[this.mol.NumBonds() + 256];
            atomselection = new boolean[this.mol.NumAtoms() + 256];
        }
        this.DetermineSize();
        this.repaint();
        this.CheckDirtiness();
    }

    public void HydrogenSetExplicit(boolean IsExpl) {
        this.HydrogenSetExplicit(IsExpl, -1);
    }

    public void HydrogenSetExplicit(boolean IsExpl, int NumExpl) {
        this.CacheUndo();
        ArrayList<Integer> sel = this.SelectedIndices();
        for (int n = 0; n < sel.size(); ++n) {
            int i = sel.get(n);
            if (IsExpl) {
                this.mol.SetAtomHExplicit(i, this.mol.AtomHydrogens(i));
                continue;
            }
            this.mol.SetAtomHExplicit(i, NumExpl);
        }
        this.repaint();
        this.CheckDirtiness();
    }

    public void HydrogenCreateActual() {
        this.CacheUndo();
        ArrayList<Integer> sel = this.SelectedIndices();
        int[] score = new int[360];
        for (int n = 0; n < sel.size(); ++n) {
            int i2;
            int i1;
            int i0;
            int i = sel.get(n);
            int hy = this.mol.AtomHydrogens(i);
            if (hy == 0) continue;
            for (int j = 0; j < 360; ++j) {
                score[j] = 0;
            }
            int[] adj = this.mol.AtomAdjList(i);
            for (int j = 0; j < adj.length; ++j) {
                int iang = (int)(Math.atan2(this.mol.AtomY(adj[j]) - this.mol.AtomY(i), this.mol.AtomX(adj[j]) - this.mol.AtomX(i)) * 180.0 / Math.PI);
                if (iang < 0) {
                    iang += 360;
                }
                score[iang] = -1;
                score[(iang + 1) % 360] = -1;
                score[(iang + 359) % 360] = -1;
                i0 = (iang + 180) % 360;
                i1 = (iang + 120) % 360;
                i2 = (iang + 240) % 360;
                if (score[i0] >= 0) {
                    int n2 = i0;
                    score[n2] = score[n2] + 2;
                }
                if (score[i1] >= 0) {
                    int n3 = i1;
                    score[n3] = score[n3] + 4;
                }
                if (score[i2] < 0) continue;
                int n4 = i2;
                score[n4] = score[n4] + 4;
            }
            while (hy > 0) {
                int iang = 0;
                for (int j = 1; j < 360; ++j) {
                    if (score[j] <= score[iang]) continue;
                    iang = j;
                }
                int num = this.mol.AddAtom("H", this.mol.AtomX(i) + Math.cos((double)iang * Math.PI / 180.0), this.mol.AtomY(i) + Math.sin((double)iang * Math.PI / 180.0));
                this.mol.AddBond(i, num, 1);
                score[iang] = -1;
                score[(iang + 1) % 360] = -1;
                score[(iang + 359) % 360] = -1;
                i0 = (iang + 180) % 360;
                i1 = (iang + 120) % 360;
                i2 = (iang + 240) % 360;
                if (score[i0] >= 0) {
                    int n5 = i0;
                    score[n5] = score[n5] + 1;
                }
                if (score[i1] >= 0) {
                    int n6 = i1;
                    score[n6] = score[n6] + 2;
                }
                if (score[i2] >= 0) {
                    int n7 = i2;
                    score[n7] = score[n7] + 2;
                }
                --hy;
            }
            this.mol.SetAtomHExplicit(i, -1);
        }
        this.ClearTemporary();
        this.DetermineSize();
        this.repaint();
        this.CheckDirtiness();
    }

    public void HydrogenDeleteActual() {
        int n;
        ArrayList<Integer> sel = this.SelectedIndices();
        ArrayList<Integer> chop = new ArrayList<Integer>();
        for (n = 0; n < sel.size(); ++n) {
            int i = sel.get(n);
            if (this.mol.AtomElement(i).compareTo("H") == 0) {
                chop.add(new Integer(i));
            }
            int[] adj = this.mol.AtomAdjList(i);
            for (int j = 0; j < adj.length; ++j) {
                if (this.mol.AtomElement(adj[j]).compareTo("H") != 0) continue;
                chop.add(adj[j]);
            }
        }
        if (chop.size() == 0) {
            return;
        }
        this.CacheUndo();
        Collections.sort(chop);
        for (n = 0; n < chop.size(); ++n) {
            int[] adj = this.mol.AtomAdjList((Integer)chop.get(n));
            for (int i = 0; i < adj.length; ++i) {
                this.mol.SetAtomHExplicit(adj[i], -1);
            }
        }
        int decr = 0;
        int lastVal = -1;
        for (int n2 = 0; n2 < chop.size(); ++n2) {
            int i = (Integer)chop.get(n2);
            if (i == lastVal) continue;
            this.mol.DeleteAtomAndBonds(i - decr);
            ++decr;
            lastVal = i;
        }
        this.ClearTemporary();
        this.DetermineSize();
        this.repaint();
        this.CheckDirtiness();
    }

    public void NormaliseBondLengths() {
        double numer = 0.0;
        double denom = 0.0;
        for (int n = 1; n <= this.mol.NumBonds(); ++n) {
            double dx = this.mol.AtomX(this.mol.BondFrom(n)) - this.mol.AtomX(this.mol.BondTo(n));
            double dy = this.mol.AtomY(this.mol.BondFrom(n)) - this.mol.AtomY(this.mol.BondTo(n));
            double weight = this.mol.BondInRing(n) ? 1.0 : 2.0;
            numer += Math.sqrt(dx * dx + dy * dy) * weight;
            denom += weight;
        }
        if (denom == 0.0) {
            return;
        }
        this.CacheUndo();
        double stretch = 1.5 * denom / numer;
        for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
            this.mol.SetAtomPos(n, this.mol.AtomX(n) * stretch, this.mol.AtomY(n) * stretch);
        }
        this.ClearTemporary();
        this.DetermineSize();
        this.repaint();
    }

    public void CycleSelection(boolean Forward, boolean Group) {
        int pos;
        int max;
        if (this.mol.NumAtoms() <= 1) {
            return;
        }
        int high = 0;
        if (this.selected != null) {
            for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
                if (!this.selected[n - 1]) continue;
                if (Group) {
                    if (this.mol.AtomConnComp(n) <= high) continue;
                    high = this.mol.AtomConnComp(n);
                    continue;
                }
                high = n;
            }
        }
        int n = max = Group ? 0 : this.mol.NumAtoms();
        if (Group) {
            for (int n2 = 1; n2 <= this.mol.NumAtoms(); ++n2) {
                if (this.mol.AtomConnComp(n2) <= max) continue;
                max = this.mol.AtomConnComp(n2);
            }
        }
        int n3 = pos = Forward ? high + 1 : high - 1;
        if (pos < 1) {
            pos = max;
        }
        if (pos > max) {
            pos = 1;
        }
        this.selected = new boolean[this.mol.NumAtoms()];
        for (int n4 = 1; n4 <= this.mol.NumAtoms(); ++n4) {
            this.selected[n4 - 1] = Group ? this.mol.AtomConnComp(n4) == pos : n4 == pos;
        }
        this.ClearTemporary(false);
        this.repaint();
    }

    public void NudgeSelectedAtoms(double DX, double DY) {
        if (this.selected == null) {
            return;
        }
        this.CacheUndo();
        for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
            if (!this.selected[n - 1]) continue;
            this.mol.SetAtomPos(n, this.mol.AtomX(n) + DX, this.mol.AtomY(n) + DY);
        }
        this.ClearTemporary(false);
        this.DetermineSize();
        this.repaint();
    }

    public void FlipSelectedAtoms(boolean Vertical) {
        int n;
        if (this.selected == null) {
            return;
        }
        int count = 0;
        double cx = 0.0;
        double cy = 0.0;
        for (n = 1; n <= this.mol.NumAtoms(); ++n) {
            if (!this.selected[n - 1]) continue;
            cx += this.mol.AtomX(n);
            cy += this.mol.AtomY(n);
            ++count;
        }
        if (count == 0) {
            return;
        }
        this.CacheUndo();
        cx /= (double)count;
        cy /= (double)count;
        for (n = 1; n <= this.mol.NumAtoms(); ++n) {
            if (!this.selected[n - 1]) continue;
            if (Vertical) {
                this.mol.SetAtomPos(n, this.mol.AtomX(n), 2.0 * cy - this.mol.AtomY(n));
                continue;
            }
            this.mol.SetAtomPos(n, 2.0 * cx - this.mol.AtomX(n), this.mol.AtomY(n));
        }
        this.ClearTemporary(false);
        this.DetermineSize();
        this.repaint();
    }

    public void RotateSelectedAtoms(double Degrees) {
        if (this.selected == null) {
            return;
        }
        int count = 0;
        double cx = 0.0;
        double cy = 0.0;
        for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
            if (!this.selected[n - 1]) continue;
            cx += this.mol.AtomX(n);
            cy += this.mol.AtomY(n);
            ++count;
        }
        if (count == 0) {
            return;
        }
        this.CacheUndo();
        cx /= (double)count;
        cy /= (double)count;
        double radians = Degrees * Math.PI / 180.0;
        for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
            if (!this.selected[n - 1]) continue;
            double dx = this.mol.AtomX(n) - cx;
            double dy = this.mol.AtomY(n) - cy;
            double dist = Math.sqrt(dx * dx + dy * dy);
            double theta = Math.atan2(dy, dx);
            this.mol.SetAtomPos(n, cx + dist * Math.cos(theta + radians), cy + dist * Math.sin(theta + radians));
        }
        this.ClearTemporary(false);
        this.DetermineSize();
        this.repaint();
    }

    public void SetStereo(int Operation) {
        int n;
        ArrayList<Integer> selidx = this.SelectedIndices();
        int[][] graph = new int[this.mol.NumAtoms()][];
        for (n = 0; n < this.mol.NumAtoms(); ++n) {
            graph[n] = this.mol.AtomAdjList(n + 1);
        }
        this.CacheUndo();
        for (n = 0; n < selidx.size(); ++n) {
            int a = selidx.get(n);
            int ster = this.mol.AtomChirality(a);
            if (Operation != 3 ? ster == Operation : ster != 1 && ster != 2) continue;
            if (ster == 1 || ster == 2) {
                for (int i = 1; i <= this.mol.NumBonds(); ++i) {
                    if (this.mol.BondFrom(i) != a) continue;
                    if (this.mol.BondType(i) == 1) {
                        this.mol.SetBondType(i, 2);
                        continue;
                    }
                    if (this.mol.BondType(i) != 2) continue;
                    this.mol.SetBondType(i, 1);
                }
                continue;
            }
            ArrayList<int[]> perm = this.WedgeFormations(a, Operation);
            if (perm == null || perm.size() <= 0) continue;
            int[] adj = this.mol.AtomAdjList(a);
            for (int i = 0; i < adj.length; ++i) {
                int j = this.mol.FindBond(a, adj[i]);
                if (j == 0) continue;
                this.mol.SetBondType(j, perm.get(0)[i] < 0 ? 2 : (perm.get(0)[i] > 0 ? 1 : 0));
                if (this.mol.BondFrom(j) == a) continue;
                this.mol.SetBondFromTo(j, this.mol.BondTo(j), this.mol.BondFrom(j));
            }
        }
        for (n = 1; n <= this.mol.NumBonds(); ++n) {
            int i;
            boolean changed;
            int ster;
            int bf = this.mol.BondFrom(n);
            int bt = this.mol.BondTo(n);
            if (this.mol.BondOrder(n) == 2 && selidx.indexOf(bf) < 0 && selidx.indexOf(bt) < 0 || (ster = this.mol.BondStereo(n)) != 1 && ster != 2 || ster == Operation || this.mol.AtomRingBlock(bf) != 0 && this.mol.AtomRingBlock(bf) != this.mol.AtomRingBlock(bt)) continue;
            int sc1 = 1;
            int sc2 = 1;
            int[] side = new int[this.mol.NumAtoms()];
            for (int i2 = 0; i2 < this.mol.NumAtoms(); ++i2) {
                side[i2] = 0;
            }
            side[bf - 1] = 1;
            side[bt - 1] = 2;
            do {
                changed = false;
                for (int i3 = 0; i3 < this.mol.NumAtoms(); ++i3) {
                    if (side[i3] != 0) continue;
                    for (int j = 0; j < graph[i3].length; ++j) {
                        if (side[graph[i3][j] - 1] == 0) continue;
                        side[i3] = side[graph[i3][j] - 1];
                        if (side[i3] == 1) {
                            ++sc1;
                        } else {
                            ++sc2;
                        }
                        changed = true;
                    }
                }
            } while (changed);
            int which = sc1 <= sc2 ? 1 : 2;
            double cx = this.mol.AtomX(which == 1 ? bf : bt);
            double cy = this.mol.AtomY(which == 1 ? bf : bt);
            double axis = Math.atan2(cy - this.mol.AtomY(which == 1 ? bt : bf), cx - this.mol.AtomX(which == 1 ? bt : bf));
            for (i = 0; i < this.mol.NumAtoms(); ++i) {
                if (side[i] != which) continue;
                double dx = this.mol.AtomX(i + 1) - cx;
                double dy = this.mol.AtomY(i + 1) - cy;
                double r = Math.sqrt(dx * dx + dy * dy);
                double th = Math.atan2(dy, dx);
                th = 2.0 * axis - th;
                this.mol.SetAtomPos(i + 1, cx + r * Math.cos(th), cy + r * Math.sin(th));
            }
            for (i = 1; i <= this.mol.NumBonds(); ++i) {
                if (this.mol.BondType(i) != 1 && this.mol.BondType(i) != 2 || side[this.mol.BondFrom(i) - 1] != which || side[this.mol.BondTo(i) - 1] != which) continue;
                this.mol.SetBondType(i, this.mol.BondType(i) == 1 ? 2 : 1);
            }
        }
        this.ClearTemporary(false);
        this.DetermineSize();
        this.repaint();
    }

    public void RemoveChiralWedges() {
        this.CacheUndo();
        ArrayList<Integer> selidx = this.SelectedIndices();
        for (int n = 0; n < selidx.size(); ++n) {
            if (this.mol.AtomChirality(selidx.get(n)) == 0) continue;
            for (int i = 1; i <= this.mol.NumBonds(); ++i) {
                if (this.mol.BondFrom(i) != selidx.get(n).intValue() && this.mol.BondTo(i) != selidx.get(n).intValue() || this.mol.BondType(i) != 1 && this.mol.BondType(i) != 2) continue;
                this.mol.SetBondType(i, 0);
            }
        }
        this.repaint();
    }

    public void CycleChiralWedges() {
        this.CacheUndo();
        ArrayList<Integer> selidx = this.SelectedIndices();
        for (int n = 0; n < selidx.size(); ++n) {
            int i;
            ArrayList<int[]> perm;
            int a = selidx.get(n);
            int chi = this.mol.AtomChirality(a);
            if (chi != 1 && chi != 2 || (perm = this.WedgeFormations(a, chi)).size() <= 1) continue;
            int[] adj = this.mol.AtomAdjList(a);
            int[] curperm = new int[adj.length];
            for (int i2 = 0; i2 < adj.length; ++i2) {
                int j = this.mol.FindBond(a, adj[i2]);
                curperm[i2] = this.mol.BondType(j) == 1 ? 1 : (this.mol.BondType(j) == 2 ? -1 : 0);
            }
            int match = -1;
            for (i = 0; i < perm.size(); ++i) {
                int[] thisperm = perm.get(i);
                boolean same = true;
                for (int j = 0; j < curperm.length; ++j) {
                    if (thisperm[j] == curperm[j]) continue;
                    same = false;
                    break;
                }
                if (!same) continue;
                match = i;
                break;
            }
            match = (match + 1) % perm.size();
            curperm = perm.get(match);
            for (i = 0; i < adj.length; ++i) {
                int j = this.mol.FindBond(a, adj[i]);
                if (this.mol.BondFrom(j) != a) {
                    this.mol.SetBondFromTo(j, a, adj[i]);
                }
                this.mol.SetBondType(j, curperm[i] < 0 ? 2 : (curperm[i] > 0 ? 1 : 0));
            }
        }
        this.repaint();
    }

    double AngToX(double AX) {
        return (this.offsetX + AX) * this.scale;
    }

    double AngToY(double AY) {
        return (this.offsetY - AY) * this.scale;
    }

    double XToAng(double PX) {
        return PX / this.scale - this.offsetX;
    }

    double YToAng(double PY) {
        return -PY / this.scale + this.offsetY;
    }

    void DetermineSize() {
        int h;
        int w;
        if (!this.isSelectionPane) {
            w = Math.max((int)this.AngToX(this.mol.MaxX() + 1.0), 500);
            h = Math.max((int)this.AngToY(this.mol.MinY() - 1.0), 500);
        } else {
            w = this.selBoxW;
            h = this.selBoxH;
        }
        this.setPreferredSize(new Dimension(w, h));
        this.setSize(w, h);
    }

    void ClearTemporary() {
        this.ClearTemporary(true);
    }

    void ClearTemporary(boolean AndSelected) {
        this.rh = null;
        this.rw = null;
        this.py = null;
        this.px = null;
        this.highlightBond = 0;
        this.highlightAtom = 0;
        if (AndSelected) {
            this.selected = null;
        } else if (this.selected != null && this.selected.length != this.mol.NumAtoms()) {
            boolean[] newSelected = new boolean[this.mol.NumAtoms()];
            for (int n = 0; n < this.selected.length; ++n) {
                newSelected[n] = this.selected[n];
            }
            this.selected = newSelected;
        }
    }

    void ResetSelected(boolean Clear) {
        if (this.selected == null) {
            this.selected = new boolean[this.mol.NumAtoms()];
        }
        if (Clear) {
            for (int n = 0; n < this.mol.NumAtoms(); ++n) {
                this.selected[n] = false;
            }
        }
    }

    int PickAtom(int X, int Y) {
        if (this.px == null || this.py == null) {
            return 0;
        }
        for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
            double dx = (double)X - this.px[n - 1];
            double dy = (double)Y - this.py[n - 1];
            if (!(Math.abs(dx) <= this.rw[n - 1]) || !(Math.abs(dy) <= this.rh[n - 1]) || !(dx * dx / (this.rw[n - 1] * this.rw[n - 1]) + dy * dy / (this.rh[n - 1] * this.rh[n - 1]) <= 1.0)) continue;
            return n;
        }
        return 0;
    }

    int PickBond(int X, int Y) {
        if (this.px == null || this.py == null) {
            return 0;
        }
        for (int n = 1; n <= this.mol.NumBonds(); ++n) {
            double x1 = this.px[this.mol.BondFrom(n) - 1];
            double y1 = this.py[this.mol.BondFrom(n) - 1];
            double x2 = this.px[this.mol.BondTo(n) - 1];
            double y2 = this.py[this.mol.BondTo(n) - 1];
            double nx1 = x1;
            double ny1 = y1;
            double nx2 = x2;
            double ny2 = y2;
            int delta = Math.max(2, (int)(this.scale / 20.0));
            if (nx1 > nx2) {
                nx1 = x2;
                nx2 = x1;
            }
            if (ny1 > ny2) {
                ny1 = y2;
                ny2 = y1;
            }
            if ((double)X < nx1 - (double)(2 * delta) || (double)X > nx2 + (double)(2 * delta) || (double)Y < ny1 - (double)(2 * delta) || (double)Y > ny2 + (double)(2 * delta)) continue;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double d = Math.abs(dx) > Math.abs(dy) ? (double)Y - y1 - ((double)X - x1) * dy / dx : (double)X - x1 - ((double)Y - y1) * dx / dy;
            if (Math.abs(d) > (double)((2 + this.mol.BondOrder(n)) * delta)) continue;
            return n;
        }
        return 0;
    }

    void SnapToolBond() {
        double cx = this.toolBondFrom > 0 ? this.mol.AtomX(this.toolBondFrom) : this.toolBondFromX;
        double cy = this.toolBondFrom > 0 ? this.mol.AtomY(this.toolBondFrom) : this.toolBondFromY;
        double dx = this.toolBondToX - cx;
        double dy = this.toolBondToY - cy;
        double th = Math.atan2(dy, dx) * 180.0 / Math.PI;
        double ext = Math.sqrt(dx * dx + dy * dy);
        th = (double)(Math.round(th / 30.0) * 30L) * Math.PI / 180.0;
        ext = (double)Math.round(ext / 1.5) * 1.5;
        this.toolBondToX = cx + ext * Math.cos(th);
        this.toolBondToY = cy + ext * Math.sin(th);
    }

    void CacheUndo() {
        if (this.undo == null) {
            this.undo = new EditState[10];
        }
        this.redo = null;
        for (int n = 9; n > 0; --n) {
            this.undo[n] = this.undo[n - 1];
        }
        this.undo[0] = new EditState();
        this.undo[0].Molecule = this.mol == null ? null : this.mol.Clone();
        this.undo[0].Selected = this.selected == null ? null : (boolean[])this.selected.clone();
    }

    void CompleteAtomEdit() {
        if (this.toolAtomEditBox == null) {
            return;
        }
        String el = this.toolAtomEditBox.getText();
        if (el.length() > 0) {
            this.CacheUndo();
            if (el.charAt(0) >= 'a' && el.charAt(0) <= 'z') {
                el = el.substring(0, 1).toUpperCase() + el.substring(1);
            }
            if (this.toolAtomEditSel == 0) {
                this.mol.AddAtom(el, this.XToAng(this.toolAtomEditX), this.YToAng(this.toolAtomEditY));
                this.ClearTemporary();
                this.DetermineSize();
            } else {
                this.mol.SetAtomElement(this.toolAtomEditSel, el);
            }
        }
        this.toolAtomEditBox.setVisible(false);
        this.remove(this.toolAtomEditBox);
        this.toolAtomEditBox = null;
        this.repaint();
        this.CheckDirtiness();
    }

    void AdjustTemplateByAtom(int Atom2) {
        int n;
        this.templDraw = this.template.Clone();
        ArrayList<Integer> bonded = new ArrayList<Integer>();
        for (int n2 = 1; n2 <= this.mol.NumBonds(); ++n2) {
            if (this.mol.BondFrom(n2) == Atom2) {
                bonded.add(new Integer(this.mol.BondTo(n2)));
            }
            if (this.mol.BondTo(n2) != Atom2) continue;
            bonded.add(new Integer(this.mol.BondFrom(n2)));
        }
        boolean INCR = true;
        double[] rotScores = new double[360];
        for (int n3 = 1; n3 <= this.templDraw.NumAtoms(); ++n3) {
            if (n3 == this.templateIdx) continue;
            double x = this.template.AtomX(n3) - this.template.AtomX(this.templateIdx);
            double y = this.template.AtomY(n3) - this.template.AtomY(this.templateIdx);
            double th = Math.atan2(y, x);
            double ext = Math.sqrt(x * x + y * y);
            for (int i = 0; i < 360; ++i) {
                double rx = this.mol.AtomX(Atom2) + ext * Math.cos(th + (double)(i * 1) * Math.PI / 180.0);
                double ry = this.mol.AtomY(Atom2) + ext * Math.sin(th + (double)(i * 1) * Math.PI / 180.0);
                for (int j = 0; j < bonded.size(); ++j) {
                    double dy;
                    int k = (Integer)bonded.get(j);
                    double dx = this.mol.AtomX(k) - rx;
                    double ext2 = dx * dx + (dy = this.mol.AtomY(k) - ry) * dy;
                    if (ext2 < 0.01) {
                        ext2 = 0.01;
                    }
                    int n4 = i;
                    rotScores[n4] = rotScores[n4] + 1.0 / ext2;
                }
            }
        }
        int bestRot = 0;
        for (n = 1; n < 360; ++n) {
            if (!(rotScores[n] < rotScores[bestRot])) continue;
            bestRot = n;
        }
        for (n = 1; n <= this.templDraw.NumAtoms(); ++n) {
            double x = this.template.AtomX(n) - this.template.AtomX(this.templateIdx);
            double y = this.template.AtomY(n) - this.template.AtomY(this.templateIdx);
            double th = Math.atan2(y, x);
            double ext = Math.sqrt(x * x + y * y);
            this.templDraw.SetAtomPos(n, this.mol.AtomX(Atom2) + ext * Math.cos(th + (double)(bestRot * 1) * Math.PI / 180.0), this.mol.AtomY(Atom2) + ext * Math.sin(th + (double)(bestRot * 1) * Math.PI / 180.0));
        }
    }

    boolean AdjustTemplateByBond(int Bond2) {
        Molecule[] rotMol = new Molecule[2];
        double[] rotScores = new double[2];
        for (int r = 0; r < 2; ++r) {
            rotMol[r] = this.template.Clone();
            int imol1 = r == 0 ? this.mol.BondFrom(Bond2) : this.mol.BondTo(Bond2);
            int imol2 = r == 0 ? this.mol.BondTo(Bond2) : this.mol.BondFrom(Bond2);
            int irot1 = this.template.BondFrom(-this.templateIdx);
            int irot2 = this.template.BondTo(-this.templateIdx);
            double dtheta = Math.atan2(this.mol.AtomY(imol2) - this.mol.AtomY(imol1), this.mol.AtomX(imol2) - this.mol.AtomX(imol1)) - Math.atan2(this.template.AtomY(irot2) - this.template.AtomY(irot1), this.template.AtomX(irot2) - this.template.AtomX(irot1));
            for (int n = 1; n <= this.template.NumAtoms(); ++n) {
                double rx = this.template.AtomX(n) - this.template.AtomX(irot1);
                double ry = this.template.AtomY(n) - this.template.AtomY(irot1);
                double th = Math.atan2(ry, rx);
                double ext = Math.sqrt(rx * rx + ry * ry);
                rx = this.mol.AtomX(imol1) + ext * Math.cos(th + dtheta);
                ry = this.mol.AtomY(imol1) + ext * Math.sin(th + dtheta);
                rotMol[r].SetAtomPos(n, rx, ry);
                for (int i = 1; i <= this.mol.NumAtoms(); ++i) {
                    double dy;
                    double dx = this.mol.AtomX(i) - rx;
                    double ext2 = dx * dx + (dy = this.mol.AtomY(i) - ry) * dy;
                    if (ext2 < 0.01) {
                        ext2 = 0.01;
                    }
                    int n2 = r;
                    rotScores[n2] = rotScores[n2] + 1.0 / ext2;
                }
            }
        }
        boolean swap = rotScores[0] < rotScores[1];
        this.templDraw = rotMol[swap ? 0 : 1];
        return swap;
    }

    void AdjustTemplateByCoord(double X, double Y) {
        this.templDraw = this.template.Clone();
        double dx = 0.0;
        double dy = 0.0;
        if (this.templateIdx > 0) {
            dx = this.template.AtomX(this.templateIdx);
            dy = this.template.AtomY(this.templateIdx);
        } else if (this.templateIdx < 0) {
            int from = this.template.BondFrom(-this.templateIdx);
            int to = this.template.BondTo(-this.templateIdx);
            dx = 0.5 * (this.template.AtomX(from) + this.template.AtomX(to));
            dy = 0.5 * (this.template.AtomY(from) + this.template.AtomY(to));
        }
        for (int n = 1; n <= this.template.NumAtoms(); ++n) {
            this.templDraw.SetAtomPos(n, this.template.AtomX(n) - dx + X, this.template.AtomY(n) - dy + Y);
        }
    }

    void TemplateSetByAtom(int JoinAtom) {
        int n;
        int[] map = new int[this.templDraw.NumAtoms()];
        int oldNum = this.mol.NumAtoms();
        for (n = 1; n <= this.templDraw.NumAtoms(); ++n) {
            if (JoinAtom != 0 && n == this.templateIdx) continue;
            this.mol.AddAtom(this.templDraw.AtomElement(n), this.templDraw.AtomX(n), this.templDraw.AtomY(n), this.templDraw.AtomCharge(n), this.templDraw.AtomUnpaired(n));
        }
        for (n = 1; n <= this.templDraw.NumBonds(); ++n) {
            int from = this.templDraw.BondFrom(n);
            int to = this.templDraw.BondTo(n);
            if (JoinAtom > 0) {
                if (from == this.templateIdx) {
                    from = JoinAtom;
                } else {
                    if (from > this.templateIdx) {
                        --from;
                    }
                    from += oldNum;
                }
                if (to == this.templateIdx) {
                    to = JoinAtom;
                } else {
                    if (to > this.templateIdx) {
                        --to;
                    }
                    to += oldNum;
                }
            } else {
                from += oldNum;
                to += oldNum;
            }
            this.mol.AddBond(from, to, this.templDraw.BondOrder(n), this.templDraw.BondType(n));
        }
        this.MergeNewAtoms(oldNum);
        this.ClearTemporary();
        this.DetermineSize();
        this.repaint();
    }

    void TemplateSetByBond(int JoinBond, boolean Swap) {
        int n;
        int[] map = new int[this.templDraw.NumAtoms()];
        int oldNum = this.mol.NumAtoms();
        int joinFrom = JoinBond > 0 ? this.mol.BondFrom(JoinBond) : 0;
        int joinTo = JoinBond > 0 ? this.mol.BondTo(JoinBond) : 0;
        int newFrom = Swap ? this.templDraw.BondFrom(-this.templateIdx) : this.templDraw.BondTo(-this.templateIdx);
        int newTo = Swap ? this.templDraw.BondTo(-this.templateIdx) : this.templDraw.BondFrom(-this.templateIdx);
        for (n = 1; n <= this.templDraw.NumAtoms(); ++n) {
            map[n - 1] = n == newFrom && JoinBond > 0 ? joinFrom : (n == newTo && JoinBond > 0 ? joinTo : this.mol.AddAtom(this.templDraw.AtomElement(n), this.templDraw.AtomX(n), this.templDraw.AtomY(n), this.templDraw.AtomCharge(n), this.templDraw.AtomUnpaired(n)));
        }
        for (n = 1; n <= this.template.NumBonds(); ++n) {
            if (n == -this.templateIdx && JoinBond != 0) continue;
            this.mol.AddBond(map[this.templDraw.BondFrom(n) - 1], map[this.templDraw.BondTo(n) - 1], this.templDraw.BondOrder(n), this.templDraw.BondType(n));
        }
        this.MergeNewAtoms(oldNum);
        this.ClearTemporary();
        this.DetermineSize();
        this.repaint();
    }

    void MergeNewAtoms(int Watermark) {
        int pos = Watermark + 1;
        while (pos <= this.mol.NumAtoms()) {
            int close = 0;
            for (int n = 1; n <= Watermark; ++n) {
                double dy;
                double dx = this.mol.AtomX(n) - this.mol.AtomX(pos);
                if (!(dx * dx + (dy = this.mol.AtomY(n) - this.mol.AtomY(pos)) * dy < 0.04000000000000001)) continue;
                close = n;
                break;
            }
            if (close > 0) {
                int[] adj = this.mol.AtomAdjList(pos);
                for (int i = 0; i < adj.length; ++i) {
                    if (this.mol.FindBond(close, adj[i]) != 0) continue;
                    int j = this.mol.FindBond(pos, adj[i]);
                    this.mol.AddBond(close, adj[i], this.mol.BondOrder(j));
                }
                this.mol.DeleteAtomAndBonds(pos);
                continue;
            }
            ++pos;
        }
    }

    boolean AnySelected() {
        if (this.selected == null) {
            return false;
        }
        for (int n = 0; n < this.mol.NumAtoms(); ++n) {
            if (!this.selected[n]) continue;
            return true;
        }
        return false;
    }

    double DragExtendBy(double px, double py) {
        double diff = 0.2 * Math.sqrt(px * px + py * py) / this.scale;
        if (px < 0.0 && py < 0.0) {
            diff = -diff;
        }
        if (diff >= 0.0) {
            return 1.0 + diff;
        }
        return Math.exp(diff);
    }

    ArrayList<int[]> WedgeFormations(int N, int Chi) {
        int n;
        int[] wedges;
        int iz;
        int i;
        if (this.mol.AtomAdjCount(N) != 3 && this.mol.AtomAdjCount(N) != 4) {
            return null;
        }
        int[] adj = this.mol.AtomAdjList(N);
        for (int i2 = 0; i2 < adj.length - 1; ++i2) {
            for (int j = i2 + 1; j < adj.length; ++j) {
                if (this.mol.AtomPriority(adj[i2]) != this.mol.AtomPriority(adj[j])) continue;
                return null;
            }
        }
        int[] badj = new int[adj.length];
        for (int n2 = 0; n2 < adj.length; ++n2) {
            badj[n2] = this.mol.FindBond(N, adj[n2]);
        }
        ArrayList<int[]> perm = new ArrayList<int[]>();
        if (adj.length == 3) {
            for (i = 0; i < 3; ++i) {
                for (iz = -1; iz <= 1; iz += 2) {
                    wedges = new int[3];
                    for (n = 0; n < 3; ++n) {
                        wedges[n] = 0;
                    }
                    wedges[i] = iz;
                    perm.add(wedges);
                }
            }
        } else {
            for (i = 0; i < 4; ++i) {
                for (iz = -1; iz <= 1; iz += 2) {
                    wedges = new int[4];
                    for (n = 0; n < 4; ++n) {
                        wedges[n] = 0;
                    }
                    wedges[i] = iz;
                    perm.add(wedges);
                    for (int j = i + 1; j < 4; ++j) {
                        for (int jz = -1; jz <= 1; jz += 2) {
                            if (jz == iz) continue;
                            wedges = new int[4];
                            for (int n3 = 0; n3 < 4; ++n3) {
                                wedges[n3] = 0;
                            }
                            wedges[i] = iz;
                            wedges[j] = jz;
                            perm.add(wedges);
                        }
                    }
                }
            }
        }
        int pos = 0;
        while (pos < perm.size()) {
            int[] wedges2 = (int[])perm.get(pos);
            Molecule mchi = this.mol.Clone();
            for (n = 0; n < adj.length; ++n) {
                mchi.SetBondType(badj[n], wedges2[n] < 0 ? 2 : (wedges2[n] > 0 ? 1 : 0));
                if (mchi.BondFrom(badj[n]) == N) continue;
                this.mol.SetBondFromTo(badj[n], this.mol.BondTo(badj[n]), this.mol.BondFrom(badj[n]));
            }
            if (mchi.AtomChirality(N) != Chi) {
                perm.remove(pos);
                continue;
            }
            ++pos;
        }
        double[] score = new double[perm.size()];
        for (int n4 = 0; n4 < perm.size(); ++n4) {
            score[n4] = 0.0;
            int[] wedges3 = (int[])perm.get(n4);
            int wcount = 0;
            for (int i3 = 0; i3 < adj.length; ++i3) {
                if (wedges3[i3] == 0) continue;
                ++wcount;
                int n5 = n4;
                score[n5] = score[n5] - 0.5 * (double)this.mol.AtomPriority(adj[i3]) / (double)this.mol.NumAtoms();
                if (this.mol.AtomAdjCount(adj[i3]) == 1) {
                    int n6 = n4;
                    score[n6] = score[n6] + 1.0;
                }
                if (this.mol.AtomRingBlock(adj[i3]) <= 0) continue;
                int n7 = n4;
                score[n7] = score[n7] - 1.0;
                if (this.mol.AtomRingBlock(N) != this.mol.AtomRingBlock(adj[i3])) continue;
                int n8 = n4;
                score[n8] = score[n8] - 1.0;
            }
            if (adj.length != 4 || wcount != 2) continue;
            int n9 = n4;
            score[n9] = score[n9] + 1.0;
        }
        pos = 0;
        while (pos < perm.size() - 1) {
            if (score[pos] < score[pos + 1]) {
                int[] w1 = perm.get(pos);
                int[] w2 = perm.get(pos + 1);
                perm.set(pos + 1, w1);
                perm.set(pos, w2);
                double s = score[pos];
                score[pos] = score[pos + 1];
                score[pos + 1] = s;
                if (pos <= 0) continue;
                --pos;
                continue;
            }
            ++pos;
        }
        return perm;
    }

    @Override
    protected void paintComponent(Graphics gr) {
        if (this.autoScale) {
            this.ScaleToFit();
        }
        Color b = new Color(255, 255, 255);
        gr.setColor(b);
        gr.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.hasBorder) {
            gr.setColor(Color.BLACK);
            gr.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawMolecule draw = new DrawMolecule(this.mol, g);
        draw.SetBackground(this.getBackground());
        draw.SetShowHydr(this.showHydr);
        draw.SetShowMode(this.showMode);
        draw.SetShowStereo(this.showSter);
        draw.SetTransform(this.offsetX, this.offsetY, this.scale);
        draw.SetHighlight(this.highlightAtom, this.highlightBond);
        this.ResetSelected(false);
        draw.SetSelected(this.selected, this.dragged);
        if (this.tool == 4 && this.toolAtomDrag || this.tool == 5 && this.toolBondFrom > 0) {
            draw.BondInProgress(this.toolBondFrom, this.toolBondToX, this.toolBondToY, this.toolBondOrder, this.toolBondType);
        }
        if (this.tool == 4 && this.toolAtomDrag && this.toolAtomType != null && this.toolAtomType.compareTo("C") != 0) {
            draw.AtomInProgress(this.toolAtomType, this.toolBondToX, this.toolBondToY);
        }
        if (this.tool == 5 && this.toolBondFrom == 0 && this.toolBondDrag) {
            int i = this.PickAtom((int)this.AngToX(this.toolBondToX), (int)this.AngToY(this.toolBondToY));
            if (i == 0 && this.toolSnap) {
                this.SnapToolBond();
            }
            double x1 = this.toolBondFromX;
            double y1 = this.toolBondFromY;
            double x2 = this.toolBondToX;
            double y2 = this.toolBondToY;
            if (i > 0) {
                x2 = this.mol.AtomX(i);
                y2 = this.mol.AtomY(i);
            }
            draw.NewBondLine(x1, y1, x2, y2);
        }
        if (this.toolDragReason == 1) {
            draw.DragSelect((int)this.toolDragX1, (int)this.toolDragY1, (int)this.toolDragX2, (int)this.toolDragY2);
        }
        if (!(this.toolDragReason != 2 && this.toolDragReason != 3 && this.toolDragReason != 4 || this.toolDragX1 == this.toolDragX2 && this.toolDragY1 == this.toolDragY2)) {
            if (this.toolDragReason == 4) {
                double extmul = this.DragExtendBy(this.toolDragX2 - this.toolDragX1, this.toolDragY2 - this.toolDragY1);
                double cx = 0.0;
                double cy = 0.0;
                int count = 0;
                for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
                    if (!this.selected[n - 1]) continue;
                    cx += this.mol.AtomX(n);
                    cy += this.mol.AtomY(n);
                    ++count;
                }
                draw.DragScale(cx /= (double)count, cy /= (double)count, extmul);
            } else {
                int dx = (int)(this.toolDragX2 - this.toolDragX1);
                int dy = (int)(this.toolDragY2 - this.toolDragY1);
                draw.DragMove(dx, dy, this.toolDragReason == 3);
            }
        }
        if (this.toolDragReason == 5 && (Math.abs(this.toolDragX2 - this.toolDragX1) > 5.0 || Math.abs(this.toolDragY2 - this.toolDragY1) > 5.0)) {
            double dx = this.toolDragX2 - this.toolDragX1;
            double dy = this.toolDragY2 - this.toolDragY1;
            double th = -Math.atan2(dy, dx) * 180.0 / Math.PI;
            if (this.toolSnap) {
                th = Math.round(th / 15.0) * 15L;
            }
            draw.DragRotate(th, (int)this.toolDragX1, (int)this.toolDragY1);
        }
        if (this.tool == 7 && this.trackX >= 0 && this.trackY >= 0) {
            if (this.highlightAtom != 0 && this.templateIdx > 0) {
                this.AdjustTemplateByAtom(this.highlightAtom);
            } else if (this.highlightBond != 0 && this.templateIdx < 0) {
                this.AdjustTemplateByBond(this.highlightBond);
            } else {
                this.AdjustTemplateByCoord(this.XToAng(this.trackX), this.YToAng(this.trackY));
            }
            draw.OutlineTemplate(this.templDraw);
        }
        draw.Draw();
        this.px = draw.GetPX();
        this.py = draw.GetPY();
        this.rw = draw.GetRW();
        this.rh = draw.GetRH();
        this.bfx = draw.GetBFX();
        this.bfy = draw.GetBFY();
        this.btx = draw.GetBTX();
        this.bty = draw.GetBTY();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && MainApplet.user_selection && this.tool == 8) {
            if (this.highlightAtom > 0) {
                if (this.highlightAtom > atomselection.length - 1) {
                    atomselection = EditorPane.GrowArray(atomselection, this.highlightAtom + 2);
                }
                EditorPane.atomselection[this.highlightAtom] = !atomselection[this.highlightAtom];
            }
            if (this.highlightBond > 0) {
                if (this.highlightBond > bondselection.length - 1) {
                    bondselection = EditorPane.GrowArray(bondselection, this.highlightBond + 2);
                }
                EditorPane.bondselection[this.highlightBond] = !bondselection[this.highlightBond];
            }
            this.repaint();
        } else if (this.tool == 1 && this.selectListen != null) {
            int i = this.PickAtom(e.getX(), e.getY());
            if ((e.getModifiers() & 2) > 0 && i > 0 && this.editable) {
                if ((e.getModifiers() & 1) == 0 && this.selected != null) {
                    for (int n = 0; n < this.mol.NumAtoms(); ++n) {
                        this.selected[n] = false;
                    }
                }
                if (this.selected == null) {
                    this.selected = new boolean[this.mol.NumAtoms()];
                }
                int cc = this.mol.AtomConnComp(i);
                for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
                    if (this.mol.AtomConnComp(n) != cc) continue;
                    this.selected[n - 1] = true;
                }
                this.repaint();
            } else if (i > 0) {
                this.selectListen.MolSelected(this, i, e.getClickCount() > 1);
            } else {
                i = this.PickBond(e.getX(), e.getY());
                this.selectListen.MolSelected(this, -i, e.getClickCount() > 1);
            }
        } else if (this.tool == 2) {
            this.selected = null;
            this.ClearTemporary();
            this.repaint();
        } else if (this.tool == 3) {
            int i = this.PickAtom(e.getX(), e.getY());
            if (i > 0) {
                this.CacheUndo();
                this.mol.DeleteAtomAndBonds(i);
            } else {
                this.CacheUndo();
                i = this.PickBond(e.getX(), e.getY());
                if (i > 0) {
                    this.mol.DeleteBond(i);
                }
            }
            if (i > 0) {
                this.ClearTemporary();
                this.DetermineSize();
                this.repaint();
            }
        } else if (this.tool == 4 && e.getButton() == 1 && !this.toolAtomDrag) {
            if (this.toolAtomEditBox != null) {
                this.CompleteAtomEdit();
                return;
            }
            if (this.toolAtomType != null) {
                int i = this.PickAtom(e.getX(), e.getY());
                this.CacheUndo();
                if (i == 0) {
                    i = this.mol.AddAtom(this.toolAtomType, this.XToAng(e.getX()), this.YToAng(e.getY()));
                    this.offsetX = (double)e.getX() / this.scale - this.mol.AtomX(i);
                    this.offsetY = (double)e.getY() / this.scale + this.mol.AtomY(i);
                } else {
                    this.mol.SetAtomElement(i, this.toolAtomType);
                }
                this.ClearTemporary();
                this.DetermineSize();
                this.repaint();
            } else {
                this.toolAtomEditX = e.getX();
                this.toolAtomEditY = e.getY();
                this.toolAtomEditSel = this.PickAtom(this.toolAtomEditX, this.toolAtomEditY);
                if (this.toolAtomEditSel == 0 && this.PickBond(e.getX(), e.getY()) > 0) {
                    return;
                }
                this.toolAtomEditBox = new JTextField(this.toolAtomEditSel > 0 ? this.mol.AtomElement(this.toolAtomEditSel) : "");
                this.add(this.toolAtomEditBox);
                this.toolAtomEditBox.addFocusListener(this);
                this.toolAtomEditBox.addKeyListener(this);
                this.toolAtomEditBox.setLocation(this.toolAtomEditX - 10, this.toolAtomEditY - 10);
                this.toolAtomEditBox.setSize(20, 20);
                this.toolAtomEditBox.setVisible(true);
                this.toolAtomEditBox.setSelectionStart(0);
                this.toolAtomEditBox.setSelectionEnd(this.toolAtomEditBox.getText().length());
                this.toolAtomEditBox.grabFocus();
            }
        } else if (this.tool == 7 && e.getButton() == 2) {
            boolean vertical = e.isShiftDown();
            for (int n = 1; n <= this.template.NumAtoms(); ++n) {
                this.template.SetAtomPos(n, this.template.AtomX(n) * (double)(vertical ? 1 : -1), this.template.AtomY(n) * (double)(vertical ? -1 : 1));
            }
            this.templDraw = this.template.Clone();
            this.repaint();
        }
        this.CheckDirtiness();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        boolean redraw = false;
        if (this.tool == 7 && (this.trackX != e.getX() || this.trackY != e.getY())) {
            redraw = true;
        }
        this.trackX = e.getX();
        this.trackY = e.getY();
        if (redraw) {
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        boolean redraw = false;
        if (this.tool == 7 && (this.trackX != e.getX() || this.trackY != e.getY())) {
            redraw = true;
        }
        this.trackX = -1;
        this.trackY = -1;
        if (redraw) {
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.grabFocus();
        if ((this.tool == 1 || this.tool == 2 && !this.AnySelected()) && e.getButton() == 1 && this.editable) {
            boolean anySelected;
            this.highlightBond = 0;
            this.highlightAtom = 0;
            boolean shift = (e.getModifiers() & 1) > 0;
            boolean ctrl = (e.getModifiers() & 2) > 0;
            boolean alt = (e.getModifiers() & 8) > 0;
            boolean bl = anySelected = this.CountSelected() > 0;
            if (this.tool == 2) {
                shift = false;
                ctrl = false;
                alt = false;
            }
            if (!ctrl && !alt) {
                this.ResetSelected(!shift);
                int atom = this.PickAtom(e.getX(), e.getY());
                if (atom > 0) {
                    this.selected[atom - 1] = true;
                } else {
                    this.toolDragReason = 1;
                }
            } else if (!shift && ctrl && !alt && anySelected) {
                this.toolDragReason = 3;
            } else if (!shift && !ctrl && alt && anySelected) {
                this.toolDragReason = 2;
            } else if (shift && !ctrl && alt && anySelected) {
                this.toolDragReason = 4;
            }
            this.toolDragX1 = this.toolDragX2 = (double)e.getX();
            this.toolDragY1 = this.toolDragY2 = (double)e.getY();
            this.repaint();
        } else if (this.tool == 3 && e.getButton() == 1) {
            this.highlightBond = 0;
            this.highlightAtom = 0;
            this.ResetSelected(true);
            this.toolDragReason = 1;
            this.toolDragX1 = this.toolDragX2 = (double)e.getX();
            this.toolDragY1 = this.toolDragY2 = (double)e.getY();
            this.repaint();
        } else if (this.tool == 4) {
            this.toolBondFrom = this.PickAtom(e.getX(), e.getY());
            this.toolAtomSnap = e.getButton() == 1;
        } else if (this.tool == 5 && (e.getButton() == 1 || e.getButton() == 3)) {
            this.highlightBond = 0;
            this.highlightAtom = 0;
            this.toolBondDrag = false;
            this.toolBondFrom = this.PickAtom(e.getX(), e.getY());
            boolean bl = this.toolSnap = e.getButton() == 1;
            if (this.toolBondFrom > 0) {
                this.toolBondToX = this.mol.AtomX(this.toolBondFrom);
                this.toolBondToY = this.mol.AtomY(this.toolBondFrom);
                this.repaint();
            }
            this.toolBondFromX = this.XToAng(e.getX());
            this.toolBondFromY = this.YToAng(e.getY());
            this.toolBondHit = this.PickBond(e.getX(), e.getY());
        } else if (this.tool == 7 && e.getButton() == 1) {
            boolean swap = false;
            if (this.highlightAtom != 0 && this.templateIdx > 0) {
                this.AdjustTemplateByAtom(this.highlightAtom);
            } else if (this.highlightBond != 0 && this.templateIdx < 0) {
                swap = this.AdjustTemplateByBond(this.highlightBond);
            } else {
                this.AdjustTemplateByCoord(this.XToAng(this.trackX), this.YToAng(this.trackY));
            }
            this.CacheUndo();
            if (this.templateIdx >= 0) {
                this.TemplateSetByAtom(this.highlightAtom);
            } else {
                this.TemplateSetByBond(this.highlightBond, swap);
            }
        } else if (this.tool == 2 && (e.getButton() == 1 || e.getButton() == 3) && this.AnySelected()) {
            this.toolDragReason = 5;
            boolean bl = this.toolSnap = e.getButton() == 1;
            if (this.highlightAtom > 0) {
                this.toolDragX1 = this.AngToX(this.mol.AtomX(this.highlightAtom));
                this.toolDragY1 = this.AngToY(this.mol.AtomY(this.highlightAtom));
            } else if (this.highlightBond > 0) {
                this.toolDragX1 = this.AngToX(0.5 * (this.mol.AtomX(this.mol.BondFrom(this.highlightBond)) + this.mol.AtomX(this.mol.BondTo(this.highlightBond))));
                this.toolDragY1 = this.AngToY(0.5 * (this.mol.AtomY(this.mol.BondFrom(this.highlightBond)) + this.mol.AtomY(this.mol.BondTo(this.highlightBond))));
            } else {
                this.toolDragX1 = e.getX();
                this.toolDragY1 = e.getY();
            }
            this.highlightBond = 0;
            this.highlightAtom = 0;
            this.toolDragX2 = this.toolDragX1;
            this.toolDragY2 = this.toolDragY1;
            this.repaint();
        } else if (this.tool == 6 && this.highlightAtom > 0) {
            int chg = this.mol.AtomCharge(this.highlightAtom);
            chg = e.getButton() == 1 ? (chg += this.toolCharge) : (e.getButton() == 3 ? (chg -= this.toolCharge) : 0);
            this.CacheUndo();
            this.mol.SetAtomCharge(this.highlightAtom, chg);
            this.repaint();
        }
        this.CheckDirtiness();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int n;
        if (this.tool == 1 && this.toolDragReason != 0 || this.tool == 2 && this.toolDragReason == 1 && this.editable) {
            double dy;
            this.toolDragX2 = e.getX();
            this.toolDragY2 = e.getY();
            double mx = this.toolDragX2 - this.toolDragX1;
            double my = this.toolDragY2 - this.toolDragY1;
            if (this.toolDragReason == 1 && this.dragged != null) {
                for (int n2 = 0; n2 < this.mol.NumAtoms(); ++n2) {
                    this.selected[n2] = this.selected[n2] || this.dragged[n2];
                }
            }
            if (this.toolDragReason == 2 && this.selected != null && mx * mx + my * my > 25.0) {
                double dx = mx / this.scale;
                dy = -my / this.scale;
                this.CacheUndo();
                for (int n3 = 1; n3 <= this.mol.NumAtoms(); ++n3) {
                    if (!this.selected[n3 - 1]) continue;
                    this.mol.SetAtomPos(n3, this.mol.AtomX(n3) + dx, this.mol.AtomY(n3) + dy);
                }
                this.ClearTemporary(false);
                this.DetermineSize();
            }
            if (this.toolDragReason == 3 && this.selected != null && mx * mx + my * my > 25.0) {
                double dx = (this.toolDragX2 - this.toolDragX1) / this.scale;
                dy = -(this.toolDragY2 - this.toolDragY1) / this.scale;
                int oldNumAtoms = this.mol.NumAtoms();
                int oldNumBonds = this.mol.NumBonds();
                int[] newPos = new int[this.mol.NumAtoms()];
                this.CacheUndo();
                for (n = 1; n <= oldNumAtoms; ++n) {
                    if (!this.selected[n - 1]) continue;
                    newPos[n - 1] = this.mol.AddAtom(this.mol.AtomElement(n), this.mol.AtomX(n) + dx, this.mol.AtomY(n) + dy, this.mol.AtomCharge(n), this.mol.AtomUnpaired(n));
                }
                for (n = 1; n <= oldNumBonds; ++n) {
                    if (!this.selected[this.mol.BondFrom(n) - 1] || !this.selected[this.mol.BondTo(n) - 1]) continue;
                    this.mol.AddBond(newPos[this.mol.BondFrom(n) - 1], newPos[this.mol.BondTo(n) - 1], this.mol.BondOrder(n), this.mol.BondType(n));
                }
                this.ClearTemporary();
                this.selected = new boolean[this.mol.NumAtoms()];
                for (n = 1; n <= this.mol.NumAtoms(); ++n) {
                    this.selected[n - 1] = n > oldNumAtoms;
                }
                this.DetermineSize();
            }
            if (this.toolDragReason == 4 && this.selected != null && mx * mx + my * my > 25.0) {
                double extmul = this.DragExtendBy(mx, my);
                double cx = 0.0;
                double cy = 0.0;
                int count = 0;
                for (n = 1; n <= this.mol.NumAtoms(); ++n) {
                    if (!this.selected[n - 1]) continue;
                    cx += this.mol.AtomX(n);
                    cy += this.mol.AtomY(n);
                    ++count;
                }
                cx /= (double)count;
                cy /= (double)count;
                this.CacheUndo();
                for (n = 1; n <= this.mol.NumAtoms(); ++n) {
                    if (!this.selected[n - 1]) continue;
                    this.mol.SetAtomPos(n, (this.mol.AtomX(n) - cx) * extmul + cx, (this.mol.AtomY(n) - cy) * extmul + cy);
                }
                this.ClearTemporary(false);
                this.DetermineSize();
            }
            this.toolDragReason = 0;
            this.dragged = null;
            this.repaint();
        }
        if (this.tool == 3 && this.toolDragReason != 0) {
            this.toolDragX2 = e.getX();
            this.toolDragY2 = e.getY();
            if (this.toolDragReason == 1 && this.dragged != null) {
                for (int n4 = 0; n4 < this.mol.NumAtoms(); ++n4) {
                    this.selected[n4] = this.selected[n4] || this.dragged[n4];
                }
                this.DeleteSelected();
                this.ClearTemporary();
            }
            this.toolDragReason = 0;
            this.dragged = null;
            this.repaint();
        } else if (this.tool == 2 && this.toolDragReason == 5) {
            double dx = this.toolDragX2 - this.toolDragX1;
            double dy = this.toolDragY2 - this.toolDragY1;
            double th = -Math.atan2(dy, dx) * 180.0 / Math.PI;
            if (this.toolSnap) {
                th = Math.round(th / 15.0) * 15L;
            }
            if (Math.abs(th) > 1.0) {
                this.CacheUndo();
                th = th * Math.PI / 180.0;
                double ax = this.XToAng(this.toolDragX1);
                double ay = this.YToAng(this.toolDragY1);
                for (int n5 = 1; n5 <= this.mol.NumAtoms(); ++n5) {
                    if (!this.selected[n5 - 1]) continue;
                    double rx = this.mol.AtomX(n5) - ax;
                    double ry = this.mol.AtomY(n5) - ay;
                    double rth = Math.atan2(ry, rx);
                    double ext = Math.sqrt(rx * rx + ry * ry);
                    this.mol.SetAtomPos(n5, ax + ext * Math.cos(rth + th), ay + ext * Math.sin(rth + th));
                }
                this.ClearTemporary(false);
                this.DetermineSize();
            }
            this.toolDragReason = 0;
            this.dragged = null;
            this.repaint();
        } else if (this.tool == 4 && this.toolAtomDrag && this.toolBondFrom > 0) {
            this.CacheUndo();
            this.mol.AddAtom(this.toolAtomType, this.toolBondToX, this.toolBondToY);
            this.mol.AddBond(this.toolBondFrom, this.mol.NumAtoms(), 1);
            this.ClearTemporary();
            this.DetermineSize();
            this.toolAtomDrag = false;
            this.toolBondFrom = 0;
            this.repaint();
        } else if (this.tool == 5) {
            this.toolBondToX = this.XToAng(e.getX());
            this.toolBondToY = this.YToAng(e.getY());
            int joinTo = this.PickAtom(e.getX(), e.getY());
            if (this.toolBondFrom > 0 && joinTo == 0 && this.toolSnap) {
                this.SnapToolBond();
                joinTo = this.PickAtom((int)this.AngToX(this.toolBondToX), (int)this.AngToY(this.toolBondToY));
            }
            if (e.getButton() == 1 && this.toolBondFrom == 0 && this.toolBondHit > 0) {
                int i = this.PickBond(e.getX(), e.getY());
                if (i == this.toolBondHit) {
                    this.CacheUndo();
                    if (this.toolBondOrder == this.mol.BondOrder(i) && this.toolBondType == this.mol.BondType(i)) {
                        this.mol.SetBondFromTo(i, this.mol.BondTo(i), this.mol.BondFrom(i));
                    }
                    this.mol.SetBondOrder(i, this.toolBondOrder);
                    this.mol.SetBondType(i, this.toolBondType);
                    this.ClearTemporary();
                }
            } else if (this.toolBondFrom == 0) {
                int a1 = 0;
                int a2 = 0;
                double x1 = 0.0;
                double x2 = 0.0;
                double y1 = 0.0;
                double y2 = 0.0;
                if (this.toolBondDrag) {
                    if (this.toolSnap) {
                        this.SnapToolBond();
                    }
                    x1 = this.toolBondFromX;
                    y1 = this.toolBondFromY;
                    a2 = this.PickAtom(e.getX(), e.getY());
                    if (a2 > 0) {
                        x2 = this.mol.AtomX(a2);
                        y2 = this.mol.AtomY(a2);
                    } else {
                        x2 = this.toolBondToX;
                        y2 = this.toolBondToY;
                    }
                } else {
                    x1 = x2 = this.XToAng(e.getX());
                    if ((e.getModifiers() & 1) > 0) {
                        x1 -= 0.75;
                        x2 += 0.75;
                    }
                    y1 = y2 = this.YToAng(e.getY());
                    if ((e.getModifiers() & 1) == 0) {
                        y1 -= 0.75;
                        y2 += 0.75;
                    }
                }
                double dx = x2 - x1;
                double dy = y2 - y1;
                if (dx * dx + dy * dy > 0.25) {
                    this.CacheUndo();
                    a1 = this.mol.AddAtom("C", x1, y1, 0, 0);
                    if (a2 == 0) {
                        a2 = this.mol.AddAtom("C", x2, y2, 0, 0);
                    }
                    this.mol.AddBond(a1, a2, this.toolBondOrder);
                    this.ClearTemporary();
                }
                this.repaint();
            } else if (joinTo > 0 && joinTo != this.toolBondFrom) {
                this.CacheUndo();
                this.mol.AddBond(this.toolBondFrom, joinTo, this.toolBondOrder);
                this.mol.SetBondType(this.mol.NumBonds(), this.toolBondType);
                this.ClearTemporary();
            } else if (this.toolBondFrom > 0) {
                double dx = this.toolBondToX - this.mol.AtomX(this.toolBondFrom);
                double dy = this.toolBondToY - this.mol.AtomY(this.toolBondFrom);
                if (this.toolBondFrom == joinTo) {
                    int[] adj = this.mol.AtomAdjList(this.toolBondFrom);
                    ArrayList<Double> poss = new ArrayList<Double>();
                    double ax = this.mol.AtomX(this.toolBondFrom);
                    double ay = this.mol.AtomY(this.toolBondFrom);
                    if (adj.length == 0) {
                        poss.add(0.0);
                    } else if (adj.length == 1) {
                        double ang = Math.atan2(this.mol.AtomY(adj[0]) - ay, this.mol.AtomX(adj[0]) - ax) * 180.0 / Math.PI;
                        if (this.toolBondOrder != 3) {
                            poss.add(ang + 120.0);
                            poss.add(ang - 120.0);
                        } else {
                            poss.add(ang + 180.0);
                        }
                    } else if (adj.length == 2) {
                        double ang1 = Math.atan2(this.mol.AtomY(adj[0]) - ay, this.mol.AtomX(adj[0]) - ax) * 180.0 / Math.PI;
                        double ang2 = Math.atan2(this.mol.AtomY(adj[1]) - ay, this.mol.AtomX(adj[1]) - ax) * 180.0 / Math.PI;
                        if (ang2 < ang1) {
                            ang2 += 360.0;
                        }
                        if (ang2 - ang1 < 180.0) {
                            poss.add(0.5 * (ang1 + ang2) + 180.0);
                        } else {
                            poss.add(0.5 * (ang1 + ang2));
                        }
                    } else {
                        for (n = 0; n < adj.length; ++n) {
                            double ang = Math.atan2(this.mol.AtomY(adj[n]) - ay, this.mol.AtomX(adj[n]) - ax) * 180.0 / Math.PI;
                            poss.add(ang + 180.0);
                        }
                    }
                    double ang = (Double)poss.get(0);
                    if (poss.size() > 1) {
                        int best = -1;
                        double bestScore = 0.0;
                        for (int n6 = 0; n6 < poss.size(); ++n6) {
                            double nx = ax + 1.5 * Math.cos((Double)poss.get(n6) * Math.PI / 180.0);
                            double ny = ay + 1.5 * Math.sin((Double)poss.get(n6) * Math.PI / 180.0);
                            double score = 0.0;
                            for (int i = 1; i <= this.mol.NumAtoms(); ++i) {
                                dx = this.mol.AtomX(i) - nx;
                                dy = this.mol.AtomY(i) - ny;
                                score += 1.0 / Math.min(1000.0, dx * dx + dy * dy);
                            }
                            if (best >= 0 && !(score < bestScore)) continue;
                            best = n6;
                            bestScore = score;
                        }
                        ang = (Double)poss.get(best);
                    }
                    dx = 1.5 * Math.cos(ang * Math.PI / 180.0);
                    dy = 1.5 * Math.sin(ang * Math.PI / 180.0);
                    this.toolBondToX = ax + dx;
                    this.toolBondToY = ay + dy;
                }
                if (dx * dx + dy * dy > 0.5) {
                    this.CacheUndo();
                    this.mol.AddAtom("C", this.toolBondToX, this.toolBondToY);
                    this.mol.AddBond(this.toolBondFrom, this.mol.NumAtoms(), this.toolBondOrder);
                    this.mol.SetBondType(this.mol.NumBonds(), this.toolBondType);
                    this.ClearTemporary();
                    this.DetermineSize();
                }
            }
            this.toolBondDrag = false;
            this.toolBondFrom = 0;
            this.toolBondHit = 0;
            this.repaint();
        }
        this.CheckDirtiness();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean redraw = false;
        if ((this.trackX != e.getX() || this.trackY != e.getY()) && this.tool == 7) {
            redraw = true;
        }
        this.trackX = e.getX();
        this.trackY = e.getY();
        if (e.getButton() == 0) {
            int mx = e.getX();
            int my = e.getY();
            int newAtom = 0;
            int newBond = 0;
            newAtom = this.PickAtom(mx, my);
            if (newAtom == 0) {
                newBond = this.PickBond(mx, my);
            }
            if (this.tool == 7 && this.templateIdx > 0) {
                newBond = 0;
            }
            if (this.tool == 7 && this.templateIdx < 0) {
                newAtom = 0;
            }
            if (newAtom != this.highlightAtom || newBond != this.highlightBond) {
                this.highlightAtom = newAtom;
                this.highlightBond = newBond;
                redraw = true;
            }
        }
        if (redraw) {
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean redraw = false;
        if (this.tool == 7 && (this.trackX != e.getX() || this.trackY != e.getY())) {
            redraw = true;
        }
        this.trackX = e.getX();
        this.trackY = e.getY();
        if (this.tool == 1 && this.toolDragReason != 0 || this.tool == 3 && this.toolDragReason != 0 || this.tool == 2 && this.toolDragReason == 1) {
            this.toolDragX2 = e.getX();
            this.toolDragY2 = e.getY();
            if (this.toolDragReason == 1) {
                int x = (int)this.toolDragX1;
                int y = (int)this.toolDragY1;
                int w = (int)this.toolDragX2 - x;
                int h = (int)this.toolDragY2 - y;
                if (w < 0) {
                    w = -w;
                    x -= w;
                }
                if (h < 0) {
                    h = -h;
                    y -= h;
                }
                this.dragged = new boolean[this.mol.NumAtoms()];
                for (int n = 0; n < this.mol.NumAtoms(); ++n) {
                    this.dragged[n] = this.px[n] >= (double)x && this.px[n] <= (double)(x + w) && this.py[n] >= (double)y && this.py[n] <= (double)(y + h);
                }
            }
            redraw = true;
        } else if (this.tool == 2 && this.toolDragReason == 5) {
            this.toolDragX2 = e.getX();
            this.toolDragY2 = e.getY();
            redraw = true;
        } else if (this.tool == 4 && this.toolBondFrom != 0) {
            double dy;
            double dx;
            if (!this.toolAtomDrag && (dx = this.XToAng(e.getX()) - this.mol.AtomX(this.toolBondFrom)) * dx + (dy = this.YToAng(e.getY()) - this.mol.AtomY(this.toolBondFrom)) * dy > 0.6400000000000001) {
                this.toolAtomDrag = true;
                this.toolBondOrder = 1;
                this.toolBondType = 0;
            }
            if (this.toolAtomDrag) {
                this.toolBondToX = this.XToAng(e.getX());
                this.toolBondToY = this.YToAng(e.getY());
                if (this.toolAtomSnap) {
                    this.SnapToolBond();
                }
                redraw = true;
            }
        } else if (this.tool == 5) {
            this.toolBondToX = this.XToAng(e.getX());
            this.toolBondToY = this.YToAng(e.getY());
            int joinTo = this.PickAtom(e.getX(), e.getY());
            if (!this.toolBondDrag && (Math.abs(this.toolBondToX - this.toolBondFromX) > 2.0 / this.scale || Math.abs(this.toolBondToY - this.toolBondFromY) > 2.0 / this.scale)) {
                this.toolBondDrag = true;
            }
            if (joinTo > 0) {
                this.toolBondToX = this.mol.AtomX(joinTo);
                this.toolBondToY = this.mol.AtomY(joinTo);
            } else if (this.toolSnap) {
                this.SnapToolBond();
            }
            redraw = true;
        }
        if (redraw) {
            this.repaint();
        }
        this.CheckDirtiness();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.tool == 7) {
            double accel;
            double cx = 0.0;
            double cy = 0.0;
            for (int n = 1; n <= this.template.NumAtoms(); ++n) {
                cx += this.template.AtomX(n);
                cy += this.template.AtomY(n);
            }
            cx /= (double)this.template.NumAtoms();
            cy /= (double)this.template.NumAtoms();
            double d = accel = e.isShiftDown() ? 3.0 : 1.0;
            if (e.isControlDown()) {
                double factor = 1.0 - 0.1 * accel * (double)e.getWheelRotation();
                for (int n = 1; n <= this.template.NumAtoms(); ++n) {
                    this.template.SetAtomPos(n, cx + (this.template.AtomX(n) - cx) * factor, cy + (this.template.AtomY(n) - cy) * factor);
                }
            } else {
                double radians = 5.0 * accel * Math.PI / 180.0 * (double)e.getWheelRotation();
                for (int n = 1; n <= this.template.NumAtoms(); ++n) {
                    double dx = this.template.AtomX(n) - cx;
                    double dy = this.template.AtomY(n) - cy;
                    double dist = Math.sqrt(dx * dx + dy * dy);
                    double theta = Math.atan2(dy, dx);
                    this.template.SetAtomPos(n, cx + dist * Math.cos(theta + radians), cy + dist * Math.sin(theta + radians));
                }
            }
            this.templDraw = this.template.Clone();
            this.repaint();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.toolAtomEditBox) {
            this.CompleteAtomEdit();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getSource() == this.toolAtomEditBox && e.getKeyChar() == '\n') {
            this.CompleteAtomEdit();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.autoScale) {
            this.ScaleToFit();
            this.repaint();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.autoScale) {
            this.ScaleToFit();
            this.repaint();
        }
    }

    public void RotateMolecule() {
        double Degrees = MainApplet.rotation;
        if (Degrees != 0.0) {
            double radians = Degrees * Math.PI / 180.0;
            for (int n = 1; n <= this.mol.NumAtoms(); ++n) {
                double dx = this.mol.AtomX(n);
                double dy = this.mol.AtomY(n);
                double dist = Math.sqrt(dx * dx + dy * dy);
                double theta = Math.atan2(dy, dx);
                try {
                    this.mol.SetAtomPos(n, dist * Math.cos(theta + radians), dist * Math.sin(theta + radians));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("problem with rotation : " + e);
                }
            }
            this.repaint();
        }
    }

    public static boolean[] GrowArray(boolean[] array, int newlength) {
        int oldlength = array.length;
        boolean[] grow = new boolean[newlength];
        for (int i = 0; i < oldlength; ++i) {
            grow[i] = array[i];
        }
        return grow;
    }

    class EditState {
        Molecule Molecule;
        boolean[] Selected;

        EditState() {
        }
    }
}

