/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _RVLOG_H
#define _RVLOG_H

#define RVLOG_NONE  0

/* how */
#define RVLOG_STDERR  1
#define RVLOG_SYSLOG  2

/* opts */
#define RVLOG_PID    1
#define RVLOG_NAME   2

/* level */
#define RVLOG_ERROR     1
#define RVLOG_WARNING   2
#define RVLOG_INFO      3
#define RVLOG_DEBUG(x)  ((x) + 4)
#define RVLOG_MAX 255

#include <string>
#include <stdarg.h>

class rvlog {
 public:
  rvlog();
  rvlog(int how, const string& name = "");
  rvlog(int how, int opts, const string& name = "");
  virtual ~rvlog();
  // rvlog(const rvlog&) implicit copy constructor

  int open(const string& name = "");
  int open(int how, const string& name = "");
  int open(int how, int opts, const string& name = "");
  int close();

  int log(int level, const char* format, va_alist) const;
  int logv(int level, const char* oformat, va_list pvar) const;

  int how_set(int how);
  int how_get() const;

  int opts_set(int opts);
  int opts_get() const;

  int level_set(int level);
  int level_get() const;

  int name_set(const string& name);
  string name_get() const;

 private:
  int _how;
  int _level;
  int _opts;
  string _name;
};

extern rvlog* rvlog_loghandle;

int rvlog_log(int level, const char* format, va_alist);

#if 0
#define rvlog_log(level, format, args...) \
rvlog_loghandle.rvlog_log(level, format , ## args) /* RV@@4 */
#endif

#endif /* _RVLOG_H */
