#
# httpservlet.rb -- HTTPServlet Module
#
# Author: IPR -- Internet Programming with Ruby -- writers
# Copyright (C) 2000 TAKAHASHI Masayoshi, GOTOU Yuuzou
#
# $IPR: abstract.rb,v 1.12 2002/02/05 20:20:39 gotoyuzo Exp $

require 'thread'

require 'webrick/htmlutils'
require 'webrick/httputils'
require 'webrick/httpstatus'
require 'webrick/httpdate'

module WEBrick
  module HTTPServlet

    class AbstractServlet
      def self.require_path_info val
        module_eval %-
          def self.require_path_info?
            #{val}
          end
        -
      end
      require_path_info true

      def self.get_instance(config, *options)
        self.new(config, *options)
      end

      def initialize(config, *options)
        @config = config
        @logger = config[:Logger]
        @options = options
      end

      def service(req, res)
        method_name = "do_" + req.request_method.gsub(/-/, "_")
        if respond_to?(method_name)
          send(method_name, req, res)
        else
          raise HTTPStatus::MethodNotAllowed,
                "unsupported method `#{req.request_method}'."
        end
      end

      def do_GET(req, res)
        raise HTTPStatus::NotFound, "not found."
      end

      def do_HEAD(req, res)
        do_GET(req, res)
      end
    end

  end
end
