#!/usr/local/bin/perl
# install_mod.cgi
# Download and install a webmin module

require './webmin-lib.pl';
if ($ENV{REQUEST_METHOD} eq "POST") { &ReadParseMime(); }
else { &ReadParse(); $no_upload = 1; }

$| = 1;
$theme_no_table = 1 if ($in{'source'} == 2);
&header($text{'install_title'}, "");
print "<hr>\n";

if ($in{'source'} == 0) {
	# from local file
	&error_setup(&text('install_err1', $in{'file'}));
	$file = $in{'file'};
	if (!(-r $file)) { &inst_error($text{'install_efile'}); }
	}
elsif ($in{'source'} == 1) {
	# from uploaded file
	&error_setup($text{'install_err2'});
	$file = &tempname();
	$need_unlink = 1;
	if ($no_upload) {
                &inst_error($text{'install_ebrowser'});
                }
	open(MOD, "> $file");
	print MOD $in{'upload'};
	close(MOD);
	}
elsif ($in{'source'} == 2) {
	# from ftp or http url
	&error_setup(&text('install_err3', $in{'url'}));
	$file = &tempname();
	$need_unlink = 1;
	local $error;
	$progress_callback_url = $in{'url'};
	if ($in{'url'} =~ /^http:\/\/([^\/]+)(\/.*)$/) {
		$host = $1; $page = $2; $port = 80;
		if ($host =~ /^(.*):(\d+)$/) { $host = $1; $port = $2; }
		&http_download($host, $port, $page, $file, \$error,
			       \&progress_callback);
		}
	elsif ($in{'url'} =~ /^ftp:\/\/([^\/]+)\/(.*)$/) {
		$host = $1; $ffile = $2;
		&ftp_download($host, $ffile, $file, \$error, \&progress_callback);
		}
	else { &inst_error($text{'install_eurl'}); }
	&inst_error($error) if ($error);
	}

# Install the module(s)
&install_webmin_module($file, $need_unlink, \@mdescs, \@mdirs,
		       \@msizes, $in{'nodeps'});

# Display something nice for the user
print "$text{'install_desc'} <p>\n";
print "<ul>\n";
for($i=0; $i<@mdescs; $i++) {
	$mdirs[$i] =~ /\/([^\/]+)$/;
	if (%minfo = &get_module_info($1)) {
		# Installed a module
		local $cat = $text{"category_".$minfo{'category'}};
		$cat = $text{"category_"} if (!$cat);
		print &text('install_line2', "<b>$mdescs[$i]</b>",
			    "<tt>$mdirs[$i]</tt>", $msizes[$i], $cat),
			    "<br>\n";
		}
	elsif (%tinfo = &get_theme_info($1)) {
		# Installed a theme
		print &text('themes_line', "<b>$mdescs[$i]</b>",
			    "<tt>$mdirs[$i]</tt>", $msizes[$i]),
			    "<br>\n";
		}
	}
print "</ul><p>\n";
print "<hr>\n";
&footer("", $text{'index_return'});

sub inst_error
{
if ($need_unlink) { unlink($file); }
print "<br><b>$whatfailed : $_[0]</b> <p>\n";
print "<hr>\n";
&footer("", $text{'index_return'});
exit;
}

