#!/usr/local/bin/perl
# config_save.cgi
# Save inputs from edit_configs.cgi

require './usermin-lib.pl';
&ReadParse();
$m = $in{'mod'};
&read_acl(\%acl);
&error_setup($text{'config_err'});

&get_usermin_miniserv_config(\%miniserv);
&read_file("$miniserv{'root'}/$m/config.info", \%info, \@info_order) ||
	&error($text{'config_ecannot'});
&read_file("$miniserv{'root'}/$m/config.info.$gconfig{'lang'}", \%info, \@info_order);
@info_order = &unique(@info_order);

mkdir("$config{'usermin_dir'}/$m", 0700);
&lock_file("$config{'usermin_dir'}/$m/config");
&read_file("$config{'usermin_dir'}/$m/config", \%mconfig);

# Use config.info to parse config inputs
foreach $c (@info_order) {
	@p = split(/,/, $info{$c});
	if ($p[1] == 0 || $p[1] == 7 || $p[1] == 8) {
		# Free text input
		$mconfig{$c} = $in{$c};
		}
	elsif ($p[1] == 1 || $p[1] == 4) {
		# One of many
		$mconfig{$c} = $in{$c};
		}
	elsif ($p[1] == 5 || $p[1] == 6) {
		# User or group
		$mconfig{$c} = ($p[2] && $in{$c."_def"} ? "" : $in{$c});
		}
	elsif ($p[1] == 2) {
		# Many of many
		$in{$c} =~ s/\0/,/g;
		$mconfig{$c} = $in{$c};
		}
	elsif ($p[1] == 3) {
		# Optional free text
		if ($in{$c."_none"}) { $mconfig{$c} = ""; }
		else { $mconfig{$c} = $in{$c}; }
		}
	elsif ($p[1] == 9) {
		# Multilines of free text
		$in{$c} =~ s/\n/ /g;
		$in{$c} =~ s/\s+$//;
		$mconfig{$c} = $in{$c};
		}
	elsif ($p[1] == 10) {
		# One of many or free text
		if ($in{$c} eq 'free') {
			$mconfig{$c} = $in{$c.'_free'};
			}
		else {
			$mconfig{$c} = $in{$c};
			}
		}
	}
&write_file("$config{'usermin_dir'}/$m/config", \%mconfig);
&unlock_file("$config{'usermin_dir'}/$m/config");
&webmin_log("_config_", undef, undef, \%in, $m);
&redirect("");

