# grub-lib.pl
# Functions for parsing and editing a grub menu file

do '../web-lib.pl';
&init_config();

%title_order = ( 'root', 2,
		 'kernel', 1 );

# get_menu_config()
# Parses the config file into a list of title structures
sub get_menu_config
{
local $lnum = 0;
local (@rv, $title);
open(CONF, $config{'menu_file'});
while(<CONF>) {
	s/#.*$//;
	s/\r|\n//g;
	if (/^\s*(\S+)\s*=\s*(.*)/ || /^\s*(\S+)\s*(.*)/) {
		if ($title && $1 ne 'title') {
			# directive in an existing section
			$title->{$1} = $2;
			$title->{'eline'} = $lnum;
			}
		else {
			# top-level title or option
			local $d = { 'name' => $1,
				     'value' => $2,
				     'line' => $lnum,
				     'eline' => $lnum,
				     'index' => scalar(@rv) };
			push(@rv, $d);
			$title = $d if ($1 eq 'title');
			}
		}
	$lnum++;
	}
close(CONF);
return \@rv;
}

# save_directive(&config, &old|name, &new)
sub save_directive
{
local $old;
if (!$_[1] || ref($_[1])) {
	$old = $_[1];
	}
else {
	$old = &find($_[1], $_[0]);
	}
local @lines;
if (defined($_[2])) {
	@lines = ( "$_[2]->{'name'} $_[2]->{'value'}" );
	foreach $k (sort { $title_order{$b} <=> $title_order{$a} }
			 keys %{$_[2]}) {
		if ($k !~ /^(name|value|line|eline|index)$/) {
			if ($_[2]->{$k} eq '') {
				push(@lines, $k);
				}
			else {
				push(@lines, $k." ".$_[2]->{$k});
				}
			}
		}
	}
local $lref = &read_file_lines($config{'menu_file'});
if ($old) {
	# Replace one entry in the file
	splice(@$lref, $old->{'line'}, $old->{'eline'} - $old->{'line'} + 1,
	       @lines);
	}
elsif ($_[2]->{'name'} eq 'title') {
	# Append to file
	push(@$lref, "", @lines);
	}
else {
	# Insert before titles
	local $t = &find("title", $_[0]);
	if ($t) {
		splice(@$lref, $t->{'line'}, 0, @lines);
		}
	else {
		push(@$lref, "", @lines);
		}
	}
}

# find(name, &config)
sub find
{
local @rv;
foreach $c (@{$_[1]}) {
	push(@rv, $c) if ($c->{'name'} eq $_[0]);
	}
return wantarray ? @rv : $rv[0];
}

# find_value(name, &config)
sub find_value
{
local @rv = &find($_[0], $_[1]);
return !@rv ? undef : wantarray ? map { $_->{'value'} } @rv : $rv[0]->{'value'};
}

