#!/usr/local/bin/perl
# filesystems.cgi
# List all filesystems and their types

require './file-lib.pl';
print "Content-type: text/plain\n\n";
if (!&foreign_check("mount")) {
	print "0\n";
	exit;
	}
&foreign_require("mount", "mount-lib.pl");
@mounts = &foreign_call("mount", "list_mounted");
print "1\n";
map { $aclfs{$_}++ } split(/\s+/, $config{'acl_filesystems'})
	if (&has_command("getfacl") && &has_command("setfacl"));
map { $attrfs{$_}++ } split(/\s+/, $config{'attr_filesystems'})
	if (&has_command("attr"));
foreach $m (sort { length($a->[0]) <=> length($b->[0]) } @mounts) {
	next if ($m->[0] !~ /^\//);
	$acls = $aclfs{$m->[2]} ? 1 : 0;
	$attrs = $attrfs{$m->[2]} ? 1 : 0;
	print join(" ", @$m[0..3], $acls, $attrs),"\n";
	}

