# oldfile-monitor.pl
# Check if some file has not been changed lately

sub get_oldfile_status
{
local %change;
local @st = stat($_[0]->{'file'});
if (!@st) {
	# File doesn't exist!
	return { 'up' => -1 };
	}
elsif ($st[9] < time()-$_[0]->{'diff'}) {
	# File hasn't been changed lately
	return { 'up' => 0 };
	}
else {
	# File has been changed lately
	return { 'up' => 1 };
	}
}

sub show_oldfile_dialog
{
print "<tr> <td><b>$text{'oldfile_file'}</b></td>\n";
printf "<td colspan=3><input name=file size=30 value='%s'> %s</td> </tr>\n",
	$_[0]->{'file'}, &file_chooser_button("file", 0);

print "<tr> <td><b>$text{'oldfile_diff'}</b></td>\n";
printf "<td><input name=diff size=10 value='%s'> %s</td> </tr>\n",
	$_[0]->{'diff'}, $text{'oldfile_secs'};
}

sub parse_oldfile_dialog
{
$_[0]->{'file'} = $in{'file'};
$_[0]->{'diff'} = $in{'diff'};
}

