/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "updatebatch.h"

#include "commands/command.h"
#include "datamanager.h"

using namespace WebIssues;

UpdateBatch::UpdateBatch( int priority ) : AbstractBatch( priority ),
    m_next( 0 )
{
}

UpdateBatch::~UpdateBatch()
{
}

void UpdateBatch::updateUsers()
{
    m_units.append( Unit( UpdateEvent::Users ) );
}

void UpdateBatch::updateTypes()
{
    m_units.append( Unit( UpdateEvent::Types ) );
}

void UpdateBatch::updateProjects()
{
    m_units.append( Unit( UpdateEvent::Projects ) );
}

void UpdateBatch::updateFolder( int folderId )
{
    m_units.append( Unit( UpdateEvent::Folder, folderId ) );
}

void UpdateBatch::updateIssue( int issueId )
{
    m_units.append( Unit( UpdateEvent::Issue, issueId ) );
}

Command* UpdateBatch::fetchNext()
{
    if ( m_next >= m_units.count() )
        return NULL;

    Unit unit = m_units[ m_next++ ];

    switch ( unit.m_unit ) {
        case UpdateEvent::Users:
            return dataManager->updateUsers();
        case UpdateEvent::Types:
            return dataManager->updateTypes();
        case UpdateEvent::Projects:
            return dataManager->updateProjects();
        case UpdateEvent::Folder:
            return dataManager->updateFolder( unit.m_id );
        case UpdateEvent::Issue:
            return dataManager->updateIssue( unit.m_id );
    }

    return NULL;
}
