// Migrate the extension to 1.0
function webdeveloper_migrateTo1()
{
    var toolbar = document.getElementById("webdeveloper-toolbar");

    webdeveloper_deletePreferenceBranch("webdeveloper.color");
    webdeveloper_deletePreferenceBranch("webdeveloper.edit.css");
    webdeveloper_deletePreferenceBranch("webdeveloper.tidied");
    webdeveloper_deletePreferenceBranch("webdeveloper.validator");

    // Remove the disabled preference
    if(webdeveloper_isPreferenceSet("webdeveloper.disabled"))
    {
        webdeveloper_deletePreference("webdeveloper.disabled");
    }

    // Migrate the populate form fields email
    if(webdeveloper_getStringPreference("webdeveloper.populate.form.fields.email", true) == "noemail@noemail.org")
    {
        webdeveloper_deletePreference("webdeveloper.populate.form.fields.email");
    }

    // Migrate the validate feed url
    if(webdeveloper_getStringPreference("webdeveloper.tool.2.url", true) == "http://feedvalidator.org/check.cgi?url=")
    {
        webdeveloper_deletePreference("webdeveloper.tool.2.url");
    }

    // Migrate the view speed report
    if(webdeveloper_getStringPreference("webdeveloper.tool.7.url", true) == "http://www.websiteoptimization.com/cgi-bin/wso/wso.pl?url=")
    {
        webdeveloper_deletePreference("webdeveloper.tool.7.description");
        webdeveloper_deletePreference("webdeveloper.tool.7.url");
    }

    // Migrate the tool count
    if(webdeveloper_getIntegerPreference("webdeveloper.tool.count", true) < 8)
    {
        webdeveloper_deletePreference("webdeveloper.tool.count");
    }

    toolbar.collapsed = false;
    toolbar.hidden    = false;

    document.persist("webdeveloper-toolbar", "collapsed");
    document.persist("webdeveloper-toolbar", "hidden");
}

// Migrate the extension to 1.1
function webdeveloper_migrateTo11()
{
    // Migrate DOM Inspector sidebar
    if(webdeveloper_isPreferenceSet("webdeveloper.dom.inspector.sidebar"))
    {
        webdeveloper_setBooleanPreference("webdeveloper.dom.inspector.dashboard", webdeveloper_getBooleanPreference("webdeveloper.dom.inspector.sidebar", true));
        webdeveloper_deletePreference("webdeveloper.dom.inspector.sidebar");
    }

    // Migrate JavaScript console dashboard
    if(webdeveloper_isPreferenceSet("webdeveloper.javascript.console.dashboard"))
    {
        webdeveloper_setBooleanPreference("webdeveloper.error.console.dashboard", webdeveloper_getBooleanPreference("webdeveloper.javascript.console.dashboard", true));
        webdeveloper_deletePreference("webdeveloper.javascript.console.dashboard");
    }

    // Migrate JavaScript console key
    if(webdeveloper_isPreferenceSet("webdeveloper.javascript.console.key"))
    {
        webdeveloper_setStringPreference("webdeveloper.error.console.key", webdeveloper_getStringPreference("webdeveloper.javascript.console.key", true));
        webdeveloper_deletePreference("webdeveloper.javascript.console.key");
    }

    // Migrate JavaScript console sidebar
    if(webdeveloper_isPreferenceSet("webdeveloper.javascript.console.sidebar"))
    {
        webdeveloper_setBooleanPreference("webdeveloper.error.console.dashboard", webdeveloper_getBooleanPreference("webdeveloper.javascript.console.sidebar", true));
        webdeveloper_deletePreference("webdeveloper.javascript.console.sidebar");
    }

    // Migrate persist styles
    if(webdeveloper_isPreferenceSet("webdeveloper.styles.persist"))
    {
        webdeveloper_setBooleanPreference("webdeveloper.persist.features", webdeveloper_getBooleanPreference("webdeveloper.styles.persist", true));
        webdeveloper_deletePreference("webdeveloper.styles.persist");
    }

    // Migrate view style information dashboard
    if(webdeveloper_isPreferenceSet("webdeveloper.view.style.information.sidebar"))
    {
        webdeveloper_setBooleanPreference("webdeveloper.style.information.dashboard", webdeveloper_getBooleanPreference("webdeveloper.view.style.information.sidebar", true));
        webdeveloper_deletePreference("webdeveloper.view.style.information.sidebar");
    }
}

// Migrate the extension to 1.1.2
function webdeveloper_migrateTo112()
{
    // Migrate validate CSS
    if(webdeveloper_getStringPreference("webdeveloper.tool.1.url", true) == "http://jigsaw.w3.org/css-validator/validator?profile=css2&warning=0&uri=")
    {
        webdeveloper_setStringPreferenceIfNotSet("webdeveloper.tool.1.url", "http://jigsaw.w3.org/css-validator/validator?profile=css21&warning=0&uri=");
    }
}

// Opens the upgrade page
function webdeveloper_openUpgradePage()
{
		var windowContent = window.getBrowser();
	
		window.setTimeout(function() { windowContent.selectedTab = windowContent.addTab("@home.page@installed/" + "@version@".replace(/\./g, "") + "/"); }, 0);	
}

// Parses the version number
function webdeveloper_parseVersion(version)
{
    // If the version is set
    if(version)
    {
        var splitVersion       = version.split(".");
        var parsedVersion      = splitVersion[0] + ".";
        var splitVersionLength = splitVersion.length;

        // Loop through the remaining parts of the version
        for(var i = 1; i < splitVersionLength; i++)
        {
            parsedVersion += splitVersion[i];
        }

        return parseFloat(parsedVersion);
    }
    else
    {
        return 0;
    }
}

// Check if the extension is being upgraded
function webdeveloper_upgrade()
{
    var previousVersion = webdeveloper_parseVersion(webdeveloper_getStringPreference("webdeveloper.version", true));
    var version         = webdeveloper_parseVersion("@version@");

    // If the versions do not match
    if(previousVersion != version)
    {
        // If the previous version is less than 1.0.2
        if(previousVersion < webdeveloper_parseVersion("1.0.2"))
        {
            webdeveloper_migrateTo1();
        }

        // If the previous version is less than 1.1
        if(previousVersion < webdeveloper_parseVersion("1.1"))
        {
            webdeveloper_migrateTo11();
        }

        // If the previous version is less than 1.1.2
        if(previousVersion < webdeveloper_parseVersion("1.1.2"))
        {
            webdeveloper_migrateTo112();
        }

				webdeveloper_openUpgradePage();
        webdeveloper_setStringPreference("webdeveloper.version", version);
    }				
}