// Clears all private data
function webdeveloper_clearAllPrivateData()
{
    // If the browser glue is found
    if(Components.classes["@mozilla.org/browser/browserglue;1"])
    {
        Components.classes["@mozilla.org/browser/browserglue;1"].getService(Components.interfaces.nsIBrowserGlue).sanitize(window || null);
    }
    else
    {
        window.openDialog("chrome://webdeveloper/content/message/message.xul", "webdeveloper-message-dialog", "centerscreen,chrome,modal", document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_firefox15Required"));
    }
}

// Clears the cache
function webdeveloper_clearCache()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the clearing is confirmed
    if(webdeveloper_clearConfirmation(stringBundle.getString("webdeveloper_clearCacheConfirmation")))
    {
        var cacheInterface = Components.interfaces.nsICache;
        var cacheService   = Components.classes["@mozilla.org/network/cache-service;1"].getService(Components.interfaces.nsICacheService);

        try
        {
            cacheService.evictEntries(cacheInterface.STORE_ON_DISK);
            cacheService.evictEntries(cacheInterface.STORE_IN_MEMORY);

            // If the hide informational dialogs preference is not set
            if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
            {
                webdeveloper_informationalDialog(stringBundle.getString("webdeveloper_clearCache"), stringBundle.getString("webdeveloper_clearCacheResult"));
            }
        }
        catch(exception)
        {
            // Do nothing
        }
    }
}

// Clears the history
function webdeveloper_clearHistory()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the clearing is confirmed
    if(webdeveloper_clearConfirmation(stringBundle.getString("webdeveloper_clearHistoryConfirmation")))
    {
        webdeveloper_removeAllFromHistory();

        // If the hide informational dialogs preference is not set
        if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
        {
            webdeveloper_informationalDialog(stringBundle.getString("webdeveloper_clearHistory"), stringBundle.getString("webdeveloper_clearHistoryResult"));
        }
    }
}

// Clears the HTTP authentication
function webdeveloper_clearHTTPAuthentication()
{
    var authenticationManager = Components.classes["@mozilla.org/network/http-auth-manager;1"].getService(Components.interfaces.nsIHttpAuthManager);

    authenticationManager.clearAll();

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");

        webdeveloper_informationalDialog(stringBundle.getString("webdeveloper_clearHTTPAuthentication"), stringBundle.getString("webdeveloper_clearHTTPAuthenticationResult"));
    }
}

// Allows the user to edit the HTML of the current page
function webdeveloper_editHTML()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");
    var editHTML     = stringBundle.getString("webdeveloper_editHTML");

    // If edit HTML is open in the dashboard
    if(webdeveloper_isOpenInDashboard(editHTML))
    {
        webdeveloper_closeInDashboard(editHTML);
    }
    else if(webdeveloper_pageHasFrames())
    {
        window.openDialog("chrome://webdeveloper/content/message/message.xul", "webdeveloper-message-dialog", "centerscreen,chrome,modal", stringBundle.getString("webdeveloper_framesNotSupported"));
    }
    else
    {
        webdeveloper_openInDashboard(editHTML, "chrome://webdeveloper/content/dashboard/edit_html.xul");
    }
}

// Linearizes all elements
function webdeveloper_linearizePage(element)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/linearize_page.css", "webdeveloper-linearize-page");
}

// Makes all the frames resizable
function webdeveloper_makeFramesResizable()
{
    var documentList    = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength  = documentList.length;
    var frame           = null;
    var framesList      = null;
    var framesLength    = null;
    var pageDocument    = null;
    var resizableFrames = 0;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        framesList   = pageDocument.getElementsByTagName("frame");
        framesLength = framesList.length;

        // Loop through all the frames
        for(var j = 0; j < framesLength; j++)
        {
            frame = framesList[j];

            // If the frame has a no resize attribute
            if(frame.hasAttribute("noresize"))
            {
                frame.removeAttribute("noresize");
                resizableFrames++;
            }
        }
    }

    // If the hide informational dialogs preference is not set
    if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");
        var title        = stringBundle.getString("webdeveloper_makeFramesResizable");

        // If one frame was made resizable
        if(resizableFrames == 1)
        {
            webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_makeFramesResizableSingleResult"));
        }
        else
        {
            webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_makeFramesResizableMultipleResult", [resizableFrames]));
        }
    }
}

// Shows all hidden elements
function webdeveloper_showHiddenElements()
{
    var computedStyle       = null;
    var display             = null;
    var documentList        = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength      = documentList.length;
    var element             = null;
    var hiddenElements      = new Array("area", "base", "basefont", "head", "meta", "param", "script", "style", "title");
    var inputElements       = null;
    var inputElementsLength = null;
    var pageDocument        = null;
    var tagName             = null;
    var treeWalker          = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument        = documentList[i];
        inputElements       = webdeveloper_evaluateXPath(pageDocument, "//input[@type='hidden']");
        inputElementsLength = inputElements.length;
        treeWalker          = pageDocument.createTreeWalker(webdeveloper_getDocumentBodyElement(pageDocument), NodeFilter.SHOW_ELEMENT, null, false);

        // Loop through all the input tags
        for(var j = 0; j < inputElementsLength; j++)
        {
            inputElements[j].setAttribute("type", "text");
				}
				
        // While the tree walker has more nodes
        while((element = treeWalker.nextNode()) != null)
        {
            computedStyle = element.ownerDocument.defaultView.getComputedStyle(element, null);

            // If the computed style is set
            if(computedStyle)
            {
                display = computedStyle.getPropertyCSSValue("display");
                tagName = element.tagName;

                // If this element has a display and tag name, the display is set to none and the tag name is not script
                if(display && tagName && display.cssText == "none" && !webdeveloper_contains(hiddenElements, tagName.toLowerCase()))
                {
                    element.style.display = "";
                }
            }
        }
    }
}

// Shows the window chrome
function webdeveloper_showWindowChrome()
{
    var browserWindow     = null;
    var windowEnumeration = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator).getEnumerator("navigator:browser");

    // Loop through the open windows
    while(windowEnumeration.hasMoreElements())
    {
        browserWindow = windowEnumeration.getNext();

        browserWindow.locationbar.visible = true;
        browserWindow.menubar.visible     = true;
        browserWindow.personalbar.visible = true;
        browserWindow.statusbar.visible   = true;
        browserWindow.toolbar.visible     = true;
    }
}

// Renders the page for a small screen
function webdeveloper_smallScreenRendering(element)
{
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var styleSheetList = new Array();

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        styleSheetList = styleSheetList.concat(webdeveloper_getStyleSheetsForDocument(documentList[i], false, false));
    }

    // If there is a handheld style sheet
    if(webdeveloper_hasStyleSheetForMedia(styleSheetList, "handheld"))
    {
        webdeveloper_displayCSSMediaType("handheld", !webdeveloper_convertToBoolean(element.getAttribute("checked")));
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-small-screen-rendering");
    }
    else
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/small_screen_rendering.css", "webdeveloper-small-screen-rendering");
    }
}

// Toggles all links on the page between visited and unvisited
function webdeveloper_toggleVisitedLinks(visited)
{
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var href           = null;
    var link           = null;
    var linkLength     = null;
    var linkList       = null;
    var pageDocument   = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        linkList     = pageDocument.links;
        linkLength   = linkList.length;

        // Loop through all the links
        for(var j = 0; j < linkLength; j++)
        {
            link = linkList[j];
            href = link.href;

            // If this link has an href
            if(href)
            {
                // If marking links as visited
                if(visited)
                {
                    webdeveloper_addToHistory(href);
                }
                else
                {
                    webdeveloper_removeFromHistory(href);
                }

                // Force the browser to recheck the history by changing the href
                link.href = "";
                link.href = href;
            }
        }
    }
}

// Updates the clear private data menu
function webdeveloper_updateClearPrivateDataMenu(suffix)
{
    var menu = document.getElementById("webdeveloper-clear-all-private-data-" + suffix);

    // If the menu exists
    if(menu)
    {
        // If the browser glue is not found
        if(!Components.classes["@mozilla.org/browser/browserglue;1"])
        {
            menu.setAttribute("class", "menuitem-iconic");
        }
        else if(menu.hasAttribute("class"))
        {
            menu.removeAttribute("class");
        }
    }
}

// Updates the miscellaneous menu
function webdeveloper_updateMiscellaneousMenu(suffix)
{
    var menu            = document.getElementById("webdeveloper-edit-html-" + suffix);
    var pageHasFrames   = webdeveloper_pageHasFrames();

    // If the menu exists
    if(menu)
    {
        var editHTMLOpen = webdeveloper_isOpenInDashboard(document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_editHTML"));

        webdeveloper_configureElement(menu, "checked", editHTMLOpen);

        // If edit HTML is not open and the page has frames
        if(!editHTMLOpen && pageHasFrames)
        {
            menu.setAttribute("class", "menuitem-iconic");
        }
        else if(menu.hasAttribute("class"))
        {
            menu.removeAttribute("class");
        }
    }

    menu = document.getElementById("webdeveloper-display-line-guides-" + suffix);

    // If the menu exists
    if(menu)
    {
        // If the page has frames
        if(pageHasFrames)
        {
            menu.setAttribute("class", "menuitem-iconic");
        }
        else if(menu.hasAttribute("class"))
        {
            menu.removeAttribute("class");
        }
    }

    menu = document.getElementById("webdeveloper-display-page-magnifier-" + suffix);

    // If the menu exists
    if(menu)
    {
        var canvas = document.getElementById("webdeveloper-page-magnifier");

        // If the canvas is not set or has no context
        if(!canvas || !canvas.getContext)
        {
            menu.setAttribute("class", "menuitem-iconic");
        }
        else if(menu.hasAttribute("class"))
        {
            menu.removeAttribute("class");
        }
    }

    menu = document.getElementById("webdeveloper-display-ruler-" + suffix);

    // If the menu exists
    if(menu)
    {
        // If the page has frames
        if(pageHasFrames)
        {
            menu.setAttribute("class", "menuitem-iconic");
        }
        else if(menu.hasAttribute("class"))
        {
            menu.removeAttribute("class");
        }
    }

    webdeveloper_configureElement(document.getElementById("webdeveloper-display-page-magnifier-" + suffix), "checked", !document.getElementById("webdeveloper-page-magnifier-toolbar").hidden);
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-display-line-guides-" + suffix), "checked", "webdeveloper-display-line-guides");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-display-ruler-" + suffix), "checked", "webdeveloper-display-ruler");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-linearize-page-" + suffix), "checked", "webdeveloper-linearize-page");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-show-comments-" + suffix), "checked", "webdeveloper-show-comments");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-small-screen-rendering-" + suffix), "checked", "webdeveloper-small-screen-rendering");
}
