// Initializes the resize dialog
function webdeveloper_initializeResize()
{
    var resizeViewport = webdeveloper_getBooleanPreference("webdeveloper.resize.viewport", true);

    document.getElementById("webdeveloper-resize-viewport").checked = resizeViewport;

    // If resizing the viewport
    if(resizeViewport)
    {
        document.getElementById("webdeveloper-resize-width").value  = window.arguments[2];
        document.getElementById("webdeveloper-resize-height").value = window.arguments[3];
    }
    else
    {
        document.getElementById("webdeveloper-resize-width").value  = window.arguments[0];
        document.getElementById("webdeveloper-resize-height").value = window.arguments[1];
    }
}

// Resizes the parent window to the given width and height
function webdeveloper_resizeParentWindow()
{
    var height = webdeveloper_trim(document.getElementById("webdeveloper-resize-height").value);
    var width  = webdeveloper_trim(document.getElementById("webdeveloper-resize-width").value);

    // If the width and height are valid
    if(width && height && (width == "*" || (parseInt(width) == width && width > 0)) && (height == "*" || (parseInt(height) == height && height > 0)))
    {
        var contentWindow = window.opener.content;
        var windowX       = window.opener.screenX;
        var windowY       = window.opener.screenY;

        // If resizing the view port
        if(document.getElementById("webdeveloper-resize-viewport").checked)
        {
            webdeveloper_setBooleanPreferenceIfNotSet("webdeveloper.resize.viewport", true);

            // If the width is not a wildcard
            if(width != "*")
            {
                contentWindow.innerWidth  = width;
            }

            // If the height is not a wildcard
            if(height != "*")
            {
                contentWindow.innerHeight = height;
            }
        }
        else
        {
            // If the resize viewport preference is set
            if(webdeveloper_isPreferenceSet("webdeveloper.resize.viewport"))
            {
                webdeveloper_deletePreference("webdeveloper.resize.viewport");
            }

            // If the width is a wildcard
            if(width == "*")
            {
                width = contentWindow.outerWidth;
            }

            // If the height is a wildcard
            if(height == "*")
            {
                height = contentWindow.outerHeight;
            }

            window.opener.resizeTo(width, height);
        }

        window.opener.screenX = windowX;
        window.opener.screenY = windowY;
    }
}
