// Shows a clear confirmation
function webdeveloper_clearConfirmation(message)
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    return webdeveloper_confirmationDialog(stringBundle.getString("webdeveloper_clearConfirmation"), message, stringBundle.getString("webdeveloper_clear"));
}

// Shows a close confirmation
function webdeveloper_closeConfirmation(message)
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    return webdeveloper_confirmationDialog(stringBundle.getString("webdeveloper_closeConfirmation"), message, stringBundle.getString("webdeveloper_close"));
}

// Shows a confirmation dialog
function webdeveloper_confirmationDialog(title, message, buttonText)
{
    // If the hide confirmation dialogs preference is not set to true
    if(!webdeveloper_getBooleanPreference("webdeveloper.confirmation.dialogs.hide", true))
    {
        var checkBox               = {value: false};
        var promptServiceInterface = Components.interfaces.nsIPromptService;
        var result                 = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(promptServiceInterface).confirmEx(null, title, message, promptServiceInterface.BUTTON_TITLE_IS_STRING * promptServiceInterface.BUTTON_POS_0 + promptServiceInterface.BUTTON_TITLE_CANCEL * promptServiceInterface.BUTTON_POS_1, buttonText, null, null, document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_stopConfirmation"), checkBox);

        // If the check box was checked
        if(checkBox.value)
        {
            webdeveloper_setBooleanPreference("webdeveloper.confirmation.dialogs.hide", true);
        }

        // If the delete is confirmed
        if(result == 0)
        {
            return true;
        }

        return false;
    }

    return true;
}

// Shows a delete confirmation
function webdeveloper_deleteConfirmation(message)
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    return webdeveloper_confirmationDialog(stringBundle.getString("webdeveloper_deleteConfirmation"), message, stringBundle.getString("webdeveloper_delete"));
}

// Shows an error message
function webdeveloper_error(message)
{
    Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService).alert(null, document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_errorMessage"), message);
}

// Shows an informational dialog
function webdeveloper_informationalDialog(title, message)
{
    var checkBox               = {value: false};
    var promptServiceInterface = Components.interfaces.nsIPromptService;
    var stringBundle           = document.getElementById("webdeveloper-string-bundle");
    var result                 = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(promptServiceInterface).alertCheck(null, title, message, stringBundle.getString("webdeveloper_stopInformational"), checkBox);

    // If the check box was checked
    if(checkBox.value)
    {
        webdeveloper_setBooleanPreference("webdeveloper.informational.dialogs.hide", true);
    }
}

// Shows a message
function webdeveloper_message(title, message)
{
    Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService).alert(null, title, message);
}
