// Loads the given application with the given URL
function webdeveloper_loadApplicationWithURL(application, url)
{
    // If the application and URL are set
    if(application && url)
    {
        application = new WebDeveloperApplication(application);

        application.launchWithURL(url);
    }
}

// Opens the DOM Inspector
function webdeveloper_openDOMInspector()
{
    // If the open DOM Inspector in sidebar preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.dom.inspector.sidebar", true))
    {
        window.openWebPanel(document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_domInspector"), "chrome://inspector/content/sidebar.xul");
        window.setTimeout(BrowserReloadSkipCache, 1000);
    }
    else
    {
        inspectDOMDocument(getBrowser().contentDocument);
    }
}

// Opens the Java Console
function webdeveloper_openJavaConsole()
{
    Components.classes["@mozilla.org/oji/jvm-mgr;1"].getService(Components.interfaces.nsIJVMManager).showJavaConsole();
}

// Updates the tools menu
function webdeveloper_updateToolsMenu(menu, suffix)
{
    var bookmarklet           = null;
    var bookmarkletPreference = null;
    var description           = null;
    var descriptionPreference = null;
    var key                   = null;
    var menuItem              = null;
    var path                  = null;
    var separator             = null;
    var toolPreference        = null;
    var toolsCount            = webdeveloper_getIntegerPreference("webdeveloper.tool.count", true);
    var toolsSeparator        = menu.getElementsByAttribute("id", "webdeveloper-tools-separator-" + suffix)[0];
    var url                   = null;

    webdeveloper_removeGeneratedMenuItems(menu);

    // Loop through the possible tools
	for(var i = 1; i <= toolsCount; i++)
	{
        bookmarklet = "webdeveloper.tool." + i + ".bookmarklet";
        description = "webdeveloper.tool." + i + ".description";
        key         = "webdeveloper.tool." + i + ".key";
        path        = "webdeveloper.tool." + i + ".path";
        separator   = "webdeveloper.tool." + i + ".separator";
        url         = "webdeveloper.tool." + i + ".url";

        // If the separator preference is set
        if(webdeveloper_getBooleanPreference(separator, true))
        {
            menuItem = document.createElement("menuseparator");
            menuItem.setAttribute("class", "webdeveloper-generated-menu");
            menu.insertBefore(menuItem, toolsSeparator);
        }
        else if(webdeveloper_isPreferenceSet(description) && (webdeveloper_isPreferenceSet(bookmarklet) || webdeveloper_isPreferenceSet(path) || webdeveloper_isPreferenceSet(url)))
        {
    	    descriptionPreference = webdeveloper_getStringPreference(description, true);

            // If the description is not blank
            if(descriptionPreference != "")
            {
                menuItem = document.createElement("menuitem");
                menuItem.setAttribute("class", "webdeveloper-generated-menu");
                menuItem.setAttribute("label", descriptionPreference);

                // If the bookmarklet preference is set
                if(webdeveloper_getStringPreference(bookmarklet, true))
                {
                    menuItem.setAttribute("oncommand", "webdeveloper_runBookmarklet('" + encodeURIComponent(webdeveloper_getStringPreference(bookmarklet, true)).replace(new RegExp("'", "gi"), "\\'") + "')");
                }
                else if(webdeveloper_getStringPreference(path, true))
                {
                    menuItem.setAttribute("oncommand", "webdeveloper_loadApplicationWithURL('" + webdeveloper_getStringPreference(path, true).replace(/\\/gi, "\\\\") + "', getBrowser().currentURI.spec)");
                }
                else
                {
                    menuItem.setAttribute("oncommand", "webdeveloper_loadURL('" + webdeveloper_getStringPreference(url, true) + "' + encodeURIComponent(getBrowser().currentURI.spec))");
                }

                // If the key preference is set
                if(webdeveloper_isPreferenceSet(key))
                {
                    menuItem.setAttribute("key", key);
                }

                menu.insertBefore(menuItem, toolsSeparator);
            }
        }
	}

    webdeveloper_configureElement(document.getElementById("webdeveloper-dom-inpsector-" + suffix), "disabled", !Components.classes["@mozilla.org/inspector/dom-utils;1"]);
    webdeveloper_configureElement(document.getElementById("webdeveloper-java-console-" + suffix), "disabled", !webdeveloper_getBooleanPreference("security.enable_java", false));
}

// Validates local CSS
function webdeveloper_validateLocalCSS()
{
    var stringBundle       = document.getElementById("webdeveloper-string-bundle");
    var temporaryDirectory = Components.classes["@mozilla.org/file/directory_service;1"].getService(Components.interfaces.nsIProperties).get("TmpD", Components.interfaces.nsIFile);

    // If the temporary directory exists, is a directory and is writable
    if(temporaryDirectory.exists() && temporaryDirectory.isDirectory() && temporaryDirectory.isWritable())
    {
        var cssFile           = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
        var documentList      = webdeveloper_getDocuments(webdeveloper_getContentWindow());
        var documentLength    = documentList.length;
        var documentURL       = null;
        var inputElement      = null;
        var oldTab            = getBrowser().selectedTab;
        var outputStream      = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
        var pageDocument      = null;
        var styleSheet        = null;
        var styleSheetHref    = null;
        var styleSheetLength  = null;
        var styleSheetList    = null;
        var styleText         = "";
        var uri               = getBrowser().currentURI;
        var generatedDocument = webdeveloper_generateDocument("");
        var bodyElement       = generatedDocument.body;
        var formElement       = generatedDocument.createElement("form");
        var headElement       = generatedDocument.getElementsByTagName("head")[0];
        var imageElement      = generatedDocument.createElement("img");
        var pElement          = generatedDocument.createElement("p");
        var scriptElement     = generatedDocument.createElement("script");
        var styleElement      = null;

        generatedDocument.title = stringBundle.getString("webdeveloper_validateCSS");

        // Loop through the documents
        for(var i = 0; i < documentLength; i++)
        {
            pageDocument     = documentList[i];
            documentURL      = pageDocument.documentURI;
            styleSheetList   = pageDocument.getElementsByTagName("style");
            styleSheetLength = styleSheetList.length;

            // Loop through the style sheets
            for(var j = 0; j < styleSheetLength; j++)
            {
                styleElement = styleSheetList[j];
                styleSheet   = styleElement.sheet;

                // If this is a valid style sheet
                if(webdeveloper_isValidStyleSheet(styleSheet))
                {
                    styleText += "/* " + stringBundle.getFormattedString("webdeveloper_embeddedStylesFrom", [styleSheet.href]) + " */\n\n";
                    styleText += styleElement.innerHTML.trim() + "\n\n";
                }
            }

            styleSheetList   = webdeveloper_getStyleSheetsForDocument(pageDocument, true, true);
            styleSheetLength = styleSheetList.length;

            // Loop through the style sheets
            for(j = 0; j < styleSheetLength; j++)
            {
                styleSheetHref = styleSheetList[j].href;

                // If this is not an inline style sheet
                if(styleSheetHref != documentURL)
                {
                    styleText += webdeveloper_retrieveSource(styleSheetHref);
                }
            }
        }

        temporaryDirectory.append("webdeveloper_" + uri.host + "_" + new Date().getTime() + ".css");
        cssFile.initWithPath(temporaryDirectory.path);
        cssFile.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 00644);
        outputStream.init(cssFile, 0x04 | 0x08 | 0x20 | 0x40, 00644, null);

        outputStream.write(styleText, styleText.length);
        outputStream.close();

        webdeveloper_addGeneratedStyles(generatedDocument);

        imageElement.setAttribute("alt", "loading");
        imageElement.setAttribute("src", "chrome://webdeveloper/content/images/loading.gif");
        pElement.appendChild(imageElement);
        pElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_contactingValidator")));
        pElement.setAttribute("class", "loading");
        bodyElement.appendChild(pElement);

        formElement.setAttribute("action", "http://jigsaw.w3.org/css-validator/validator");
        formElement.setAttribute("enctype", "multipart/form-data");
        formElement.setAttribute("method", "post");
        formElement.setAttribute("style", "display: none");

        inputElement = generatedDocument.createElement("input");

        inputElement.setAttribute("name", "profile");
        inputElement.setAttribute("type", "hidden");
        inputElement.setAttribute("value", webdeveloper_getStringPreference("webdeveloper.validate.local.css.profile", true));
        formElement.appendChild(inputElement);

        inputElement = generatedDocument.createElement("input");

        inputElement.setAttribute("name", "usermedium");
        inputElement.setAttribute("type", "hidden");
        inputElement.setAttribute("value", "all");
        formElement.appendChild(inputElement);

        inputElement = generatedDocument.createElement("input");

        inputElement.setAttribute("name", "warning");
        inputElement.setAttribute("type", "hidden");
        inputElement.setAttribute("value", "2");
        formElement.appendChild(inputElement);

        inputElement = generatedDocument.createElement("input")

        inputElement.setAttribute("name", "file");
        inputElement.setAttribute("type", "file");

        inputElement.value = cssFile.path;

        formElement.appendChild(inputElement);
        bodyElement.appendChild(formElement);

        scriptElement.setAttribute("defer", "defer");
        scriptElement.setAttribute("src", "chrome://webdeveloper/content/generated/submit_form.js");
        scriptElement.setAttribute("type", "text/javascript");
        headElement.appendChild(scriptElement);

        // If the open tabs in background preference is set to true
        if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
        {
            getBrowser().selectedTab = oldTab;
        }
    }
    else
    {
        webdeveloper_error(stringBundle.getFormattedString("webdeveloper_tempDirectoryFailed", [temporaryDirectory.path]));
    }
}

// Validates a local HTML file
function webdeveloper_validateLocalHTML()
{
    new WebDeveloperValidateHTML().validateHTML(getBrowser().currentURI);
}

// Tidies the HTML before validating
function webdeveloper_validateTidiedHTML()
{
    var formElement       = null;
    var inputElement      = null;
    var oldTab            = getBrowser().selectedTab;
    var oldURL            = getBrowser().currentURI.spec;
    var generatedDocument = webdeveloper_generateDocument("");
    var output            = "";

    output = webdeveloper_retrieveSource(oldURL);

    // If closing <br> tags
    if(webdeveloper_getBooleanPreference("webdeveloper.validate.tidied.html.close.br", true))
    {
        output = output.replace(new RegExp("<br>", "gi"), "<br />");
    }

    // If escaping ampersands
    if(webdeveloper_getBooleanPreference("webdeveloper.validate.tidied.html.escape.ampersand", true))
    {
        output = output.replace(new RegExp("&(?!#?[xX]?(?:[0-9a-fA-F]+|\w{1,8});)", "gi"), "&amp;");
    }

    formElement = generatedDocument.createElement("form");

    formElement.setAttribute("action", "http://validator.w3.org/check");
    formElement.setAttribute("method", "post");

    inputElement = generatedDocument.createElement("input");

    inputElement.setAttribute("name", "verbose");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("value", "1");
    formElement.appendChild(inputElement);

    inputElement = generatedDocument.createElement("input");

    inputElement.setAttribute("name", "doctype");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("value", "HTML 4.01 Transitional");
    formElement.appendChild(inputElement);

    inputElement = generatedDocument.createElement("input");

    inputElement.setAttribute("name", "fbd");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("value", "1");
    formElement.appendChild(inputElement);

    inputElement = generatedDocument.createElement("input");

    inputElement.setAttribute("name", "ss");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("value", "1");
    formElement.appendChild(inputElement);

    inputElement = generatedDocument.createElement("input");

    inputElement.setAttribute("name", "fragment");
    inputElement.setAttribute("type", "hidden");

    inputElement.value = output;

    formElement.appendChild(inputElement);

    generatedDocument.body.appendChild(formElement);
    formElement.submit();

    // If the open tabs in background preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
    {
        getBrowser().selectedTab = oldTab;
    }
}

// Constructs a validate HTML object
function WebDeveloperValidateHTML()
{
    this.file        = null;
    this.fileElement = null;
    this.formElement = null;
}

// Creates a source file
WebDeveloperValidateHTML.prototype.createSourceFile = function(temporaryDirectory, uri)
{
    var fileName   = uri.host;
    var sourceFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);

    temporaryDirectory.append("webdeveloper_" + fileName + "_" + new Date().getTime() + ".html");
    sourceFile.initWithPath(temporaryDirectory.path);

    return sourceFile;
}

// Returns the post data
WebDeveloperValidateHTML.prototype.getPostData = function()
{
    // Try to get the post data
    try
    {
        var sessionHistory = getWebNavigation().sessionHistory;
        var entry          = sessionHistory.getEntryAtIndex(sessionHistory.index, false).QueryInterface(Components.interfaces.nsISHEntry);

        return entry.postData;
    }
    catch(exception)
    {
        return null;
    }
}

// Validate the HTML from the given URI
WebDeveloperValidateHTML.prototype.validateHTML = function(uri)
{
    var stringBundle       = document.getElementById("webdeveloper-string-bundle");
    var temporaryDirectory = Components.classes["@mozilla.org/file/directory_service;1"].getService(Components.interfaces.nsIProperties).get("TmpD", Components.interfaces.nsIFile);

    // If the temporary directory exists, is a directory and is writable
    if(temporaryDirectory.exists() && temporaryDirectory.isDirectory() && temporaryDirectory.isWritable())
    {
        var characterSet               = getBrowser().contentDocument.characterSet;
        var inputElement               = null;
        var oldTab                     = getBrowser().selectedTab;
        var oldURL                     = getBrowser().currentURI.spec;
        var generatedDocument          = webdeveloper_generateDocument("");
        var bodyElement                = generatedDocument.body;
        var imageElement               = generatedDocument.createElement("img");
        var pElement                   = generatedDocument.createElement("p");
        var webBrowserPersistInterface = Components.interfaces.nsIWebBrowserPersist;
        var webBrowserPersist          = Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"].createInstance(webBrowserPersistInterface);

        generatedDocument.title            = stringBundle.getString("webdeveloper_validateHTML");
        this.file                          = this.createSourceFile(temporaryDirectory, uri);
        this.formElement                   = generatedDocument.createElement("form");
        webBrowserPersist.persistFlags     = webBrowserPersistInterface.PERSIST_FLAGS_AUTODETECT_APPLY_CONVERSION | webBrowserPersistInterface.PERSIST_FLAGS_FROM_CACHE | webBrowserPersistInterface.PERSIST_FLAGS_REPLACE_EXISTING_FILES;
        webBrowserPersist.progressListener = this;

        webdeveloper_addGeneratedStyles(generatedDocument);

        imageElement.setAttribute("alt", "loading");
        imageElement.setAttribute("src", "chrome://webdeveloper/content/images/loading.gif");
        pElement.appendChild(imageElement);
        pElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_contactingValidator")));
        pElement.setAttribute("class", "loading");
        bodyElement.appendChild(pElement);

        this.formElement.setAttribute("action", "http://validator.w3.org/check");
        this.formElement.setAttribute("enctype", "multipart/form-data");
        this.formElement.setAttribute("method", "post");
        this.formElement.setAttribute("style", "display: none");

        // If the show outline preference is set
        if(webdeveloper_getBooleanPreference("webdeveloper.validate.local.html.show.outline", true))
        {
            inputElement = generatedDocument.createElement("input");

            inputElement.setAttribute("name", "outline");
            inputElement.setAttribute("type", "hidden");
            inputElement.setAttribute("value", "1");
            this.formElement.appendChild(inputElement);
        }

        // If the show parse tree preference is set
        if(webdeveloper_getBooleanPreference("webdeveloper.validate.local.html.show.parse.tree", true))
        {
            inputElement = generatedDocument.createElement("input");

            inputElement.setAttribute("name", "sp");
            inputElement.setAttribute("type", "hidden");
            inputElement.setAttribute("value", "1");
            this.formElement.appendChild(inputElement);
        }

        // If the show source preference is set
        if(webdeveloper_getBooleanPreference("webdeveloper.validate.local.html.show.source", true))
        {
            inputElement = generatedDocument.createElement("input");

            inputElement.setAttribute("name", "ss");
            inputElement.setAttribute("type", "hidden");
            inputElement.setAttribute("value", "1");
            this.formElement.appendChild(inputElement);
        }

        inputElement = generatedDocument.createElement("input");

        inputElement.setAttribute("name", "charset");
        inputElement.setAttribute("type", "hidden");
        inputElement.setAttribute("value", characterSet);
        this.formElement.appendChild(inputElement);

        inputElement = generatedDocument.createElement("input");

        inputElement.setAttribute("name", "verbose");
        inputElement.setAttribute("type", "hidden");
        inputElement.setAttribute("value", "1");
        this.formElement.appendChild(inputElement);

        this.fileElement = generatedDocument.createElement("input");

        this.fileElement.setAttribute("name", "uploaded_file");
        this.fileElement.setAttribute("type", "file");
        this.formElement.appendChild(this.fileElement);
        bodyElement.appendChild(this.formElement);

        // If the open tabs in background preference is set to true
        if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
        {
            getBrowser().selectedTab = oldTab;
        }

        webBrowserPersist.saveURI(uri, null, uri, this.getPostData(), null, this.file);
    }
    else
    {
        webdeveloper_error(stringBundle.getFormattedString("webdeveloper_tempDirectoryFailed", [temporaryDirectory.path]));
    }
}

// Launch the application with the given URL
WebDeveloperValidateHTML.prototype.submitForm = function()
{
    this.fileElement.value = this.file.path;

    this.formElement.submit();
}

// Called when the progress state changes
WebDeveloperValidateHTML.prototype.onStateChange = function(webProgress, request, stateFlags, status)
{
    // If the progress has stopped
    if(stateFlags & Components.interfaces.nsIWebProgressListener.STATE_STOP)
    {
        this.submitForm();
    }
}

// Indicates the interfaces this object supports
WebDeveloperValidateHTML.prototype.QueryInterface = function(id)
{
    // If the query is for a supported interface
    if(id.equals(Components.interfaces.nsISupports) || id.equals(Components.interfaces.nsIWebProgressListener))
    {
        return this;
    }

    throw Components.results.NS_NOINTERFACE;
}

// Dummy methods requiring implementations
WebDeveloperValidateHTML.prototype.onLocationChange = function(webProgress, request, location) {}
WebDeveloperValidateHTML.prototype.onProgressChange = function(webProgress, request, currentSelfProgress, maximumSelfProgress, currentTotalProgress, maximumTotalProgress) {}
WebDeveloperValidateHTML.prototype.onSecurityChange = function(webProgress, request, state) {}
WebDeveloperValidateHTML.prototype.onStatusChange   = function(webProgress, request, status, message) {}
