var webdeveloper_lastCommentShown = null;

// Clears the comments from the page
function webdeveloper_clearComments(pageDocument)
{
    var commentIconDiv = null;
    var i              = 0;

    webdeveloper_lastCommentShown = null;

    // While there is a comment icon div
    while((commentIconDiv = pageDocument.getElementById("webdeveloper-comment-icon" + i)) != null)
    {
        pageDocument.body.removeChild(commentIconDiv);
        pageDocument.body.removeChild(pageDocument.getElementById("webdeveloper-comment-text" + i));

        i++;
    }
}

// Shows the comment text
function webdeveloper_showCommentText(event)
{
    var target = event.target;

    // If there is an event target
	if(target)
	{
        var currentDocument      = webdeveloper_getContentDocument();
	    var lastCommentElement   = null;
        var targetComment        = target.id.replace(new RegExp("icon", "gi"), "text");
        var targetCommentElement = currentDocument.getElementById(targetComment);

        // If this is not the last comment shown
        if(webdeveloper_lastCommentShown && webdeveloper_lastCommentShown != targetComment)
        {
            lastCommentElement = currentDocument.getElementById(webdeveloper_lastCommentShown);

            // If the last comment element exists
            if(lastCommentElement)
            {
                lastCommentElement.style.display = "none";
            }
        }

        // If the element is currently hidden
        if(targetCommentElement.style.display == "none")
        {
            targetCommentElement.style.display = "block";
        }
        else
        {
            targetCommentElement.style.display = "none";
        }

        webdeveloper_lastCommentShown = targetComment;
	}
}

// Toggles comments
function webdeveloper_toggleComments(element, applyStyle)
{
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var pageDocument   = null;
    var show           = element.getAttribute("checked");

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        webdeveloper_toggleCommentsForDocument(pageDocument, show);
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/show_comments.css", "webdeveloper-show-comments", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-show-comments-tooltips", "div.webdeveloper-comment-icon, div.webdeveloper-comment-text, div.webdeveloper-comment-text *");
}

// Toggles the comments for a document
function webdeveloper_toggleCommentsForDocument(pageDocument, show)
{
    var comment        = null;
    var commentsLength = 0;
    var commentsList   = new Array();
    var parentElement  = null;
    var treeWalker     = pageDocument.createTreeWalker(pageDocument, NodeFilter.SHOW_COMMENT, null, false);

    webdeveloper_lastCommentShown = null;

    // While the tree walker has more nodes
    while((comment = treeWalker.nextNode()) != null)
    {
        commentsList.push(comment);
    }

    // Remove XML declaration
    if(commentsList.length > 0 && commentsList[0].nodeValue.indexOf("encoding") != -1)
    {
        commentsList.shift();
    }

    // Remove DOCTYPE
    if(commentsList.length > 0 && commentsList[0].nodeValue.indexOf("DOCTYPE") != -1)
    {
        commentsList.shift();
    }

    commentsLength = commentsList.length;

    // If showing comments
    if(show)
    {
        var commentDiv              = null;
        var commentIconDiv          = null;
        var commentLeft             = 0;
        var commentParent           = null;
        var commentParentOffsetLeft = 0;
        var commentParentOffsetTop  = 0;
        var commentText             = null;
        var commentTop              = 0;
        var iconSize                = 17;

        // Loop through the comments
		for(var i = 0; i < commentsLength; i++)
		{
		    comment       = commentsList[i];
		    commentLeft   = 0;
		    commentParent = comment.parentNode;
			commentText   = comment.nodeValue;
			commentTop    = 0;

			commentText = commentText.replace(new RegExp("<!--[\s]*", "gi"), "");
			commentText = commentText.replace(new RegExp("[\s]*-->", "gi"), "");
			commentText = commentText.replace(new RegExp("<([^\/][^>]*)class=\"[^\"]*\">", "gi"), "<$1>");
			commentText = commentText.replace(new RegExp("<([^\/][^>]*)class=[^ >]*>", "gi"), "<$1>");

            // While the comment has a parent
			while(commentParent)
			{
			    // If the parent node is not a document node or a table row
				if(commentParent.nodeType != Node.DOCUMENT_NODE && commentParent.tagName && commentParent.tagName.toLowerCase() != "tr")
				{
				    commentParentOffsetLeft = commentParent.offsetLeft;
				    commentParentOffsetTop  = commentParent.offsetTop;

				    // If the parent node has a left offset
				    if(commentParentOffsetLeft)
				    {
					    commentLeft += commentParentOffsetLeft;
					}

				    // If the parent node has a top offset
				    if(commentParentOffsetTop)
				    {
					    commentTop += commentParentOffsetTop;
					}
				}

				commentParent = commentParent.parentNode;
			}

            // If the comment left offset is 0
            if(commentLeft == 0)
            {
                commentLeft = 1;
            }
            else if(commentLeft + iconSize > pageDocument.body.offsetWidth)
            {
                commentLeft = pageDocument.body.offsetWidth;
            }

            // If the comment top offset is 0
            if(commentTop == 0)
            {
                commentTop = 1;
            }

			// If this is not the first comment
			if(i > 0)
			{
			    // Loop through previous comments
				for(var j = 0; j < i; j++)
				{
				    // If the top off set of a previous comment matches this comment
					if(parseInt(pageDocument.getElementById("webdeveloper-comment-icon" + j).style.top) == commentTop)
					{
						commentTop += iconSize;
					}
				}
			}

			commentIconDiv            = pageDocument.createElement("div");
			commentIconDiv.style.left = commentLeft + "px";
			commentIconDiv.style.top  = commentTop + "px";

			commentIconDiv.addEventListener("click", webdeveloper_showCommentText, true);
            commentIconDiv.appendChild(pageDocument.createTextNode("!"));
			commentIconDiv.setAttribute("class", "webdeveloper-comment-icon");
			commentIconDiv.setAttribute("id", "webdeveloper-comment-icon" + i);

			pageDocument.body.appendChild(commentIconDiv);

			commentDiv            = pageDocument.createElement("div");
			commentDiv.style.left = commentLeft + iconSize + "px";
			commentDiv.style.top  = commentTop + "px";

            commentDiv.appendChild(pageDocument.createTextNode(commentText));
			commentDiv.setAttribute("class", "webdeveloper-comment-text");
			commentDiv.setAttribute("id", "webdeveloper-comment-text" + i);

			pageDocument.body.appendChild(commentDiv);

            // If the offset width is greater than 200
			if(commentDiv.offsetWidth > 200)
			{
				commentDiv.style.width = "200px";
			}

            // If the offset height is greater than 100
			if(commentDiv.offsetHeight > 100)
			{
				commentDiv.style.height   = "100px";
				commentDiv.style.overflow = "auto";
			}

            // If the comment is positioned outside the document
			if(commentLeft + iconSize + commentDiv.offsetWidth > pageDocument.body.offsetWidth)
			{
				commentDiv.style.left = commentLeft - commentDiv.offsetWidth - iconSize + "px";
			}

			commentDiv.style.display = "none";
		}
    }
    else
    {
        webdeveloper_clearComments(pageDocument);
    }
}
