//<copyright>
//
// Copyright (c) 1995-96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>


//<file>
//
//
// Name :       jpegimage.h
//
// Purpose :    Interface to class JpegImage
//
// Created :    04 Jan 95    Bernhard Marschall
// Modified :   03 Aug 95    Bernhard Marschall
//
// $Id: jpegimage.h,v 1.5 1996/02/29 12:42:32 bmarsch Exp $
//
// Description:
//
//</file>
//
// $Log: jpegimage.h,v $
// Revision 1.5  1996/02/29 12:42:32  bmarsch
// Always call decodedInterlaced() callback after a pass (also
// in finishDecode())
//

#ifndef harmony_widgets_jpegimage_h
#define harmony_widgets_jpegimage_h

#include "libwidgets.h"
#include "rimage.h"

class JpegImpl;


//<class>
//
// Name:       JpegImage
//
// Purpose:    decoding of JPEG (JFIF) images
//
//
// Public Interface:
// As in base class RasterImage.
//
//
// Description:
// JpegImage implements decoding of JPEG (JFIF) images by using the
// IJG's jpeg library (version 5).
//
//</class>


class JpegImage : public RasterImage {
public:
  JpegImage(FILE*, const char* fname, Raster*& raster,
            HgRasterCallback* = nil, boolean dither = true);
  virtual ~JpegImage();

  virtual void decode(int numrows);
  virtual void finishDecode();
  virtual void abortDecode();
  virtual int not_live() const { return 0; }

private:
  void put_pixel_rows(int num_rows);      // copy buffer_ to data_
  JpegImpl* impl_;
};

#endif
