// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1994
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        fdmask.C
// 
// Purpose:     
// 
// Created:     2 Nov 95   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// 
// </file> 
#include "fdmask.h"

#include <string.h>

#if defined (LINUX)
// for the fd_set macros 
#  include <sys/time.h>
#endif



#ifdef WIN32
FdMask::FdMask(const FdMask& fdM)
{
  memcpy((fd_set*)this, &fdM, sizeof(FdMask));
}

FdMask& FdMask::operator=(const FdMask& fdM)
{
  memcpy((fd_set*)this, &fdM, sizeof(FdMask));
  return *this;
}

void FdMask::zero() 
{ 
  memset((fd_set*)this, 0, sizeof(fd_set));
  FD_ZERO((fd_set*)this);
}

void FdMask::setBit(int fd) 
{ 
  FD_SET((SOCKET)fd,(fd_set*)this); 
}

void FdMask::clrBit(int fd) 
{ 
  FD_CLR((SOCKET)fd,(fd_set*)this); 
}

boolean FdMask::isSet(int fd) const 
{ 
  return FD_ISSET((SOCKET)fd,(fd_set*)this); 
}

boolean FdMask::anySet() const 
{
  if (fd_count > 0) 
    return true;
  else
    return false;
}

int FdMask::numSet() const
{
  return fd_count;
}
#else /* WIN32 */
void FdMask::zero() {
   ::memset (this, 0, sizeof(FdMask)); 
}

void FdMask::setBit(int fd) { FD_SET(fd,this); }
void FdMask::clrBit(int fd) { FD_CLR(fd,this); }
boolean FdMask::isSet(int fd) const { return FD_ISSET(fd,this); }

boolean FdMask::anySet() const {
    const int mskcnt = howmany(FD_SETSIZE,NFDBITS);
    for (int i = 0; i < mskcnt; i++) {
	if (fds_bits[i]) {
	    return true;
	}
    }
    return false;
}

int FdMask::numSet() const {
    const int mskcnt = howmany(FD_SETSIZE,NFDBITS);
    int n = 0;
    for (int i = 0; i < mskcnt; i++) {
	if (fds_bits[i]) {
	    for (int j = 0; j < NFDBITS; j++) {
		if ((fds_bits[i] & (1 << j)) != 0) {
		    n += 1;
		}
	    }
	}
    }
    return n;
}
#endif /* WIN32 */
