
  // ------------------------------------------------------------------------ //
  // Author               : This file has been written by                     //
  //                            Yann Renard (MyselF / Dim4)                   //
  // Copyright            : This file is totaly free and you may distribute   //
  //                        it to anyone you want, without modifying this     //
  //                        header. If you use it in a commercial project (?) //
  //                        or in bigger project (!), I would be glad to know //
  //                        about it :) Please mail me...                     //
  //                        be glad to know about it, please mail me          //
  // Contact              : You can contact me at                             //
  //                            renard@esiea-ouest.fr                         //
  //                            myself_yr@hotmail.com                         //
  // Bug reports          : Mail me please so I can know about it             //
  // Purpose of this file : This package is my first experiment in bones      //
  //                        programming. I feel it works great for a first    //
  //                        time. For sure their are lots of optim to do...   //
  //                        Your ideas are welcome :)                         //
  // Version              : 1.0                                               //
  // History              : none                                              //
  // ToDo                 : lot's of things :)                                //
  //                        other things :))))                                //
  //                        Maybe buid an HTML tutorial about this subject ?  //
  // Greets               : Dim4 members :)                                   //
  //                        Latex, teacher forever                            //
  //                        Ethereal, thx for ideas of implementation         //
  //                        #codefr, thx for url                              //
  //                        comp.graphics.algorithm && comp.graphics.opengl   //
  //                        pech' and yoyo... newbies in demo hey !           //
  // ------------------------------------------------------------------------ //

  //-----------------------------------------------------
  // This is the main class that is to animate the bones
  // and the 3d mesh correctly... It creates the link
  // bettween the different vertices and bones and
  // calculates the new position each time you ask

  // Typical use of this class :
  //   myBoneAnimator.registerMesh ( oneMesh );
  //   myBoneAnimator.registerSkeleton ( oneSkeleton );
  //   myBoneAnimator.compileLinkList ();
  //   ... in loop ...
  //     change skeleton current pos
  //   myBoneAnimator.animate ();
  //   myBoneAnimator.render ();
  //   ... end loop ...

#ifndef __BONEANIMATOR_H__
#define __BONEANIMATOR_H__

#include "boneCommon.h"
#include "boneList.h"
#include "boneMesh3d.h"
#include "boneLink.h"
#include "boneVert.h"

   class BONEANIMATOR
    {
     public :

     //------------------------
     // Datas in bone animator

     // -> What we'll animate
     MESH3D * meshToMove;
     BONEVERTEX * skeleton;

     // -> Links management
     LIST < LINK > linkList;
     LINK       ** link;
     int           links;
     int           linkListCompiled;

     //----------------------
     // Construct / destruct
     BONEANIMATOR ( void );
     ~BONEANIMATOR ( void );

     //-----------------
     // Accessing datas
     void registerMesh ( MESH3D * zeMesh );
     void registerSkeleton ( BONEVERTEX * zeRoot );

     //--------------------------------------
     // Operations on both mesh and skeleton
     void scale ( float sx, float sy, float sz );

     //------------------
     // List compilation
     void  compileLinkList ( void );
     void    emptyLinkList ( void );
     void generateLinkList ( void );
     inline float getLength ( VERTEX * vertex, BONEVERTEX * node );
     inline float getWeight ( VERTEX * vertex, BONEVERTEX * node );

     //-----------------------------------------------
     // Rendering and animating the mesh and skeleton
     void render ( void );
     void renderSkeletonNode ( BONEVERTEX * node );
     void animate ( void );
     void animateSkeletonNode ( BONEVERTEX * node );

     private :

     void addNodeAndChildren ( BONEVERTEX * boneVertex , LIST < BONEVERTEX > * list );
    };

#endif
