#ifndef WOBJECT_H
#define WOBJECT_H


/* increment OBJECTSNUMBER  below */
#define OBJECTSNUMBER		44

#define UNKNOWN_TYPE		-1
#define END_TYPE		0
#define END_NAME		"end"

/* behavior of object */
#define VR_STILL		0
#define VR_MOBILE		1
#define VR_INVISIBLE		2

#define VR_VOLATILE		0
#define VR_PERMANENT		1

#define VR_ELEM_MOVE		0
#define VR_NO_ELEM_MOVE		1
#define VR_BB			0
#define VR_NO_BB		2
#define VR_SELECTABLE		0
#define VR_NO_SELECTABLE	4
#define VR_NORMAL_RENDER	0
#define VR_SPECIAL_RENDER	8


struct _Payload;

struct Name {
  char class_name[HNAME_LEN];	// name of an object class
  u_int8 named;			// named or not
  char given_name[OBJNAME_LEN];	// explicit name
  char *instance_name;		// name of an instancied object
  const char *infos;		// infos of an instancied object
  const char *world_name;	// name of world where is this object
  char url[URL_LEN];		// url
};

struct Pos {
  float x;			// x position
  float y;			// y position
  float z;			// z position
  float az;			// angle plan xy axis z
  float ay;			// angle plan xz axis y
  float ax;			// angle plan yz axis x
  V3 bbcenter;			// Bounding Box's center
  V3 bbsize;			// Bounding Box's dimension
  u_int8 state;			// state
  u_int8 group;			// group
};

struct Nature {
  u_int8 collision;		// collision behavior
  u_int8 viscuosity;		// viscuosity info
  u_int8 density;		// density info
  u_int8 persistency;		// persistency info
  u_int8 movable;		// is movable ?
  u_int8 bbable;		// has a bb ?
  u_int8 selectable;		// is selectable ?
  u_int8 renderable;		// is renderable ?
};

struct State {
  u_int8 state;			// state of object
  u_int8 collide;		// collision count
  boolean ispointed;		// grid flag
};

struct Move {
  V3 lspeed;			// linear speed
  V3 aspeed;			// angular speed
  time_t sec;			// timestamp
  time_t usec;			// timestamp
  time_t perm_sec;		// time in sec of last permanent movement
  time_t perm_usec;		// time in usec of last permanent movement
  float ttl;			// time to live
};

#define WCLASS

typedef void (WCreator) (char *);
typedef class WObject* WReplicator(u_int8 type_id, 
				   struct _NetObjectId noid, 
				   struct _Payload *pp);
class WClass {
  static WClass **objects_table;
  static int    table_size;
 public:
  const int          type_id;
  const char*  const type_name;
  WCreator*    const creator;
  WReplicator* const replicator;

  WClass(int type_id, const char *type_name, WCreator*, WReplicator* = NULL);

  static void creatorInstance(int type_id, char *l);	// from file
  static void creatorInstance(int type_id);		// builtin
  static class WObject* replicatorInstance(u_int8 type_id,
					   struct _NetObjectId noid, 
					   struct _Payload *pp);
  static const WClass* getWClass(int type_id);
  static const WClass* getWClass(const char *type_name);
  static void registerWClass(WClass&);
};

/* WObject common abstract class */
class WObject {
public:
  NetObject noh;		// reserved field for network
  struct _ZVSolid *soh;		// reserved field for 3D
  void *ptrgui;			// reserved fiels for GUI
  Name name;			// names
  Pos pos;			// position in the space
  State state;			// object's state
  Nature nature;		// object's nature
  Move move;			// movement specific
  WObject *next;		// grouped objects
  WObject *prev;		// grouped objects

  WObject();			// constructor
  virtual ~WObject();		// destructor

  //ELC virtual const WClass* getWClass() = 0;  // abstract really
  virtual const WClass* getWClass() {assert(0); return NULL;};

  int getTypeId()            {return getWClass()->type_id;};
  const char* getTypeName()  {return getWClass()->type_name;};
  WCreator* getCreator()  {return getWClass()->creator;};
  WReplicator* getReplicator()  {return getWClass()->replicator;};

  // instances of general object handlers
  virtual boolean change() { return FALSE; }
  virtual void changePosition(float lasting) {}
  virtual void changePermanent(float lasting) {}
  virtual void updateTime(time_t sec, time_t usec, float *lasting) {}
  virtual boolean updateToNetwork(const Pos &oldpos) { return FALSE; }
  virtual void whenIntersect(WObject *pcur, WObject *pold) {}
  virtual boolean whenIntersectOut(WObject *pcur, WObject *pold) { return FALSE; }
  virtual void whenNoIntersect(WObject *pcur, WObject *pold) {}
  virtual void whenWallIntersect(WObject *pold, V3 *norm) {}
  virtual void render() {}
  virtual void click(V3 norm) {}
  virtual void quit() {}
};

typedef struct _GeneralInitList {
  char type_name[HNAME_LEN];	// class name
  int  type_id;			// type number
  void (*initfunc) (void);	// init function
} GeneralInitList;
extern GeneralInitList generalInitList[];

typedef struct _FuncList {
  void (*pf) (WObject *po, struct _Payload *pp);
} FuncList[PROPSNUMBER][OBJECTSNUMBER];
#define WO_PAYLOAD  (void (*)(WObject *, struct _Payload *))

typedef struct _GeneralMethodList {
  char type_name[HNAME_LEN];
  void (*method) (WObject *po, void *data, time_t sec, time_t usec);
} GeneralMethodList[METHODSNUMBER][OBJECTSNUMBER];
#define WO_ACTION (void (*)(WObject *, void *, time_t, time_t))
#define WO_HANDLER (void (*)(void *, time_t, time_t))


#endif /* WOBJECT_H */
