#ifndef WMGT_H
#define WMGT_H


#include "world.h"


/**********************/
/* External Variables */

extern int wmgtlockstate;
extern boolean thisWorldIsDead;
extern struct _ObjectList *stilllist, *mobilelist, *invisiblelist, *todeletelist;
extern FuncList getFuncList, setFuncList;
extern GeneralMethodList generalMethodList;
extern u_int8 propertiesnumber[];
extern float maxlasting[];


/************************/
/* module wmgt.c	*/

void testsolidobject(char *where, WObject *po);
void initializeObject(WObject *po, int type_id, int list_id);
const char * getObjectNameById(u_int8);
u_int8 getObjectIdNameByName(char *type_name);
void updateObjectNames(WObject *po);
void initializeNetObject(WObject *po, int oid, u_int8 props, u_int8 behave);
void setMethodHandler(int type_id, int action_id, void (*func)(void *, time_t, time_t), const char *action_name);
void setMethodFunc(int type_id, int action_id, void (*func)(WObject *po, void *, time_t, time_t), const char *action_name);
void objectToDelete(WObject *po);
void deleteObjects(void);

/************************/
/* module 3dw.c		*/

/* update object's Bounding Box */
void updateBB(WObject *po);

/* copy object position and Bounding Box */
void copyPosAndBB(WObject *psrc, Pos &newpos);
void copyPositionAndBB(WObject *psrc, WObject *pdst);

/* update object in the 3D */
void updateObjectIn3D(WObject *po);

/* update camera in the 3D */
void updateCameraFromObject(WObject *po);

/* put WObject pointer in a Solid */
void setObjectToSolid(WObject *po);

/* get WObject pointer from a Solid */
WObject* getObjectFromSolid(struct _ZVSolid *solid);

/************************/
/* module netw.c	*/

void updateReplica(WObject *po, const Pos &oldpos);

void setAllProperties(NetObject *pn, struct _Payload *pp);

struct _Payload;
void set_xy(WObject *po, struct _Payload *pp);
void set_z(WObject *po, struct _Payload *pp);
void set_az(WObject *po, struct _Payload *pp);
void set_ay(WObject *po, struct _Payload *pp);
void set_ax(WObject *po, struct _Payload *pp);
void set_hname(WObject *po, struct _Payload *pp);

void get_xy(WObject *po, struct _Payload *pp);
void get_z(WObject *po, struct _Payload *pp);
void get_az(WObject *po, struct _Payload *pp);
void get_ay(WObject *po, struct _Payload *pp);
void get_ax(WObject *po, struct _Payload *pp);
void get_hname(WObject *po, struct _Payload *pp);


#endif /* WMGT_H */
