#ifndef USER_H
#define USER_H

#include "config.h"
#include "keys.h"


#define USER_TYPE		1
#define USER_NAME		"Avatar"
#define	USER_INIT		userInitFuncList
#define USER_LASTING		0.015	// 15 ms
#define USER_PROPS		(USER_PROPCOLOR + 1) /* 20 */

#define USER_PROPHNAME		0			/*  0 */
#define USER_PROPMAPFRONT	1			/*  1 */
#define USER_PROPMAPBACK	2			/*  2 */

#define USER_PROPBEGINVAR	(USER_PROPMAPBACK  + 1)
#define USER_PROPXY		(USER_PROPBEGINVAR + 0)	/*  3 */
#define USER_PROPZ		(USER_PROPBEGINVAR + 1)	/*  4 */
#define USER_PROPAZ		(USER_PROPBEGINVAR + 2)	/*  5 */
#define USER_PROPAY		(USER_PROPBEGINVAR + 3)	/*  6 */
#define USER_PROPAX		(USER_PROPBEGINVAR + 4)	/*  7 */
#define USER_PROPMSG		(USER_PROPBEGINVAR + 5)	/*  8 */
#define USER_PROPENDVAR		USER_PROPMSG

#define USER_PROPMENSURATION	(USER_PROPENDVAR + 1)	/*  9 */
#define USER_PROPMAPLEFT	(USER_PROPENDVAR + 2)	/* 10 */
#define USER_PROPMAPRIGHT	(USER_PROPENDVAR + 3)	/* 11 */
#define USER_PROPVRE		(USER_PROPENDVAR + 4)	/* 12 */
#define USER_PROPWEB		(USER_PROPENDVAR + 5)	/* 13 */
#define USER_PROPSSRC		(USER_PROPENDVAR + 6)	/* 14 */
#define USER_PROPRTCPNAME	(USER_PROPENDVAR + 7)	/* 15 */
#define USER_PROPRTCPEMAIL	(USER_PROPENDVAR + 8)	/* 16 */
#define USER_PROPMODEL		(USER_PROPENDVAR + 9)	/* 17 */
#define USER_PROPFACE		(USER_PROPENDVAR + 10)	/* 18 */
#define USER_PROPCOLOR		(USER_PROPENDVAR + 11)	/* 19 */


#define USER_MENSURATIONLEN	64

#define USER_DEFAULTWIDTH	0.26	// width = 26 cm
#define USER_DEFAULTDEPTH	0.16	// depth = 16 cm
#define USER_DEFAULTHEIGHT	1.70	// height= 170 cm
#define USER_LSPEED		4.0	// linear speed: 4 m/s
#define USER_ASPEED		1.0	// angular speed
#define USER_EXTLSPEED		8.0
#define USER_EXTASPEED		2.0
#define USER_DELTAZ		0.02	// 2 cm
#define USER_GOTHROUGH		0.05	// 5 cm
#define USER_FOVY		26.0	// 26 deg
#define USER_NEAR		0.10	// 10cm orig=40cm
#define USER_FAR		300.0	// 300m
#define USER_DENSITY		1.0

/* actions */
#define BULLETUSER	0
#define DARTUSER	1
#define FOVYORIGINAL	2
#define FOVYLESS	3
#define FOVYGREATER	4
#define LSPEEDORIGINAL	5
#define LSPEEDLESS	6
#define LSPEEDGREATER	7
#define ASPEEDORIGINAL	8
#define ASPEEDLESS	9
#define ASPEEDGREATER	10
#define USERPAUSE	11
#define USERPAUSEON	12
#define USERPAUSEOFF	13
#define USERSETLSPEED	14
#define USERSETASPEED	15


class User: public WObject {
public:
  float lspeed;
  float aspeed;
  float width;
  float depth;
  float height;
  u_int32 ssrc;
  char  *mensuration;
  char  *urlfront;
  char  *urlback;
  char  *urlleft;
  char  *urlright;
  char  *vre;
  char  *host;
  char  *web;
  char  *model;
  char  *face;
  char  *color;
  char  *baps;
  char  *cname;
  char  *rtcpname;
  char  *email;
  char  *tool;
  char  *message;
  int   lastmess;
  boolean kpressed[MAXKEYS];	// is the key pressed ?
  time_t  kpstart_s[MAXKEYS];	// key press starting time (sec)
  time_t  kpstart_u[MAXKEYS];	// key press starting time (usec)
  time_t  kpdur_s[MAXKEYS];	// key press duration from starting time (sec)
  time_t  kpdur_u[MAXKEYS];	// key press duration from starting time (usec)
  u_int8 entry;
  u_int8 hit;
  u_int8 weight;
  /* Adding aura (=sphere) of user object */
  float aura_center[3]; // center of sphere
  float aura_radius;    // sphere's radius

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  /* constructors and destructor */
  User(const char *, const char *, const char *);
  User(u_int8 type_id, struct _NetObjectId noid, struct _Payload *pp);
  ~User();
  User() {};

  // factory methods
  static User * createLocal(const char *localusername,
                            const char *front, const char *back);
  static void updateTime2(WObject *pu, time_t sec, time_t usec, float *lasting);
  static WObject * replicator(u_int8 type_id,
                              struct _NetObjectId noid, Payload *pp);

  // instance methods
  virtual boolean change();
  virtual void changePosition(float lasting);
  virtual void changePermanent(float lasting);
  virtual void updateTime(time_t sec, time_t usec, float *last);
  virtual boolean updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void whenWallIntersect(WObject *pold, V3 *norm);

protected:
  virtual void allocLocal();
};

void USER_INIT(void);

struct Bullet;
struct Dart;
void bulletGetHit(Bullet *, struct _Payload *);
void dartGetHit(Dart *, struct _Payload *);


#endif /* USER_H */
