/**
* program	: glutmech V1.1
* author	: Simon Parkinson-Bates.
* E-mail	: sapb@yallara.cs.rmit.edu.au
* Copyright Simon Parkinson-Bates.
* "source if freely avaliable to anyone to copy as long as they
*  acknowledge me in their work."
*
* Funtional features 
* ------------------
* * online menu system avaliable by pressing left mouse button
* * online cascading help system avaliable, providing information on
*	the several  key strokes and what they do.
* * animation sequence coded which makes the mech walk through an
*	environment.  Shadows will soon be added to make it look
*	more realistic.
* * menu control to view mech in wireframe or sold mode.
* * various key strokes avaliable to control idependently the mechs
*	many joints.
* * various key strokes avaliable to view mech and environment from 
*	different angles
* * various key strokes avaliable to alter positioning of the single
*	light source.
*
* Program features
* ----------------
* * uses double buffering
* * uses display lists
* * uses glut to manage windows, callbacks, and online menu.
* * uses glpolygonfill() to maintain colors in wireframe and solid mode.
**/

#ifndef VRENGD

/* start of compilation conditions */
#define MECH_TORSO
#define MECH_HIP
#define MECH_SHOULDER
#define MECH_UPPER_ARM
#define MECH_LOWER_ARM
#define MECH_ROCKET_POD
#define MECH_UPPER_LEG
#define MECH_LOWER_LEG
#undef	MECH_VULCANO
/* end of compilation conditions */

#include <GL/gl.h>
#include <GL/glu.h>

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"
#include "list.h"
#include "mech.h"

#include "zv.h"		/* parseGeometry */


/* start of display list definitions */
#define SOLID_MECH_TORSO       	1
#define SOLID_MECH_HIP          2
#define SOLID_MECH_SHOULDER     3
#define SOLID_MECH_UPPER_ARM    4
#define SOLID_MECH_FOREARM	5
#define SOLID_MECH_UPPER_LEG   	6
#define SOLID_MECH_FOOT        	7
#define SOLID_MECH_ROCKET      	8
#define SOLID_MECH_VULCAN	9
/* end of display list definitions */

/* start of motion rate definitions */
#define ANKLE_RATE	3
#define HEEL_RATE	3
#define ROTATE_RATE	10
#define TILT_RATE	10
#define ELBOW_RATE	2
#define SHOULDER_RATE	5
#define LAT_RATE	5
#define CANNON_RATE	40
#define UPPER_LEG_RATE	3
#define UPPER_LEG_RATE_GROIN 10
#define LIGHT_TURN_RATE	10
#define VIEW_TURN_RATE	10
/* end of motion rate definitions */


const WClass Mech::wclass(MECH_TYPE, "Mech", Mech::creator);


/* start of motion  variables */
static char leg = 0;
static int shoulder1 = 0, shoulder2 = 0, shoulder3 = 0, shoulder4 = 0;
static int lat1 = 20, lat2 = 20;
static int elbow1 = 0, elbow2 = 0;
static int pivot = 0;
static int tilt = 10;
static int ankle1 = 0, ankle2 = 0;
static int heel1 = 0, heel2 = 0;
static int hip11 = 0, hip12 = 10, hip21 = 0, hip22 = 10;
static int fire = 0;
static int turn = 0, turn1 = 0;
static int lightturn = 0, lightturn1 = 0;
static float elevation = 0.0, distance = 0.0, frame = 3.0;
/* end of motion variables */

/* start of material definitions */
static GLfloat mat_specular[] = {0.628281, 0.555802, 0.366065, 1.0};
static GLfloat mat_ambient[] = {0.24725, 0.1995, 0.0745, 1.0};
static GLfloat mat_diffuse[] = {0.75164, 0.60648, 0.22648, 1.0};
static GLfloat mat_shininess[] = {128.0 * 0.4};
static GLfloat mat_specular2[] = {0.508273, 0.508273, 0.508373, 1.0};
static GLfloat mat_ambient2[] = {0.19225, 0.19225, 0.19225, 1.0};
static GLfloat mat_diffuse2[] = {0.50754, 0.50754, 0.50754, 1.0};
static GLfloat mat_shininess2[] = {128.0 * 0.6};
#if !defined(WITH_TINYGL)
static GLfloat mat_specular3[] = {0.296648, 0.296648, 0.296648, 1.0};
static GLfloat mat_ambient3[] = {0.25, 0.20725, 0.20725, 1.0};
static GLfloat mat_diffuse3[] = {1, 0.829, 0.829, 1.0};
static GLfloat mat_shininess3[] = {128.0 * 0.088};
static GLfloat mat_specular4[] = {0.633, 0.727811, 0.633, 1.0};
static GLfloat mat_ambient4[] = {0.0215, 0.1745, 0.0215, 1.0};
static GLfloat mat_diffuse4[] = {0.07568, 0.61424, 0.07568, 1.0};
static GLfloat mat_shininess4[] = {128 * 0.6};
#endif
/* end of material definitions */

/* start of the body motion functions */
void Heel1Add(void) { heel1 = (heel1 + HEEL_RATE) % 360; }
void Heel1Subtract(void) { heel1 = (heel1 - HEEL_RATE) % 360; }
void Heel2Add(void) { heel2 = (heel2 + HEEL_RATE) % 360; }
void Heel2Subtract(void) { heel2 = (heel2 - HEEL_RATE) % 360; }
void Ankle1Add(void) { ankle1 = (ankle1 + ANKLE_RATE) % 360; }
void Ankle1Subtract(void) { ankle1 = (ankle1 - ANKLE_RATE) % 360; }
void Ankle2Add(void) { ankle2 = (ankle2 + ANKLE_RATE) % 360; }
void Ankle2Subtract(void) { ankle2 = (ankle2 - ANKLE_RATE) % 360; }
void RotateAdd(void) { pivot = (pivot + ROTATE_RATE) % 360; }
void RotateSubtract(void) { pivot = (pivot - ROTATE_RATE) % 360; }
void MechTiltSubtract(void) { tilt = (tilt - TILT_RATE) % 360; }
void MechTiltAdd(void) { tilt = (tilt + TILT_RATE) % 360; }
void elbow1Add(void) { elbow1 = (elbow1 + ELBOW_RATE) % 360; }
void elbow1Subtract(void) { elbow1 = (elbow1 - ELBOW_RATE) % 360; }
void elbow2Add(void) { elbow2 = (elbow2 + ELBOW_RATE) % 360; }
void elbow2Subtract(void) { elbow2 = (elbow2 - ELBOW_RATE) % 360; }
void shoulder1Add(void) { shoulder1 = (shoulder1 + SHOULDER_RATE) % 360; }
void shoulder1Subtract(void) { shoulder1 = (shoulder1 - SHOULDER_RATE) % 360; }
void shoulder2Add(void) { shoulder2 = (shoulder2 + SHOULDER_RATE) % 360; }
void shoulder2Subtract(void) { shoulder2 = (shoulder2 - SHOULDER_RATE) % 360; }
void shoulder3Add(void) { shoulder3 = (shoulder3 + SHOULDER_RATE) % 360; }
void shoulder3Subtract(void) { shoulder3 = (shoulder3 - SHOULDER_RATE) % 360; }
void shoulder4Add(void) { shoulder4 = (shoulder4 + SHOULDER_RATE) % 360; }
void shoulder4Subtract(void) { shoulder4 = (shoulder4 - SHOULDER_RATE) % 360; }
void lat1Raise(void) { lat1 = (lat1 + LAT_RATE) % 360; }
void lat1Lower(void) { lat1 = (lat1 - LAT_RATE) % 360; }
void lat2Raise(void) { lat2 = (lat2 + LAT_RATE) % 360; }
void lat2Lower(void) { lat2 = (lat2 - LAT_RATE) % 360; }
void FireCannon(void) { fire = (fire + CANNON_RATE) % 360; }
void RaiseLeg1Forward(void) { hip11 = (hip11 + UPPER_LEG_RATE) % 360; }
void LowerLeg1Backwards(void) { hip11 = (hip11 - UPPER_LEG_RATE) % 360; }
void RaiseLeg1Outwards(void) { hip12 = (hip12 + UPPER_LEG_RATE_GROIN) % 360; }
void LowerLeg1Inwards(void) { hip12 = (hip12 - UPPER_LEG_RATE_GROIN) % 360; }
void RaiseLeg2Forward(void) { hip21 = (hip21 + UPPER_LEG_RATE) % 360; }
void LowerLeg2Backwards(void) { hip21 = (hip21 - UPPER_LEG_RATE) % 360; }
void RaiseLeg2Outwards(void) { hip22 = (hip22 + UPPER_LEG_RATE_GROIN) % 360; }
void LowerLeg2Inwards(void) { hip22 = (hip22 - UPPER_LEG_RATE_GROIN) % 360; }
/* end of body motion functions */

/* start of light source position functions */
void TurnRight(void) { turn = (turn - VIEW_TURN_RATE) % 360; }
void TurnLeft(void) { turn = (turn + VIEW_TURN_RATE) % 360; }
void TurnForwards(void) { turn1 = (turn1 - VIEW_TURN_RATE) % 360; }
void TurnBackwards(void) { turn1 = (turn1 + VIEW_TURN_RATE) % 360; }
void LightTurnRight(void) { lightturn = (lightturn + LIGHT_TURN_RATE) % 360; }
void LightTurnLeft(void) { lightturn = (lightturn - LIGHT_TURN_RATE) % 360; }
void LightForwards(void) { lightturn1 = (lightturn1 + LIGHT_TURN_RATE) % 360; }
void LightBackwards(void) { lightturn1 = (lightturn1 - LIGHT_TURN_RATE) % 360; }
/* end of light source position functions */


/* start of geometric shape functions */
static
void Box(float width, float height, float depth)
{
  char i, j = 0;
  float x = width / 2.0, y = height / 2.0, z = depth / 2.0;

  for (i = 0; i < 4; i++) {
    glRotatef(90.0, 0.0, 0.0, 1.0);
    if (j) {
      glBegin(GL_QUADS);
      glNormal3f(-1.0, 0.0, 0.0);
      glVertex3f(-x, y, z);
      glVertex3f(-x, -y, z);
      glVertex3f(-x, -y, -z);
      glVertex3f(-x, y, -z);
      glEnd();
      glBegin(GL_TRIANGLES);
      glNormal3f(0.0, 0.0, 1.0);
      glVertex3f(0.0, 0.0, z);
      glVertex3f(-x, y, z);
      glVertex3f(-x, -y, z);
      glNormal3f(0.0, 0.0, -1.0);
      glVertex3f(0.0, 0.0, -z);
      glVertex3f(-x, -y, -z);
      glVertex3f(-x, y, -z);
      glEnd();
      j = 0;
    } else {
      glBegin(GL_QUADS);
      glNormal3f(-1.0, 0.0, 0.0);
      glVertex3f(-y, x, z);
      glVertex3f(-y, -x, z);
      glVertex3f(-y, -x, -z);
      glVertex3f(-y, x, -z);
      glEnd();
      glBegin(GL_TRIANGLES);
      glNormal3f(0.0, 0.0, 1.0);
      glVertex3f(0.0, 0.0, z);
      glVertex3f(-y, x, z);
      glVertex3f(-y, -x, z);
      glNormal3f(0.0, 0.0, -1.0);
      glVertex3f(0.0, 0.0, -z);
      glVertex3f(-y, -x, -z);
      glVertex3f(-y, x, -z);
      glEnd();
      j = 1;
    }
  }
}

static
void Octagon(float side, float height)
{
  char j;
  float x = sin(0.785398163) * side, y = side / 2.0, z = height / 2.0, c;

  c = x + y;
  for (j = 0; j < 8; j++) {
    glTranslatef(-c, 0.0, 0.0);
    glBegin(GL_QUADS);
    glNormal3f(-1.0, 0.0, 0.0);
    glVertex3f(0.0, -y, z);
    glVertex3f(0.0, y, z);
    glVertex3f(0.0, y, -z);
    glVertex3f(0.0, -y, -z);
    glEnd();
    glTranslatef(c, 0.0, 0.0);
    glBegin(GL_TRIANGLES);
    glNormal3f(0.0, 0.0, 1.0);
    glVertex3f(0.0, 0.0, z);
    glVertex3f(-c, -y, z);
    glVertex3f(-c, y, z);
    glNormal3f(0.0, 0.0, -1.0);
    glVertex3f(0.0, 0.0, -z);
    glVertex3f(-c, y, -z);
    glVertex3f(-c, -y, -z);
    glEnd();
    glRotatef(45.0, 0.0, 0.0, 1.0);
  }
}
/* end of geometric shape functions */

static
void SetMaterial(GLfloat spec[], GLfloat amb[], GLfloat diff[], GLfloat shin[])
{
  glMaterialfv(GL_FRONT, GL_SPECULAR, spec);
  glMaterialfv(GL_FRONT, GL_SHININESS, shin);
  glMaterialfv(GL_FRONT, GL_AMBIENT, amb);
  glMaterialfv(GL_FRONT, GL_DIFFUSE, diff);
}

static
void MechTorso(void)
{
  glNewList(SOLID_MECH_TORSO, GL_COMPILE);
  SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
  Box(1.0, 1.0, 3.0);
  glTranslatef(0.75, 0.0, 0.0);
  SetMaterial(mat_specular2, mat_ambient2, mat_diffuse2, mat_shininess2);
  Box(0.5, 0.6, 2.0);
  glTranslatef(-1.5, 0.0, 0.0);
  Box(0.5, 0.6, 2.0);
  glTranslatef(0.75, 0.0, 0.0);
  glEndList();
}

static
void MechHip(void)
{
#if !defined(WITH_TINYGL)
  int i;
  GLUquadricObj *hip[2];

  glNewList(SOLID_MECH_HIP, GL_COMPILE);
  SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
  Octagon(0.7, 0.5);
  for (i = 0; i < 2; i++) {
    if (i)
      glScalef(-1.0, 1.0, 1.0);
    glTranslatef(1.0, 0.0, 0.0);
    hip[i] = gluNewQuadric();
    SetMaterial(mat_specular2, mat_ambient2, mat_diffuse2, mat_shininess2);
    gluSphere(hip[0], 0.2, 16, 16);
    glTranslatef(-1.0, 0.0, 0.0);
  }
  glScalef(-1.0, 1.0, 1.0);
  glEndList();
#endif
}

static
void Shoulder(void)
{
#if !defined(WITH_TINYGL)
  GLUquadricObj *deltoid = gluNewQuadric();

  glNewList(SOLID_MECH_SHOULDER, GL_COMPILE);
  SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
  Box(1.0, 0.5, 0.5);
  glTranslatef(0.9, 0.0, 0.0);
  SetMaterial(mat_specular2, mat_ambient2, mat_diffuse2, mat_shininess2);
  gluSphere(deltoid, 0.6, 16, 16);
  glTranslatef(-0.9, 0.0, 0.0);
  glEndList();
#endif
}

static
void UpperArm(void)
{
#if !defined(WITH_TINYGL)
  GLUquadricObj *upper = gluNewQuadric();
  GLUquadricObj *joint[2];
  GLUquadricObj *joint1[2];
  int i;

  glNewList(SOLID_MECH_UPPER_ARM, GL_COMPILE);
  SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
  Box(1.0, 2.0, 1.0);
  glTranslatef(0.0, -0.95, 0.0);
  glRotatef(90.0, 1.0, 0.0, 0.0);
  SetMaterial(mat_specular2, mat_ambient2, mat_diffuse2, mat_shininess2);
  gluCylinder(upper, 0.4, 0.4, 1.5, 16, 10);
  SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
  glRotatef(-90.0, 1.0, 0.0, 0.0);
  glTranslatef(-0.4, -1.85, 0.0);
  glRotatef(90.0, 0.0, 1.0, 0.0);
  for (i = 0; i < 2; i++) {
    joint[i] = gluNewQuadric();
    if (i)
      gluCylinder(joint[i], 0.5, 0.5, 0.8, 16, 10);
    else
      gluCylinder(joint[i], 0.2, 0.2, 0.8, 16, 10);
  }
  for (i = 0; i < 2; i++) {
    if (i)
      glScalef(-1.0, 1.0, 1.0);
    joint1[i] = gluNewQuadric();
    if (i)
      glTranslatef(0.0, 0.0, 0.8);
    gluDisk(joint1[i], 0.2, 0.5, 16, 10);
    if (i)
      glTranslatef(0.0, 0.0, -0.8);
  }
  glScalef(-1.0, 1.0, 1.0);
  glRotatef(-90.0, 0.0, 1.0, 0.0);
  glTranslatef(0.4, 2.9, 0.0);
  glEndList();
#endif
}

static
void VulcanGun(void)
{
#if !defined(WITH_TINYGL)
#ifdef MECH_VULCANO
  int i;
  GLUquadricObj *Barrel[5];
  GLUquadricObj *BarrelFace[5];
  GLUquadricObj *Barrel2[5];
  GLUquadricObj *Barrel3[5];
  GLUquadricObj *BarrelFace2[5];
  GLUquadricObj *Mount = gluNewQuadric();
  GLUquadricObj *Mount_face = gluNewQuadric();

  glNewList(SOLID_MECH_VULCAN, GL_COMPILE);

  SetMaterial(mat_specular2, mat_ambient2, mat_diffuse2, mat_shininess2);
  gluCylinder(Mount, 0.5, 0.5, 0.5, 16, 10);
  glTranslatef(0.0, 0.0, 0.5);
  gluDisk(Mount_face, 0.0, 0.5, 16, 10);

  for (i = 0; i < 5; i++) {
    Barrel[i] = gluNewQuadric();
    BarrelFace[i] = gluNewQuadric();
    BarrelFace2[i] = gluNewQuadric();
    Barrel2[i] = gluNewQuadric();
    Barrel3[i] = gluNewQuadric();
    glRotatef(72.0, 0.0, 0.0, 1.0);
    glTranslatef(0.0, 0.3, 0.0);
    gluCylinder(Barrel[i], 0.15, 0.15, 2.0, 16, 10);
    gluCylinder(Barrel3[i], 0.06, 0.06, 2.0, 16, 10);
    glTranslatef(0.0, 0.0, 2.0);
    gluDisk(BarrelFace[i], 0.1, 0.15, 16, 10);
    gluCylinder(Barrel2[i], 0.1, 0.1, 0.1, 16, 5);
    glTranslatef(0.0, 0.0, 0.1);
    gluDisk(BarrelFace2[i], 0.06, 0.1, 16, 5);
    glTranslatef(0.0, -0.3, -2.1);
  }
  glEndList();
#endif
#endif
}

static
void ForeArm(void)
{
  char i;

  glNewList(SOLID_MECH_FOREARM, GL_COMPILE);
  SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
  for (i = 0; i < 5; i++) {
    glTranslatef(0.0, -0.1, -0.15);
    Box(0.6, 0.8, 0.2);
    glTranslatef(0.0, 0.1, -0.15);
    Box(0.4, 0.6, 0.1);
  }
  glTranslatef(0.0, 0.0, 2.45);
  Box(1.0, 1.0, 2.0);
  glTranslatef(0.0, 0.0, -1.0);
  glEndList();
}

static
void UpperLeg(void)
{
#if !defined(WITH_TINYGL)
  int i;
  GLUquadricObj *Hamstring = gluNewQuadric();
  GLUquadricObj *Knee = gluNewQuadric();
  GLUquadricObj *joint[2];

  glNewList(SOLID_MECH_UPPER_LEG, GL_COMPILE);
  SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
  glTranslatef(0.0, -1.0, 0.0);
  Box(0.4, 1.0, 0.7);
  glTranslatef(0.0, -0.65, 0.0);
  for (i = 0; i < 5; i++) {
    Box(1.2, 0.3, 1.2);
    glTranslatef(0.0, -0.2, 0.0);
    Box(1.0, 0.1, 1.0);
    glTranslatef(0.0, -0.2, 0.0);
  }
  glTranslatef(0.0, -0.15, -0.4);
  Box(2.0, 0.5, 2.0);
  glTranslatef(0.0, -0.3, -0.2);
  glRotatef(90.0, 1.0, 0.0, 0.0);
  SetMaterial(mat_specular2, mat_ambient2, mat_diffuse2, mat_shininess2);
  gluCylinder(Hamstring, 0.6, 0.6, 3.0, 16, 10);
  SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
  glRotatef(-90.0, 1.0, 0.0, 0.0);
  glTranslatef(0.0, -1.5, 1.0);
  Box(1.5, 3.0, 0.5);
  glTranslatef(0.0, -1.75, -0.8);
  Box(2.0, 0.5, 2.0);
  glTranslatef(0.0, -0.9, -0.85);
  SetMaterial(mat_specular2, mat_ambient2, mat_diffuse2, mat_shininess2);
  gluCylinder(Knee, 0.8, 0.8, 1.8, 16, 10);
  for (i = 0; i < 2; i++) {
    if (i)
      glScalef(-1.0, 1.0, 1.0);
    joint[i] = gluNewQuadric();
    if (i)
      glTranslatef(0.0, 0.0, 1.8);
    gluDisk(joint[i], 0.0, 0.8, 16, 10);
    if (i)
      glTranslatef(0.0, 0.0, -1.8);
  }
  glScalef(-1.0, 1.0, 1.0);
  glEndList();
#endif
}

static
void Foot(void)
{
  glNewList(SOLID_MECH_FOOT, GL_COMPILE);
  SetMaterial(mat_specular2, mat_ambient2, mat_diffuse2, mat_shininess2);
  glRotatef(90.0, 1.0, 0.0, 0.0);
  Octagon(1.5, 0.6);
  glRotatef(-90.0, 1.0, 0.0, 0.0);
  glEndList();
}

static
void LowerLeg(void)
{
#if !defined(WITH_TINYGL)
  float k, l;
  GLUquadricObj *ankle = gluNewQuadric();
  GLUquadricObj *ankle_face[2], *joints;

  SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
  for (k = 0.0; k < 2.0; k++) {
    for (l = 0.0; l < 2.0; l++) {
      glPushMatrix();
      glTranslatef(k, 0.0, l);
      SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
      Box(1.0, 0.5, 1.0);
      glTranslatef(0.0, -0.45, 0.0);
      SetMaterial(mat_specular2, mat_ambient2, mat_diffuse2, mat_shininess2);
      joints = gluNewQuadric();
      gluSphere(joints, 0.2, 16, 16); 
      free(joints);
      if (leg)
        glRotatef((GLfloat) heel1, 1.0, 0.0, 0.0);
      else
        glRotatef((GLfloat) heel2, 1.0, 0.0, 0.0);
      /* glTranslatef(0.0, -0.2, 0.0); */
      glTranslatef(0.0, -1.7, 0.0);
      SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
      Box(0.25, 3.0, 0.25);
      glTranslatef(0.0, -1.7, 0.0);
      SetMaterial(mat_specular2, mat_ambient2, mat_diffuse2, mat_shininess2);
      joints = gluNewQuadric();
      gluSphere(joints, 0.2, 16, 16);
      if (leg)
        glRotatef((GLfloat) - heel1, 1.0, 0.0, 0.0);
      else
        glRotatef((GLfloat) - heel2, 1.0, 0.0, 0.0);
      glTranslatef(0.0, -0.45, 0.0);
      SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
      Box(1.0, 0.5, 1.0);
      if (!k && !l) {
        int j;

        glTranslatef(-0.4, -0.8, 0.5);
        if (leg)
          glRotatef((GLfloat) ankle1, 1.0, 0.0, 0.0);
        else
          glRotatef((GLfloat) ankle2, 1.0, 0.0, 0.0);
        glRotatef(90.0, 0.0, 1.0, 0.0);
        gluCylinder(ankle, 0.8, 0.8, 1.8, 16, 10);
        for (j = 0; j < 2; j++) {
          ankle_face[j] = gluNewQuadric();
          if (j) {
            glScalef(-1.0, 1.0, 1.0);
            glTranslatef(0.0, 0.0, 1.8);
          }
          gluDisk(ankle_face[j], 0.0, 0.8, 16, 10);
          if (j)
            glTranslatef(0.0, 0.0, -1.8);
        }
        glScalef(-1.0, 1.0, 1.0);
        glRotatef(-90.0, 0.0, 1.0, 0.0);
        glTranslatef(0.95, -0.8, 0.0);
        glCallList(SOLID_MECH_FOOT);
      }
      glPopMatrix();
    }
  }
#endif
}

static
void RocketPod(void)
{
#if !defined(WITH_TINYGL)
  int i, j, k = 0;
  GLUquadricObj *rocket[6];
  GLUquadricObj *rocket1[6];

  glNewList(SOLID_MECH_ROCKET, GL_COMPILE);
  SetMaterial(mat_specular2, mat_ambient2, mat_diffuse2, mat_shininess2);
  glScalef(0.4, 0.4, 0.4);
  /* Neck1 */
  glRotatef(45.0, 0.0, 0.0, 1.0);
  glTranslatef(1.0, 0.0, 0.0);
  Box(2.0, 0.5, 3.0);
  /* Neck2 */
  glTranslatef(1.0, 0.0, 0.0);
  glRotatef(45.0, 0.0, 0.0, 1.0);
  glTranslatef(0.5, 0.0, 0.0);
  Box(1.2, 0.5, 3.0);
  /* Head */
  glTranslatef(2.1, 0.0, 0.0);
  glRotatef(-90.0, 0.0, 0.0, 1.0);
  SetMaterial(mat_specular, mat_ambient, mat_diffuse, mat_shininess);
  Box(2.0, 3.0, 4.0);
  glTranslatef(-0.5, -1.0, 1.3);
  /* Eyes */
  for (i = 0; i < 2; i++) {
    /* DIST for (j = 0; j < 3; j++) { */
    for (j = 2; j < 3; j++) {
      rocket[k] = gluNewQuadric();
      rocket1[k] = gluNewQuadric();
      glTranslatef(i, j, 0.6);
      SetMaterial(mat_specular3, mat_ambient3, mat_diffuse3, mat_shininess3);
      gluCylinder(rocket[k], 0.4, 0.4, 0.3, 16, 10);
      glTranslatef(0.0, 0.0, 0.3);
      SetMaterial(mat_specular4, mat_ambient4, mat_diffuse4, mat_shininess4);
      gluCylinder(rocket1[k], 0.4, 0.0, 0.5, 16, 10);
      k++;
      glTranslatef(-i, -j, -0.9);
    }
  }
  glEndList();
#endif
}

static
void DrawMech(void)
{
  int i, j;

  glScalef(0.5, 0.5, 0.5);
  glPushMatrix();
  glTranslatef(0.0, -0.75, 0.0);
  glRotatef((GLfloat) tilt, 1.0, 0.0, 0.0);
  glRotatef(90.0, 1.0, 0.0, 0.0);
  glCallList(SOLID_MECH_HIP);
  glRotatef(-90.0, 1.0, 0.0, 0.0);

  glTranslatef(0.0, 0.75, 0.0);
  glPushMatrix();
  glRotatef((GLfloat) pivot, 0.0, 1.0, 0.0);
  glPushMatrix();
  glCallList(SOLID_MECH_TORSO);
  glPopMatrix();
  glPushMatrix();
  glTranslatef(0.5, 0.5, 0.0);
#ifdef MECH_ROCKET_POD
  glCallList(SOLID_MECH_ROCKET);
#endif
  glPopMatrix();
  for (i = 0; i < 2; i++) {
    glPushMatrix();
    if (i)
      glScalef(-1.0, 1.0, 1.0);
    glTranslatef(1.5, 0.0, 0.0);
    glCallList(SOLID_MECH_SHOULDER);
    glTranslatef(0.9, 0.0, 0.0);
    if (i) {
      glRotatef((GLfloat) lat1, 0.0, 0.0, 1.0);
      glRotatef((GLfloat) shoulder1, 1.0, 0.0, 0.0);
      glRotatef((GLfloat) shoulder3, 0.0, 1.0, 0.0);
    } else {
      glRotatef((GLfloat) lat2, 0.0, 0.0, 1.0);
      glRotatef((GLfloat) shoulder2, 1.0, 0.0, 0.0);
      glRotatef((GLfloat) shoulder4, 0.0, 1.0, 0.0);
    }
    glTranslatef(0.0, -1.4, 0.0);
    glCallList(SOLID_MECH_UPPER_ARM);
    glTranslatef(0.0, -2.9, 0.0);
    if (i)
      glRotatef((GLfloat) elbow1, 1.0, 0.0, 0.0);
    else
      glRotatef((GLfloat) elbow2, 1.0, 0.0, 0.0);
    glTranslatef(0.0, -0.9, -0.2);
    glCallList(SOLID_MECH_FOREARM);
    glPushMatrix();
    glTranslatef(0.0, 0.0, 2.0);
    glRotatef((GLfloat) fire, 0.0, 0.0, 1.0);
#ifdef MECH_VULCANO
    glCallList(SOLID_MECH_VULCAN);
#endif
    glPopMatrix();
    glPopMatrix();
  }
  glPopMatrix();
  glPopMatrix();

  for (j = 0; j < 2; j++) {
    glPushMatrix();
    if (j) {
      glScalef(-0.5, 0.5, 0.5);
      leg = 1;
    } else {
      glScalef(0.5, 0.5, 0.5);
      leg = 0;
    }
    glTranslatef(2.0, -1.5, 0.0);
    if (j) {
      glRotatef((GLfloat) hip11, 1.0, 0.0, 0.0);
      glRotatef((GLfloat) hip12, 0.0, 0.0, 1.0);
    } else {
      glRotatef((GLfloat) hip21, 1.0, 0.0, 0.0);
      glRotatef((GLfloat) hip22, 0.0, 0.0, 1.0);
    }
    glTranslatef(0.0, 0.3, 0.0);
    glPushMatrix();
    glCallList(SOLID_MECH_UPPER_LEG);
    glPopMatrix();
    glTranslatef(0.0, -8.3, -0.4);
    if (j)
      glRotatef((GLfloat) - hip12, 0.0, 0.0, 1.0);
    else
      glRotatef((GLfloat) - hip22, 0.0, 0.0, 1.0);
    glTranslatef(-0.5, -0.85, -0.5);
    LowerLeg();
    glPopMatrix();
  }
}

static
void meshInit(void)
{
  SetMaterial(mat_specular2, mat_ambient2, mat_diffuse2, mat_shininess2);
  MechTorso();
  MechHip();
  Shoulder();
  RocketPod();
  UpperArm();
  ForeArm();
  UpperLeg();
  Foot();
  VulcanGun();
}

/* system of equations handling permanent motion */
void Mech::changePermanent(float lasting)
{
  float angle;
  static int step;

  if (!anim)
    return ;

  if (step == 0 || step == 2) {
    /* for(frame=3.0; frame<=21.0; frame=frame+3.0){ */
    if (frame >= 0.0 && frame <= 21.0) {
      if (frame == 0.0)
        frame = 3.0;
      angle = (180 / M_PI) * (acos(((cos((M_PI / 180) * frame) * 2.043) + 1.1625) / 3.2059));
      if (frame > 0)
        elevation = -(3.2055 - (cos((M_PI / 180) * angle) * 3.2055));
      else
        elevation = 0.0;

      if (step == 0) {
        hip11 = (int) -(frame * 1.7);
        if (1.7 * frame > 15)
          heel1 = (int) (frame * 1.7);
        heel2 = 0;
        ankle1 = (int) (frame * 1.7);
        if (frame > 0)
          hip21 = (int) angle;
        else
          hip21 = 0;
        ankle2 = -hip21;
        shoulder1 = (int) (frame * 1.5);
        shoulder2 = (int) -(frame * 1.5);
        elbow1 = (int) frame;
        elbow2 = (int) -frame;
      } else {
        hip21 = (int) -(frame * 1.7);
        if (1.7 * frame > 15)
          heel2 = (int) (frame * 1.7);
        heel1 = 0;
        ankle2 = (int) (frame * 1.7);
        if (frame > 0)
          hip11 = (int) angle;
        else
          hip11 = 0;
        ankle1 = -hip11;
        shoulder1 = (int) -(frame * 1.5);
        shoulder2 = (int) (frame * 1.5);
        elbow1 = (int) -frame;
        elbow2 = (int) frame;
      }
      if (frame == 21)
        step++;
      if (frame < 21)
        frame = frame + 3.0;
    }
  }
  if (step == 1 || step == 3) {
    /* for(x=21.0; x>=0.0; x=x-3.0){ */
    if (frame <= 21.0 && frame >= 0.0) {
      angle = (180 / M_PI) * (acos(((cos((M_PI / 180) * frame) * 2.043) + 1.1625) / 3.2029));
      if (frame > 0)
        elevation = -(3.2055 - (cos((M_PI / 180) * angle) * 3.2055));
      else
        elevation = 0.0;
      if (step == 1) {
        elbow2 = hip11 = (int) -frame;
        elbow1 = heel1 = (int) frame;
        heel2 = 15;
        ankle1 = (int) frame;
        if (frame > 0)
          hip21 = (int) angle;
        else
          hip21 = 0;
        ankle2 = -hip21;
        shoulder1 = (int) (1.5 * frame);
        shoulder2 = (int) -(frame * 1.5);
      } else {
        elbow1 = hip21 = (int) -frame;
        elbow2 = heel2 = (int) frame;
        heel1 = 15;
        ankle2 = (int) frame;
        if (frame > 0)
          hip11 = (int) angle;
        else
          hip11 = 0;
        ankle1 = -hip11;
        shoulder1 = (int) -(frame * 1.5);
        shoulder2 = (int) (frame * 1.5);
      }
      if (frame == 0.0)
        step++;
      if (frame > 0)
        frame = frame - 3.0;
    }
  }
  if (step == 4)
    step = 0;
  distance += 0.1678;
}

/* create from a fileline */
void Mech::creator(char *l)
{
  new Mech(l);
}

Mech::Mech(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  if (l) {
    anim = atoi(l);
    l = strtok(NULL, SEP);
  }
  if (l)
    walk = atoi(l);

  char geom[80];
  sprintf(geom,"bbox,size=%.2f,%.2f,%.2f", 0.5, 0.5, 1.0);
  soh = parseGeometry(geom);

  nature.movable = VR_NO_ELEM_MOVE;
  nature.renderable = VR_SPECIAL_RENDER;
  nature.collision = COL_NEVER;
  initializeObject(this, MECH_TYPE, VR_MOBILE);

  rotz = (float) RADIAN2DEGREE(this->pos.az);
  roty = (float) RADIAN2DEGREE(this->pos.ax);
  rotx = (float) 90.0;
  move.perm_sec = 1;
  meshInit();
}

void Mech::render()
{
  float dx, dz;
  static       float mech_radian  = 3 * M_PI/2; /* radian */
  static const float mech_step   = 72; /* steps per tours */
  static const float mech_radius = 7.0; /* space unit */

  /* DIST glTranslatef(0.0, elevation, 0.0); */
  glPushMatrix();
  glTranslatef(pos.x, pos.y, pos.z);
  glScalef(0.5, 0.5, 0.5);
  glRotatef(rotx, 1, 0, 0);
  glRotatef(roty, 0, 1, 0);
  glRotatef(rotz, 0, 0, 1);

  if (walk) {
    mech_radian -= M_2PI / mech_step;
    if (mech_radian <= 0.0)
      mech_radian = M_2PI;
    dx =  mech_radius * cos(mech_radian);
    dz = -mech_radius * sin(mech_radian);
    glTranslatef(dx, 0, dz);
    glRotatef((float) RADIAN2DEGREE(mech_radian), 0, 1, 0);
  }
  DrawMech();
  glPopMatrix();
}

void mechInitFuncList(void) { }

#endif /* !VRENGD */

