#ifndef LIST_H
#define LIST_H


typedef struct _ObjectList {
  WObject *pobject;
  struct _ObjectList *next;
} ObjectList;


void clearLists(void);

/* ajout d'un pointeur vers un objet dans une liste */
ObjectList * addObjectToList(WObject *, ObjectList *);
ObjectList * addObjectToListOnce(WObject *, ObjectList *, int);

/* suppression d'un pointeur vers un objet dans une liste */
ObjectList * deleteObjectFromList(WObject *, ObjectList *);

/* desalloue une liste d'objet */
void freeObjectList(ObjectList *);

/* concatenation de liste de pointeurs sur objet */
ObjectList * addObjectList(ObjectList *, ObjectList *);

/* concatenation (avec test de "ispointed" et objet) de liste
 * de pointeurs sur objet */
ObjectList * addObjectListToList(ObjectList *, WObject *, ObjectList *);

/* mise a zero des flags "ispointed" de tous les objets * d'un liste */
void clearIspointedFlag(ObjectList *);

/* return list of pointers on objects touching grid cell where is the object */
ObjectList * getVicinityObjectList(WObject *po, const Pos &oldpos);

/* returns list of pointers on objects with the given type id in the mobile list */
ObjectList * getObjectsWithType(int);
/* returns the object iditified by tpe and id from the mobile list */
WObject * findObjectInMobile(u_int8 type_id, u_int32 src_id, u_int16 port_id, u_int16 obj_id);

#endif /* LIST_H */
