#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "list.h"
#include "grid.h"


void clearLists(void)
{
  stilllist = NULL;
  mobilelist = NULL;
  invisiblelist = NULL;
  todeletelist = NULL;
}

// Add a pointer to an object in a list
ObjectList * addObjectToList(WObject *po, ObjectList *list)
{
  if (!po) {
    warning("addObjectToList: po NULL");
    return NULL;
  }

  ObjectList *newlist = NULL;

  if ((newlist = (ObjectList *) calloc(1,sizeof(struct _ObjectList))) == NULL) {
    warning("addObjectToList: can't alloc newlist");
    return NULL;
  }

  newlist->pobject = po;
  newlist->next = list;
  return newlist;
}

// Adds a pointer to a list if it's not already there
ObjectList * addObjectToListOnce(WObject *po, ObjectList *list, int id)
{
  if (!po) {
    warning("addObjectToListOnce: po NULL");
    return NULL;
  }  

  ObjectList *cursor = list;
  while (cursor != NULL) {
    if (cursor->pobject == po) {
      if (id == 1)
        trace(DBG_FORCE, "addObjectToListOnce: duplicate (%p %d)", po, po->noh.type);
      else
        trace(DBG_FORCE, "addObjectToListOnce%d: duplicate (%p %d)", id, po, po->noh.type);
      return list;
    }
    cursor = cursor->next;
  }
  return addObjectToList(po, list);
}

// Delete a pointer to an object in a list
ObjectList * deleteObjectFromList(WObject *po, ObjectList *list)
{
  ObjectList *firstelt = list, *nextelt = list, *tmplist = list;

  if (!po) {
    warning("deleteObjectFromList: po NULL");
    return NULL;
  }  
  if (list == NULL) {
    warning("deleteObjectFromList: can't delete object %s:%s from a NULL list!",
            po->name.class_name, po->name.instance_name);
    return NULL;
  }
  if (list->pobject == NULL) {
    warning("deleteObjectFromList: list->pobj NULL");
    return NULL;
  }
  if (list->pobject == po) {
    firstelt = list->next;
    free(list);
    return firstelt;
  }
  while (tmplist != NULL && tmplist->pobject != po) {
    nextelt = tmplist;
    tmplist = tmplist->next;
  }
  if (tmplist == NULL) {
    return firstelt;
  }

  nextelt->next = tmplist->next;
  free(tmplist);
  return firstelt;
}

// Free an object list
void freeObjectList(ObjectList *list)
{
  while (list != NULL) {
    ObjectList *nextelt;

    nextelt = list->next;	// BUG Here: seg fault
    free(list);	 // BUG Here: often segmentation fault in _free_chunk !
    list = nextelt;
  }
}

// Concatenate a pointers list on an object
ObjectList * addObjectList(ObjectList *l1, ObjectList *l2)
{
  if (l1 == NULL)
    return l2;
  return addObjectList(l1->next, addObjectToList(l1->pobject, l2));
}

// Concatenate (with test of "ispointed" & object) pointers list on an object
ObjectList * addObjectListToList(ObjectList *l1, WObject *po, ObjectList *l2)
{
  if (l1 == NULL) {
    if (l2 != NULL) {
      if (l2->pobject != po)
	return l2;
      else
        return NULL;
    }
    else
      return NULL;
  }
  else {
    if ((isValidType(l1->pobject->noh.type)) && !(l1->pobject->state.ispointed) && (l1->pobject != po)) {
      l1->pobject->state.ispointed = TRUE;
      return addObjectListToList(l1->next, po,
				 addObjectToList(l1->pobject, l2));
    }
    else
      return addObjectListToList(l1->next, po, l2);
  }
}

// Clear flags "ispointed" of all objects in a list
void clearIspointedFlag(ObjectList *list)
{
  for ( ; list != NULL && list->pobject != NULL; list = list->next) {
#if 0
    trace(DBG_FORCE, "clearIspointed: p=%p t=%d", list->pobject, list->pobject->noh.type);
#endif
    list->pobject->state.ispointed = FALSE;
  }
}

// renvoie la liste des pointeurs sur les objets touchant
// la case des grilles intersectees par la BB englobante des 2 objets
ObjectList * getVicinityObjectList(WObject *pcur, const Pos &oldpos)
{
  float pmin[3], pmax[3];
  for (int i = 0; i < 3; i++) {
    pmin[i] = MINI(pcur->pos.bbcenter.v[i] - pcur->pos.bbsize.v[i], 
		   oldpos.bbcenter.v[i] - oldpos.bbsize.v[i]);
    pmax[i] = MAXI(pcur->pos.bbcenter.v[i] + pcur->pos.bbsize.v[i], 
		   oldpos.bbcenter.v[i] + oldpos.bbsize.v[i]);
  }

  int imin[3], imax[3];
  calculateCoordinatesIntoGrid(pmin, imin);
  calculateCoordinatesIntoGrid(pmax, imax);

  ObjectList *vicinitylist = NULL;
  for (int x = imin[0]; x <= imax[0]; x++)
    for (int y = imin[1]; y <= imax[1]; y++)
      for (int z = imin[2]; z <= imax[2]; z++) {
        //trace(DBG_FORCE, "x=%d y=%d z=%d", x,y,z);
        vicinitylist = addObjectListToList(grid[x][y][z], pcur, vicinitylist);
      }

  clearIspointedFlag(vicinitylist);
  return vicinitylist;
}  

/* returns the list of objects with the given type id in the given list */
ObjectList * getObjectsWithType(int type_id)
{
  ObjectList *po = NULL;
  ObjectList *cursor = mobilelist;

  while (cursor != NULL) {
       if (cursor->pobject->noh.type == type_id) {
               po = addObjectToList(cursor->pobject, po);
       }
       cursor = cursor->next;
  }
  return po;
}

/* returns the object from the mobile list */
WObject * findObjectInMobile(u_int8 type_id, u_int32 src_id, u_int16 port_id, u_int16 obj_id)
{
  WObject *po = NULL;
  ObjectList *cursor = mobilelist;

  while ((po == NULL) && (cursor != NULL)) {
       if ((cursor->pobject->noh.type == type_id)
       &&  (cursor->pobject->noh.noid.src_id == src_id)
       &&  (cursor->pobject->noh.noid.port_id == port_id)
       &&  (cursor->pobject->noh.noid.obj_id == obj_id)) {
               po = cursor->pobject;
       }
       cursor = cursor->next;
  }
  return po;
}
