#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"	/* projectMovementOnObject */
#include "user.h"	/* USER_TYPE */
#include "ball.h"	/* BALL_TYPE */
#include "dart.h"	/* DART_TYPE */
#include "bullet.h"	/* BULLET_TYPE */
#include "link.h"

#include "zv.h"		/* parseGeometry */


const WClass Link::wclass(LINK_TYPE, "Link", Link::creator);


// create a link from a fileline
void Link::creator(char *l)
{
  new Link(l);
}

Link::Link(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  l = parseURL(l, this);
  soh = parseGeometry(l);

  initializeObject(this, LINK_TYPE, VR_STILL);
  nature.collision = COL_ONCE;
} 

// follow action
static
void linkFollow(Link *po, void *data, time_t sec, time_t usec)
{
  trace(DBG_IPMC, "follow %s", po->name.url);

  char *new_url = strdup(po->name.url);
  if (!new_url) {
    trace(DBG_FORCE, "linkFollow: can't strdup url=%s", new_url);
    return;
  }
  quitWorld();
  newWorld(new_url, NULL, VR_NEW);
  worlds->prop = WRL_LINKED;	// linked world
  free(new_url);
}

// when an intersection occurs
void Link::whenIntersect(WObject *pcur, WObject *pold)
{
  switch (pcur->noh.type) {
  case USER_TYPE:
    if (pcur->state.collide < 10) {
      copyPositionAndBB(pold, pcur);
      notice("Warning! You are near the link %s in=%d", name.instance_name, pcur->state.collide);
      pcur->state.collide++;
    }
    else if (pcur->state.collide < 20) {
      copyPositionAndBB(pold, pcur);
      notice("Warning! If you insist you'll follow the link %s in=%d", name.instance_name, pcur->state.collide);
      pcur->state.collide++;
    }
    else {
      linkFollow(this, NULL, 0L, 0L);
      pcur->state.collide = 0;
    }
    break;
  case BULLET_TYPE:
  case DART_TYPE:
    notice("%s:%s hits %s:%s",
            pcur->name.class_name, pcur->name.instance_name,
            name.class_name, name.instance_name);
    copyPositionAndBB(pold, pcur);
    objectToDelete(pcur);
    break;
  case BALL_TYPE:
    if (projectMovementOnObject(pcur->pos, pold->pos, this->pos))
      updateReplica(pcur, pold->pos);
    else
      copyPositionAndBB(pold, pcur);
    break;
  default:
    copyPositionAndBB(pold, pcur);
  }
}

void linkInitFuncList(void)
{
  setMethodFunc(LINK_TYPE, 0, WO_ACTION linkFollow, "Follow");
}

#endif // !VRENGD
