// ------------------------------------------------------------------------ //
// Author               : This file has been written by                     //
//                            Yann Renard (MyselF / Dim4)                   //
// Copyright            : This file is totaly free and you may distribute   //
//                        it to anyone you want, without modifying this     //
//                        header. If you use it in a commercial project (?) //
//                        or in bigger project (!), I would be glad to know //
//                        about it :) Please mail me...                     //
//                        be glad to know about it, please mail me          //
// Contact              : You can contact me at                             //
//                            renard@esiea-ouest.fr                         //
//                            myself_yr@hotmail.com                         //
// Bug reports          : Mail me please so I can know about it             //
// Purpose of this file : This package is my first experiment in bones      //
//                        programming. I feel it works great for a first    //
//                        time. For sure their are lots of optim to do...   //
//                        Your ideas are welcome :)                         //
// Version              : 1.0                                               //
// History              : none                                              //
// ToDo                 : lot's of things :)                                //
//                        other things :))))                                //
//                        Maybe buid an HTML tutorial about this subject ?  //
// Greets               : Dim4 members :)                                   //
//                        Latex, teacher forever                            //
//                        Ethereal, thx for ideas of implementation         //
//                        #codefr, thx for url                              //
//                        comp.graphics.algorithm && comp.graphics.opengl   //
//                        pech' and yoyo... newbies in demo hey !           //
// ------------------------------------------------------------------------ //

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "defaults.h"
#include "android.h"
#include "boneFactory.h"
#include "face.h"

#include "texture.h"

void * handle;

void cacheFile(void *am, void *handle)
{
  if (handle == NULL) {
    trace(DBG_FORCE, "cacheFile: unable to open http connection to file");
    return;
  }
  trace(DBG_MAN, "cacheFile: caching file in [/tmp/MyselF.cache] handle=%p", handle);

  // Caching file
  httpClearBuf();
  FILE *cache = fopen("/tmp/MyselF.cache", "wb");
  while (1) {
    int c = httpGetChar(handle);
    if (c < 0)
      break;
    putc(c, cache);
  }
  fclose(cache);
}

void loadUrlFaces(void *_po, void *handle)
{
  FACE *po = (FACE *) _po;

  if (handle == NULL) {
    trace(DBG_FORCE, "loadUrlFaces: unable to open http connection to file");
    return;
  }
  trace(DBG_MAN, "loadUrlFaces: handle=%p", handle);

  char line[64];

  httpClearBuf();
  while (httpGetLine(handle, line) == 0) {
    char *faceurl = (char *) malloc(strlen(line) + 1);
    strcpy(faceurl, line);
    trace(DBG_MAN, "loadUrlFaces: add url=%s", faceurl);
    po->urlList.addElement(faceurl);
  }
}

FACE::FACE(const char *urlFaces)
{
  mesh = NULL;
  root = NULL;
  moveYes = 0;
  moveNo = 0;
  moveMouth = 0;
  moveSmile = 0;
  moveSulk = 0;
  moveEyeL = 0;
  moveEyeR = 0;
  moveNose = 0;

  urlList.empty();
  httpOpen(urlFaces, loadUrlFaces, this, THREAD_NO_BLOCK);
  currentUrl = rand() % urlList.count();
}

FACE::~FACE()
{
  smartDelete(mesh);
  smartDelete(root);
}

void FACE::changeFace()
{
  currentUrl++;
  currentUrl %= urlList.count();
  loadFace(urlList.getElementAt(currentUrl));
}

void FACE::loadFace(const char *url)
{
  MESH3D     *newMesh;
  BONEVERTEX *newRoot;

  newMesh = new MESH3D ();
  newRoot = new BONEVERTEX ();

  trace(DBG_MAN, "loadFace: url=%s", url);
  httpOpen(url, cacheFile, handle, THREAD_NO_BLOCK);
#if 0
  FACTORY::readVRE3Dfile(newMesh, newRoot, "/tmp/MyselF.cache", FACE_SCALE);
#else
  FACTORY::readVRE3Dfile(newMesh, newRoot, "/tmp/MyselF.cache");
#endif
  animator.registerMesh(newMesh);
  animator.registerSkeleton(newRoot);
  animator.generateLinkList();

  smartDelete(mesh); mesh = newMesh;
  smartDelete(root); root = newRoot;
}

void FACE::render()
{
  if (mesh == NULL)
    changeFace();

  if (animator.meshToMove != NULL) {
    if (animator.skeleton != NULL) {
      //PD8 animate();
      animator.animate();
      animator.render();
    }
  }
}

void FACE::animate(int fapn, int angle)
{
  char *boneroot1, *boneroot2, *boneleft, *boneright;

  switch (fapn) {
  case CLOSE_T_L_EYELID:
    boneroot1 = "eyeLeftRoot";
    boneroot2 = "eyeLeftTopRoot";
    boneleft = "eyeLeftTopL";
    boneright = "eyeLeftTopR";
    break;
  case CLOSE_T_R_EYELID:
    boneroot1 = "eyeRightRoot";
    //boneroot2 = "sourcilRightRoot";
    boneroot2 = "eyeRightTopRoot";
    boneleft = "eyeRightTopL";
    boneright = "eyeRightTopR";
    break;
  case CLOSE_B_L_EYELID:
    boneroot1 = "eyeLeftRoot";
    boneroot2 = "eyeLeftBotRoot";
    boneleft = "eyeLeftBotL";
    boneright = "eyeLeftBotR";
    break;
  case CLOSE_B_R_EYELID:
    boneroot1 = "eyeRightRoot";
    //boneroot2 = "sourcilRightRoot";
    boneroot2 = "eyeRightBotRoot";
    boneleft = "eyeRightBotL";
    boneright = "eyeRightBotR";
    break;
  case YAW_L_EYEBALL:
    break;
  case YAW_R_EYEBALL:
    break;
  case PITCH_L_EYEBALL:
    break;
  case PITCH_R_EYEBALL:
    break;
  default:
    return;
  }

  BONEVERTEX *temp;

  if ((temp = root->findChild(boneroot1)) != NULL) {
    float bonescale = (1 - cos(angle / 1. /*20.0*/)) / 2.0;

    if ((temp = root->findChild(boneroot2)) != NULL) {
      temp->resetCurrentPosition();
      temp->scaleCurrentPosition(1, bonescale, 1);
      temp->setCurrentRotation(-(1-bonescale)/* *20.0 */, 1,0,0);
    }
    if ((temp = root->findChild(boneleft)) != NULL) {
      temp->resetCurrentPosition();
      temp->scaleCurrentPosition(1, bonescale, 1);
    }
  }
}

void FACE::animate()
{
  static float angle = 0.0;
  angle += 5.0;

  BONEVERTEX * temp;
  // --- LIPS MANAGEMENT ---
  // == smile then sulk
  if ( moveMouth ) {
    if ((temp = root->findChild("lipsRoot")) != NULL) {
      VECT3D smileDelta(0, cos(angle/10.0) / 4.0, 0);
      float smile = 20 * cos(angle / 10.0);
      if ((temp = root->findChild("lipsTopL")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(smile, 0,0,1);
      }
      if ((temp = root->findChild("lipsTopR")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(-smile, 0,0,1);
      }
      if ((temp = root->findChild("lipsBotL")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(smile, 0,0,1);
      }
      if ((temp = root->findChild("lipsBotR")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(-smile, 0,0,1);
      }
    }
  }
  // == smile
  if ( moveSmile ) {
    if ((temp = root->findChild("lipsRoot")) != NULL) {
      VECT3D smileDelta(0, cos(angle/10.0) / 4.0, 0);
      float smile = 20 * cos(angle / 10.0);
      if ((temp = root->findChild("lipsTopL")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(smile, 0,0,1);
      }
      if ((temp = root->findChild("lipsTopR")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(-smile, 0,0,1);
      }
    }
  }
  // == sulk
  if ( moveSulk ) {
    if ((temp = root->findChild("lipsRoot")) != NULL) {
      VECT3D smileDelta(0, cos(angle/10.0) / 4.0, 0);
      float smile = 20 * cos(angle / 10.0);
      if ((temp = root->findChild("lipsBotL")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(smile, 0,0,1);
      }
      if ((temp = root->findChild("lipsBotR")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(smileDelta);
        temp->setCurrentRotation(-smile, 0,0,1);
      }
    }
  }

  // --- LEFT EYE MANAGEMENT ---
  // == eye glance
  if ( moveEyeL ) {
    if ((temp = root->findChild("eyeLeftRoot")) != NULL) {
      float eyeLeftScale = (1 - cos(angle / 20.0)) / 2.0;
      if ((temp = root->findChild("eyeLeftBotRoot")) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(1, eyeLeftScale, 1);
        temp->setCurrentRotation(-(1-eyeLeftScale)*20.0, 1,0,0);
      }
      if ((temp = root->findChild("eyeLeftTopRoot")) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(1, eyeLeftScale, 1);
        temp->setCurrentRotation((1-eyeLeftScale)*20.0, 1,0,0);
      }
      if ((temp = root->findChild("eyeLeftTopL")) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(1, eyeLeftScale, 1);
      }
      if ((temp = root->findChild("eyeLeftTopR")) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(1, eyeLeftScale, 1);
      }
      if ((temp = root->findChild("eyeLeftBotL")) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(1, eyeLeftScale, 1);
      }
      if ((temp = root->findChild("eyeLeftBotR")) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(1, eyeLeftScale, 1);
      }
    }
  }

  // --- RIGHT EYE MANAGEMENT ---
  // eye move
  if ( moveEyeR ) {
    if ((temp = root->findChild("eyeRightRoot")) != NULL) {
      float eyeRightScale = (1 + cos(angle / 5.0)) / 20.0;
      if ((temp = root->findChild("sourcilRightRoot")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale / 2.0, 0);
      }
      if ((temp = root->findChild("eyeRightBotRoot")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale / 2.0, 0);
      }
      if ((temp = root->findChild("eyeRightTopRoot")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale, 0);
      }
      if ((temp = root->findChild("eyeRightTopL")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale, 0);
      }
      if ((temp = root->findChild("eyeRightTopR")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale, 0);
      }
      if ((temp = root->findChild("eyeRightBotL")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale / 2.0, 0);
      }
      if ((temp = root->findChild("eyeRightBotR")) != NULL) {
        temp->resetCurrentPosition();
        temp->translateCurrentPosition(0, eyeRightScale / 2.0, 0);
      }
    }
  }

  // --- NOSE MANAGEMENT ---
  // == resserement narines
  if ( moveNose ) {
    if ((temp = root->findChild("noseRoot")) != NULL) {
      float noseScale = 1 - cos(angle / 16.0) / 4.0;
      if ((temp = root->findChild("noseLeft")) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(noseScale, 1, 1);
      }
      if ((temp = root->findChild("noseRight")) != NULL) {
        temp->resetCurrentPosition();
        temp->scaleCurrentPosition(noseScale, 1, 1);
      }
    }
  }

  // --- ROOT MANAGEMENT ---
  if ( moveYes ) {
    if ((temp = root->findChild("root")) != NULL)
      temp->setCurrentRotation(10 * sin(angle/50.0), 1, 0, 0);
  }
  if ( moveNo ) {
    if ((temp = root->findChild("root")) != NULL)
      temp->setCurrentRotation(10 * sin(angle/50.0), 0, 1, 0);
  }

#undef BROW_MOTION
#ifdef BROW_MOTION
  float browRightScale = cos(angle / 5.0);
  if ((temp = root->findChild("sourcilRightRoot")) != NULL) {
    temp->resetCurrentPosition();
    temp->translateCurrentPosition(0, browRightScale / 25.0, 0);
  }
  if ((temp = root->findChild("sourcilRightL")) != NULL) {
    temp->resetCurrentPosition();
    temp->setCurrentRotation(10 * browRightScale, 0,0,1);
    temp->translateCurrentPosition(0, browRightScale / 25.0, 0);
  }
#endif
}

void changeMoveYes(Android *po, void *data, time_t sec, time_t usec)
{
  po->faceObject->moveYes = ! po->faceObject->moveYes;
}

void changeMoveNo(Android *po, void *data, time_t sec, time_t usec)
{
  po->faceObject->moveNo = ! po->faceObject->moveNo;
}

void changeMoveMouth(Android *po, void *data, time_t sec, time_t usec)
{
  po->faceObject->moveMouth = ! po->faceObject->moveMouth;
}

void changeMoveSmile(Android *po, void *data, time_t sec, time_t usec)
{
  po->faceObject->moveSmile = ! po->faceObject->moveSmile;
}

void changeMoveSulk(Android *po, void *data, time_t sec, time_t usec)
{
  po->faceObject->moveSulk = ! po->faceObject->moveSulk;
}

void changeMoveEyeR(Android *po, void *data, time_t sec, time_t usec)
{
  po->faceObject->moveEyeR = ! po->faceObject->moveEyeR;
}

void changeMoveEyeL(Android *po, void *data, time_t sec, time_t usec)
{
  po->faceObject->moveEyeL = ! po->faceObject->moveEyeL;
}

void changeMoveNose(Android *po, void *data, time_t sec, time_t usec)
{
  po->faceObject->moveNose = ! po->faceObject->moveNose;
}

void changeFace(Android *po, void *data, time_t sec, time_t usec)
{
  po->faceObject->changeFace();
}
