#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "zv.h"		/* parseGeometry */
#include "col.h"	/* COL_NEVER */
#include "earth.h"


const WClass Earth::wclass(EARTH_TYPE, "Earth", Earth::creator);


/* create from a fileline */
void Earth::creator(char *l)
{
  new Earth(l);
}

Earth::Earth(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  soh = parseGeometry(l);

  nature.collision = COL_NEVER;
  initializeObject(this, EARTH_TYPE, VR_MOBILE);

  move.perm_sec = 1;
  aspeed = EARTH_ASPEED;
}

/* system of equations handling permanent motion */
void Earth::changePermanent(float lasting)
{
  pos.az -= lasting * (-0.2);
  pos.az -= M_2PI * (float)floor((double)(pos.az / M_2PI));
}

void earthInitFuncList(void) { }

#endif /* !VRENGD */
