#ifndef DOOR_H
#define DOOR_H

#define DOOR_TYPE	3
#define DOOR_NAME	"Door"
#define DOOR_INIT	doorInitFuncList
#define DOOR_LASTING	0.07	/* 70 ms */
#define DOOR_PROPS	4

#define DOOR_PROPHNAME	0
#define DOOR_PROPXY	1
#define DOOR_PROPZ	2
#define DOOR_PROPAZ	3

#define DOOR_OPENED	0
#define DOOR_CLOSED	1
#define DOOR_UNLOCKED	2
#define DOOR_LOCKED	3

class Door: public WObject {
public:
  float aopen;
  float aclose;
  float aspeed;
  u_int8 status;	// opened | closed | unlocked | locked
  V3 center;
  V3 size;

  static const u_int8 propCount;
  //static (void (*) (WObject *po, struct _Payload *pp))tab[propCount];

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  Door(char *l);

  static void (creator)(char *l);
  virtual boolean change();
  virtual void changePosition(float lasting);
  virtual void updateTime(time_t, time_t, float *);
  virtual boolean updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void quit();
};

void DOOR_INIT(void);

#endif /* DOOR_H */
