#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "names.h"	/* getObjectByName */
#include "col.h"	/* COL_ONCE */
#include "button.h"

#include "zv.h"		/* parseGeometry */
#include "payload.h"	/* putPayload */


const WClass Button::wclass(BUTTON_TYPE, "Button", Button::creator);

static u_int16 oid = 1;


/* create a button from a fileline */
void Button::creator(char *l)
{
  new Button(l);
}

Button::Button(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  pos.state = atoi(l); l = strtok(NULL, SEP);
  obj_name = strdup(l); l = strtok(NULL, SEP);
  method0 = atoi(l); l = strtok(NULL, SEP);
  method1 = atoi(l); l = strtok(NULL, SEP);
  soh = parseGeometry(l);

  initializeObject(this, BUTTON_TYPE, VR_MOBILE);
  maxlasting[BUTTON_TYPE] = BUTTON_LASTING;
  nature.collision = COL_ONCE;

  initializeNetObject(this, oid++, BUTTON_PROPS, VR_PERMANENT);
} 

/* update a button towards the network */
boolean Button::updateToNetwork(const Pos &oldpos)
{
  boolean change = FALSE;

  if (pos.state != oldpos.state) {
    declareObjDelta(&(this->noh), BUTTON_PROPSTATE);
    change = TRUE;
  }
  return change;
}

static
void buttonSwitch(Button *po, void *data, time_t sec, time_t usec)
{
  int method;
  
  if (po->pos.state == 0)
    method = po->method0;
  else
    method = po->method1;
  po->pos.state = 1 - po->pos.state;
  setSolidFrame(po->soh, po->pos.state);

  WObject *pnet = NULL;

  if ((pnet = getObjectByName(po->obj_name)) != NULL) {
    struct timeval te;
    gettimeofday(&te, NULL);
    if ((method < OBJECTSNUMBER+1) &&
	(generalMethodList[method][pnet->noh.type].method != NULL))
      generalMethodList[method]
	[pnet->noh.type].method(pnet, data, te.tv_sec, te.tv_usec);
    else
      warning("button: object named %s has no method %d",
	      po->obj_name, method);
  }
  else
    warning("button: no object named %s", po->obj_name);
}

/* object intersects: stop */
void Button::whenIntersect(WObject *pcur, WObject *pold)
{
  copyPositionAndBB(pold, pcur);
}

void Button::updateTime(time_t sec, time_t usec, float *lasting)
{
  *lasting = 0.0;
}

void set_bstate(Button *po, Payload *pp)
{
  Pos oldpos = po->pos;
  
  getPayload(pp, "d", &(po->pos.state));
  updateReplica(po, oldpos);
}

void get_bstate(Button *po, Payload *pp)
{
  putPayload(pp, "d", po->pos.state);
}

void Button::quit()
{
  if (obj_name)
    free(obj_name);
  oid = 1;
}

void buttonInitFuncList(void)
{
  setFuncList[BUTTON_PROPSTATE][BUTTON_TYPE].pf = WO_PAYLOAD set_bstate;
  getFuncList[BUTTON_PROPSTATE][BUTTON_TYPE].pf = WO_PAYLOAD get_bstate;

  setMethodFunc(BUTTON_TYPE, 0, WO_ACTION buttonSwitch, "Switch");
}

#endif /* !VRENGD */
