#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"	/* projectMovementOnObject */
#include "board.h"

#include "zv.h"		/* parseGeometry */
#include "texture.h"	/* getCurrentTextureNumber */
#include "helpers.h"	/* startwhiteboard */


const WClass Board::wclass(BOARD_TYPE, "Board", Board::creator);


/* board initialization from a file */
void Board::creator(char *l)
{
  new Board(l);
}

Board::Board(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  soh = parseGeometry(l);

  initializeObject(this, BOARD_TYPE, VR_STILL);
  trace(DBG_WMGT, "board: texture_number = %d", getCurrentTextureNumber());
  status = BOARD_INACTIVE;
} 

/* object intersect: projection */
void Board::whenIntersect(WObject *pcur, WObject *pold)
{
  if (projectMovementOnObject(pcur->pos, pold->pos, this->pos))
    updateReplica(pcur, pold->pos);
  else
    copyPositionAndBB(pold, pcur);
}

/* draw */
static
void boardDraw(Board *po, void *data, time_t sec, time_t usec)
{
  quitwhiteboard();
  startwhiteboard(getCurrentChannelName());
  po->status = BOARD_OPEN;
}

static
void boardImport(Board *po, void *data, time_t sec, time_t usec)
{
  if (po->status == BOARD_INACTIVE)
    return;
  po->status |= BOARD_IMPORT;
  notice("Click in the whiteboard window");
  /* TODO */
}

static
void boardExit(Board *po, void *data, time_t sec, time_t usec)
{
  quitwhiteboard();
}

void Board::quit()
{
  quitwhiteboard();
}

void boardInitFuncList(void)
{
  setMethodFunc(BOARD_TYPE, 0, WO_ACTION boardDraw, "Draw");
  setMethodFunc(BOARD_TYPE, 1, WO_ACTION boardImport, "Import");
  setMethodFunc(BOARD_TYPE, 2, WO_ACTION boardExit, "Exit");
}

#endif /* !VRENGD */
