#ifndef ANDROID_H
#define ANDROID_H

#define ANDROID_TYPE 40
#define ANDROID_NAME "Android"
#define	ANDROID_INIT androidInitFuncList

#include <GL/glu.h>

#include "face.h"	// YR


#define ANDROID_INACTIVE	0
#define ANDROID_PLAYING	1
#define ANDROID_LISTENING	2
#define ANDROID_UNICAST	0
#define ANDROID_MULTICAST	1

// BAP/FAP values
#ifdef STANDALONE
#define BAPFAP_HOST	"localhost"
#else
#define BAPFAP_HOST	"infres2.enst.fr"
#endif
#define BAPFAP_PORT	4150
#define BAP_OFFSET_PORT	10
#define BAPFAP_BUFSIZ	8192
#define TYPE_BAP_V1	1
#define TYPE_BAP_V2	2
#define TYPE_FAP	3
#define NUM_BAPS        186	// Mpeg4 specif
#define NUM_BAPS_V2     296	// Mpeg4 specif
#define NUM_FAPS        68	// Mpeg4 specif

#define NUM_JOINTS	60

#define	PELVIC_TILT		1
#define	PELVIC_TORSION		2
#define	PELVIC_ROLL		3
#define	L_HIP_FLEXION		4
#define	R_HIP_FLEXION		5
#define	L_HIP_ABDUCT		6
#define	R_HIP_ABDUCT		7
#define	L_HIP_TWIST		8
#define	R_HIP_TWIST		9
#define	L_KNEE_FLEXION		10
#define	R_KNEE_FLEXION		11
#define	L_KNEE_TWIST		12
#define	R_KNEE_TWIST		13
#define	L_ANKLE_FLEXION		14
#define	R_ANKLE_FLEXION		15
#define	L_ANKLE_TWIST		16
#define	R_ANKLE_TWIST		17
#define	L_SHOULDER_FLEXION	32
#define	R_SHOULDER_FLEXION	33
#define	L_SHOULDER_ABDUCT	34
#define	R_SHOULDER_ABDUCT	35
#define	L_SHOULDER_TWIST	36
#define	R_SHOULDER_TWIST	37
#define	L_ELBOW_FLEXION		38
#define	R_ELBOW_FLEXION		39
#define	L_ELBOW_TWIST		40
#define	R_ELBOW_TWIST		41
#define	L_WRIST_FLEXION		42
#define	R_WRIST_FLEXION		43
#define	L_WRIST_PIVOT		44
#define	R_WRIST_PIVOT		45
#define	L_WRIST_TWIST		46
#define	R_WRIST_TWIST		47
#define	C1ROLL			48
#define	C1TORSION		49
#define	C1TILT			50
#define	C4ROLL			57
#define	C4TORSION		58
#define	C4TILT			59
#define	T5ROLL			81
#define	T5TORSION		82
#define	T5TILT			83
#define	TR_VERTICAL		181
#define	TR_LATERAL		182
#define	TR_FRONTAL		183
#define	RT_BODY_TURN		184
#define	RT_BODY_ROLL		185
#define	RT_BODY_TILT		186

#define	UPPER_NECK		1
#define	L_SHOULDER		2
#define	L_ELBOW			3
#define	L_WRIST			4
#define	R_SHOULDER		5
#define	R_ELBOW			6
#define	R_WRIST			7
#define	L_HIP			8
#define	L_KNEE			9
#define	R_HIP			10
#define	R_KNEE			11
#define	L_ANKLE			12
#define	R_ANKLE			13
#define	PELVIC			14
#define	SPINAL			15
#define	LOWER_NECK		16

struct _jp {
  float x[NUM_JOINTS+1];
  float y[NUM_JOINTS+1];
  float z[NUM_JOINTS+1];
};

struct model {
  int vn; /* Vertex number */
  int nn; /* Normal number */
  int pn; /* Polygon number */
  
  float *v; /* Vertexs */
  float *n; /* Normals */
  int   *p; /* Polygons */
};

class Android: public WObject {
public:
  float rotx;
  float roty;
  float rotz;
  u_int8 numjoints;
  u_int8 status;
  u_int8 bfflag;	// stream type bap-3.1, bap-3.2, fap

  class Phalanx2 *phalanx2[10]; 
  class Phalanx *phalanx[10];
  class Finger	*fingers_r[5], *fingers_l[5];
  class Hand	*hand_r, *hand_l;
  class Forearm	*forearm_r, *forearm_l;
  class Arm	*arm_r, *arm_l;
  class Shoulder *shoulders[2];
  class Neck	*neck;
  class Head	*head;
  class Bust	*bust;
  class Leg	*legs[2];
  class Calf	*calf_r, *calf_l;
  class Foot	*foot_r, *foot_l;

  GLfloat tx,ty,tz,rx,ry,rz;  

  struct model head1, neck1, body_up, body_bot;
  struct model la_up, la_mid, la_hand;
  struct model ra_up, ra_mid, ra_hand;
  struct model ll_up, ll_mid, ll_foot;
  struct model rl_up, rl_mid, rl_foot;
  GLuint manlist;
  GLfloat skin[4];
  
  char line[BAPFAP_BUFSIZ];
  int mask[NUM_BAPS_V2 + 1];
  int bap[NUM_BAPS_V2 + 1];
  int fap[NUM_FAPS + 1];
  
  char baps[64];	// bap server
  char faces_url[64];
  int sdtcp;
  int sdudp;
  struct sockaddr_in tcpsa;
  struct sockaddr_in udpsa;
  struct ip_mreq mreq;
  int ipmode;
  int num_baps;
  u_int16 bap_port;

  struct _jp jp;

  FACE * faceObject;	// YR

  static const WClass wclass;   // class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method
  
  Android(char *);	/* constructor */

  static void (creator)(char *);
  virtual void changePermanent(float lasting);
  virtual void render();
  virtual void quit();
};

void ANDROID_INIT(void);

#endif /* ANDROID_H */
