/*
 * Initialization module
 */

#ifndef VRENGD

#include "global.h"
#include "defaults.h"	/* DEF_VRE_CHANNEL */

#include "gui.h"	/* resources initSignals */
#include "net.h"
#include "world.h"	/* initWMgt */
#include "channel.h"	/* Channel */
#include "stat.h"	/* ptime_init */

/*
 * Global variables
 */
u_int32 debug = 0;		/* debug flag */
int vrengd;
Universe universe;


static void WorldInitCB()
{
  /*
   * World Initialization
   */
  trace(DBG_INIT, "cfg initial = %s", universe.urlinitial);
  initWMgt(universe.urlinitial, resources.nick, resources.skinf, resources.skinb);
  trace(DBG_INIT, "Wmgt initialized");

  stopTime(&ptime_init);
}


int main(int argc, char *argv[])
{
  vrengd = FALSE;

  startTime(&ptime_init);

  /*
   * lower priority
   */
  initNice();

  /*
   * System Infos
   */
  initsysinfo();

  /*
   *  Arithmetic Initialization
   */
  initFloating();
  initTrigo();

  /*
   * Environment Initialization
   */
  initEnv();
  parsePrefs();

  /*
   * Resources Initialization
   */
#if WANT_GLUT //OBSMEMBER
  initResources(argc, argv);
  trace(DBG_INIT, "Resources initialized");
#else
  GuiInitAndGetResources(argc, argv);
  trace(DBG_INIT, "GUI and Resources initialized");
#endif

  /*
   *  Silmutaneous http connections Initialization
   */
  initThreads();
  trace(DBG_INIT, "Threads initialized");

  /*
   *  Signals Initialization
   */
  initSignals();
  trace(DBG_INIT, "Signals initialized");

#if WANT_GLUT //OBSMEMBER
  /*
   * GUI Initialization
   */
  initGUI();
  trace(DBG_INIT, "GUI initialized");
#endif

  /*
   * Network Initialization
   */
#if defined(WIN32) && !defined(CYGWIN32)
  initDll();
#endif /* WIN32 */

  memset((char *) &universe, 0, sizeof(universe));
  trace(DBG_INIT, "resources.multicast=%s", resources.multicast);
  universe.ttlorigin = getvrttl(resources.multicast);
  strcpy(universe.name, DEF_HTTP_SERVER);

  clearChannelsList();

  memset((char *) &manager, 0, sizeof(manager));
  setManagerChannelName(MANAGER_CHANNEL);	/* join manager channel */
  strcpy(manager.name, "manager");
  trace(DBG_INIT, "manager channelname=%s", getManagerChannelName());

  allocWorld();
  setCurrentChannelName(DEF_VRE_CHANNEL);	/* join initial channel */
  trace(DBG_INIT, "channelinitial=%s", getCurrentChannelName());

  strncpy(universe.urlinitial, resources.world, URL_LEN);
  setLocalWorldName(universe.urlinitial);
  strncpy(universe.groupinitial, getvrgroup(getCurrentChannelName()), GROUP_LEN);
  universe.portinitial = getvrport(getCurrentChannelName());
  trace(DBG_INIT, "Network initialized");

  /*
   * World Initialization & mainLoop
   */

#if WANT_GLUT
  WorldInitCB();
  mainLoop();
#else
  /* WorldInitCB fait en callback apres lancement de la main loop 
     pour eviter une attente trop importante
  */
  GuiMainLoop(WorldInitCB);
#endif

  /* NOT_REACHED */
  return 0;
}

#endif /* !VRENGD */
