/*
 * INTERPPS tool
 *
 * Philippe Dax
 * Jul 1999
 */

#ifndef VRENGD

#include "global.h"
#include "pspdf.h"
#include "wget.h"


/* global variable */
int pstool = GV_TOOL;

static int pspid = -1;
static char *tmpps;


static
void startgv(const char *tool, const char *url)
{
  switch (pspid = fork()) {
  case -1:
    trace(DBG_TOOL, "can't fork for %s", tool);
    break;
  case 0:
    execlp("gv", tool, tmpps, (char *) NULL);
    execlp("ghostscript", tool, tmpps, (char *) NULL);
    trace(DBG_TOOL, "can't exec %s", tool);
    exit(1);
  default:
    break;
  }
}

void viewps(const char *url)
{
  tmpps = NULL;
  trace(DBG_TOOL, "pstool=%x url=%s", pstool, url);
  if ((tmpps = startwget(url)) != NULL) {
    if (pstool == GV_TOOL)
      startgv("gv", url);
    else if (pstool == GHOSTVIEW_TOOL)
      startgv("ghostview", url);
    else trace(DBG_TOOL, "unknown ps");
    /* unlink(tmpps); */
  }
}

static
void starta2ps(const char *tool, const char *url)
{
  pspid = fork();
  switch (pspid) {
  case -1:
    trace(DBG_TOOL, "can't fork for %s", tool);
    break;
  case 0:
    execlp("a2ps", tool, "-d", tmpps, (char *) NULL);
    trace(DBG_TOOL, "can't exec %s\n", tool);
    exit(1);
  default:
    /* unlink(tmpps); */
    break;
  }
}

void printps(const char *url)
{
  tmpps = NULL;
  if ((tmpps = startwget(url)) != NULL) {
    starta2ps("a2ps", url);
    unlinktmp(tmpps);
  }
}

void quitps(void)
{
  if (pspid > 0)
    kill(pspid, SIGKILL);
  unlinktmp(tmpps);
}

#endif /* !VRENGD */
