/*
 * MPG tool
 *
 * Philippe Dax
 * May 2000
 */

#ifndef VRENGD

#include "global.h"
#include "mpg.h"
#include "wget.h"


/* global variable */
int mpgtool = MTVP_TOOL;

static int mpgpid = -1;
static char *tmpmpg;


static
void loadmpg(const char *tool, const char *url)
{
  mpgpid = fork();
  switch (mpgpid) {
  case -1:
    trace(DBG_TOOL, "can't fork for %s", tool);
    break;
  case 0:
    switch (mpgtool) {
    case MTVP_TOOL:
      trace(DBG_TOOL, "tool=%s url=%s", tool, url);
      execlp(tool, tool, url, (char *) NULL);
      break;
    case MPEGPLAY_TOOL:
      execlp(tool, tool, tmpmpg, (char *) NULL);
      break;
    }
    trace(DBG_TOOL, "can't exec %s", tool);
    exit(1);
  default:
    break;
  }
}

void startmpg(const char *url)
{
  tmpmpg = NULL;
  trace(DBG_TOOL, "mpgtool=%x url=%s", mpgtool, url);
  switch (mpgtool) {
  case MTVP_TOOL:
    loadmpg("mtvp", url);
    break;
  case MPEGPLAY_TOOL:
    if ((tmpmpg = startwget(url)) != NULL)
      loadmpg("mpeg_play", url);
    break;
  default:
    trace(DBG_TOOL, "unknown mpg tool");
  }
}

void stopmpg(void)
{
  if (mpgpid > 0)
    kill(mpgpid, SIGKILL);
  unlinktmp(tmpmpg);
}

void pausempg(void)
{
  if (mpgpid > 0)
    kill(mpgpid, SIGSTOP);
}

void contmpg(void)
{
  if (mpgpid > 0)
    kill(mpgpid, SIGCONT);
}


#endif /* !VRENGD */
