/*---------------------------------------------------------------------------*\

    FILE....: OBJTRACK.H
    TYPE....: C++ Module header file
    AUTHOR..: David Rowe
    DATE....: 25/3/98

    This module maintains a database of the VPB configuration manager
	objects.  This database is used to determine a device handle 
	(channel) from an object and board, or vice versa.


         Voicetronix Voice Processing Board (VPB) Software
         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef __OBJTRACK__
#define __OBJTRACK__

// object classes

#define	UPOBJ	0	// start object for up direction (rx) objects
#define	DNOBJ	1	// start object down direction (tx) objects
#define	DTMFOBJ	2	// DTMF dectector object
#define	CPOBJ	3	// call progress (tone detector) object
#define	TONEOBJ	4	// tone generator objects
#define ADCOBJ	5	// ADC object (logging card)
#define AGCOBJ	6	// AGC object (logging card)
#define VOXOBJ	7	// VOX object (logging card)
#define ECHOOBJ	8	// Echo canceller object
#define DELAYOBJ 9	// Delay object
#define	FIFOUPOBJ 10	// FIFO Up object
#define	FIFODNOBJ 11	// FIFO Down object


//! Initialises the objtrack module.
void objtrack_open();

//! Releases the objtrack module.
void objtrack_close();

//! Add a config manager object to the database.
//{{{
//! @param cls    The class of the object.
//! @param id     The id of the object on this board.
//! @param handle The handle of the port that the object is associated with.
//! @param board  The board number that the object is associated with.
//}}}
void objtrack_add_object(unsigned short cls, int id, int handle, unsigned short board);

//! Retrieves the port handle for an object given the id and board number.
//{{{
//! @param cls   The class of the object.
//! @param id    The id of an object, as returned by @c objtrack_handle_to_id().
//! @param board The number of the board the object belongs to.
//! @return The port handle the object belongs to.
//}}}
int objtrack_id_to_handle(unsigned short cls, int id, unsigned short board);

//! Finds the id of an object given a class and channel handle.
//{{{
//! @param cls    The class of the object.
//! @param handle The handle of the port it belongs to
//! @return The integer id for the object.
//!
//! If there is more than one object of this class on this channel it will
//! return the id of the first one found.
//}}}
int objtrack_handle_to_id(unsigned short cls, int handle);

#endif	// __OBJTRACK__
