/*---------------------------------------------------------------------------*\

    FILE....: openpri.h
    TYPE....: C Function Header File
    AUTHOR..: Ben Kramer
    DATE....: xx/11/2004


         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef __OPENPRI__
#define __OPENPRI__
#include "vpbreg.h"
#include "generic.h"

extern "C" {
#include "libpri/libpri.h"
}


struct isdncid {
	int callingplan;
	int callingpres;
	char callingnum[256];
	char callingname[256];
	char calledsubaddr[256];
	char callednum[256];
	int calledplan;
};

struct pri_chan {
	pid_t pid;
	int state;
	int run;
	int encoding;		// Encoding
	int layer1;		// Encoding as from Call setup or for next call
	unsigned char lowlayercompatibility[8];
	int transcap;		// Transmit capabilities form Call setup or for next call
	int chan_num;		// vpb channel number
	PRI_IFACE *iface;	// Pointer to the iface information
	int cause;		// Cause code for last call clear down
	int cref;		// Call reference number
	int cref_check;		// Checked for extra information from cref_info, used for logging
	q931_call *call;	// libpri data structure
	Fifo *tx_fifo;  	// Where to send data when bridged
	void *dtmf_dec;		// Pointer to dtmf states
	void *vox_states;       // Pointer to vox states
	isdncid *cid;
	VPBREG *v;
};

typedef struct {
	unsigned char *card;
	unsigned char *interface;
	int start_channel;
	int end_channel;
	VPBREG * v;
} AUDIO_THREAD_MULTI;


class OpenPri : public HostDSP
{
private:

	pthread_t   m_dspthread;
	pthread_t   m_dchanthread;
	pthread_t   m_audiothread[32];

	pthread_mutex_t m_mutex;

	AUDIO_THREAD_MULTI *m_audio_multi_info;
	int                 m_audio_multi;

	struct cref_info   *m_cref_info;
	struct pri	   *m_pri;
	struct pri	   *m_pri2;

	static void *SimulateDSP(void *p);
	static void *RunDchannel(void *p);
	static void *RunDchannelLog(void *p);

	void HostDSPOpen();
	void HostDSPClose();
	void OpenPorts();
	void ClosePorts();

	bool ProcessCommands();

	void handle_pri_event_log(struct pri *pri, pri_event *e);
	void handle_pri_event(struct pri *pri, pri_event *e);
	int make_isdn_call(uint16_t *d);


public:

	OpenPri(VPBREG &reg);
	~OpenPri();

	// base class implementation
	void Reset( unsigned int port ) { (void)port; }
	void SetCountry( int port, const Country *country );

	void SetHookState( int port, HookState hookstate );

	void WaitForTxEmpty( int port );

	int chan_state(int ch);
	int chan_cinfo(int ch, void * info);
	int chan_cause(int ch);
	int call_proceeding(int ch);
	int chan_layer1(int ch);
	int chan_transcap(int ch);
	int make_isdn_call_api(int ch, char *number, char *cid, int layer1,
			       int transcap, unsigned char *lowlayercompatibility);
	int chan_lowlayercompatibility(int ch, unsigned char *lowlayercompatibility);
};

#endif

