/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rdr.OutStream;
import rfb.AuthFailureException;
import rfb.CMsgHandler;
import rfb.CMsgReader;
import rfb.CMsgReaderV3;
import rfb.CMsgWriter;
import rfb.CMsgWriterV3;
import rfb.CSecurity;
import rfb.ConnFailedException;
import rfb.Exception;
import rfb.LogWriter;
import rfb.SecTypes;

public abstract class CConnection
extends CMsgHandler {
    public static final int RFBSTATE_UNINITIALISED = 0;
    public static final int RFBSTATE_PROTOCOL_VERSION = 1;
    public static final int RFBSTATE_SECURITY_TYPES = 2;
    public static final int RFBSTATE_SECURITY = 3;
    public static final int RFBSTATE_SECURITY_RESULT = 4;
    public static final int RFBSTATE_INITIALISATION = 5;
    public static final int RFBSTATE_NORMAL = 6;
    public static final int RFBSTATE_INVALID = 7;
    public static final int maxSecTypes = 8;
    static LogWriter vlog = new LogWriter("CConnection");
    InStream is;
    OutStream os;
    CMsgReader reader_;
    CMsgWriter writer_;
    boolean shared;
    CSecurity security;
    int nSecTypes;
    int[] secTypes = new int[8];
    int state_ = 0;
    String serverName;
    boolean useProtocol3_3;
    boolean clientSecTypeOrder;

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setStreams(InStream inStream, OutStream outStream) {
        this.is = inStream;
        this.os = outStream;
    }

    public void initSecTypes() {
        this.nSecTypes = 0;
    }

    public void addSecType(int n) {
        if (this.nSecTypes == 8) {
            throw new Exception("too many security types");
        }
        this.secTypes[this.nSecTypes++] = n;
    }

    public void setShared(boolean bl) {
        this.shared = bl;
    }

    public void setProtocol3_3(boolean bl) {
        this.useProtocol3_3 = bl;
    }

    public void initialiseProtocol() {
        this.state_ = 1;
    }

    public void processMsg() {
        switch (this.state_) {
            case 1: {
                this.processVersionMsg();
                break;
            }
            case 2: {
                this.processSecurityTypesMsg();
                break;
            }
            case 3: {
                this.processSecurityMsg();
                break;
            }
            case 4: {
                this.processSecurityResultMsg();
                break;
            }
            case 5: {
                this.processInitMsg();
                break;
            }
            case 6: {
                this.reader_.readMsg();
                break;
            }
            case 0: {
                throw new Exception("CConnection.processMsg: not initialised yet?");
            }
            default: {
                throw new Exception("CConnection.processMsg: invalid state");
            }
        }
    }

    public abstract CSecurity getCSecurity(int var1);

    public CSecurity getCurrentCSecurity() {
        return this.security;
    }

    public void setClientSecTypeOrder(boolean bl) {
        this.clientSecTypeOrder = bl;
    }

    public void authSuccess() {
    }

    public void serverInit() {
        this.state_ = 6;
        vlog.debug("initialisation done");
    }

    public CMsgReader reader() {
        return this.reader_;
    }

    public CMsgWriter writer() {
        return this.writer_;
    }

    public InStream getInStream() {
        return this.is;
    }

    public OutStream getOutStream() {
        return this.os;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int state() {
        return this.state_;
    }

    protected void setState(int n) {
        this.state_ = n;
    }

    void processVersionMsg() {
        vlog.debug("reading protocol version");
        if (!this.cp.readVersion(this.is)) {
            this.state_ = 7;
            throw new Exception("reading version failed: not an RFB server?");
        }
        vlog.info("Server supports RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion);
        if (this.cp.beforeVersion(3, 3)) {
            String string = "Server gave unsupported RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion;
            vlog.error(string);
            this.state_ = 7;
            throw new Exception(string);
        }
        if (this.useProtocol3_3 || this.cp.beforeVersion(3, 7)) {
            this.cp.setVersion(3, 3);
        } else if (this.cp.afterVersion(3, 8)) {
            this.cp.setVersion(3, 8);
        }
        this.cp.writeVersion(this.os);
        this.state_ = 2;
        vlog.info("Using RFB protocol version " + this.cp.majorVersion + "." + this.cp.minorVersion);
    }

    /*
     * Unable to fully structure code
     */
    void processSecurityTypesMsg() {
        CConnection.vlog.debug("processing security types message");
        var1_1 = 0;
        if (this.cp.majorVersion != 3 || this.cp.minorVersion != 3) ** GOTO lbl19
        var1_1 = this.is.readU32();
        if (var1_1 == 0) {
            this.throwConnFailedException();
        } else if (var1_1 == 1 || var1_1 == 2) {
            var2_2 = 0;
            while (var2_2 < this.nSecTypes) {
                if (this.secTypes[var2_2] == var1_1) break;
                ++var2_2;
            }
            if (var2_2 == this.nSecTypes) {
                var1_1 = 0;
            }
        } else {
            CConnection.vlog.error("Unknown 3.3 security type " + var1_1);
            throw new Exception("Unknown 3.3 security type");
lbl19:
            // 1 sources

            var2_3 = this.is.readU8();
            if (var2_3 == 0) {
                this.throwConnFailedException();
            }
            var3_4 = this.nSecTypes;
            var4_5 = 0;
            while (var4_5 < var2_3) {
                var5_6 = this.is.readU8();
                CConnection.vlog.debug("Server offers security type " + SecTypes.name(var5_6) + "(" + var5_6 + ")");
                if (var1_1 == 0 || this.clientSecTypeOrder) {
                    var6_7 = 0;
                    while (var6_7 < this.nSecTypes) {
                        if (this.secTypes[var6_7] == var5_6 && var6_7 < var3_4) {
                            var1_1 = this.secTypes[var6_7];
                            var3_4 = var6_7;
                            break;
                        }
                        ++var6_7;
                    }
                }
                ++var4_5;
            }
            if (var1_1 != 0) {
                this.os.writeU8(var1_1);
                this.os.flush();
                CConnection.vlog.debug("Choosing security type " + SecTypes.name(var1_1) + "(" + var1_1 + ")");
            }
        }
        if (var1_1 == 0) {
            this.state_ = 7;
            CConnection.vlog.error("No matching security types");
            throw new Exception("No matching security types");
        }
        this.state_ = 3;
        this.security = this.getCSecurity(var1_1);
        this.processSecurityMsg();
    }

    void processSecurityMsg() {
        vlog.debug("processing security message");
        int n = this.security.processMsg(this);
        if (n == 0) {
            this.throwAuthFailureException();
        }
        if (n == 1) {
            this.state_ = 4;
            this.processSecurityResultMsg();
        }
    }

    void processSecurityResultMsg() {
        vlog.debug("processing security result message");
        int n = this.cp.beforeVersion(3, 8) && this.security.getType() == 1 ? 0 : this.is.readU32();
        switch (n) {
            case 0: {
                this.securityCompleted();
                break;
            }
            case 1: {
                vlog.debug("auth failed");
                this.throwAuthFailureException();
            }
            case 2: {
                vlog.debug("auth failed - too many tries");
                this.throwAuthFailureException();
            }
            default: {
                vlog.error("unknown security result");
                this.throwAuthFailureException();
            }
        }
    }

    void processInitMsg() {
        vlog.debug("reading server initialisation");
        this.reader_.readServerInit();
    }

    void throwAuthFailureException() {
        vlog.debug("state=" + this.state() + ", ver=" + this.cp.majorVersion + "." + this.cp.minorVersion);
        String string = this.state() == 4 && !this.cp.beforeVersion(3, 8) ? this.is.readString() : "Authentication failure";
        this.state_ = 7;
        vlog.error(string);
        throw new AuthFailureException(string);
    }

    void throwConnFailedException() {
        this.state_ = 7;
        String string = this.is.readString();
        throw new ConnFailedException(string);
    }

    void securityCompleted() {
        this.state_ = 5;
        this.reader_ = new CMsgReaderV3(this, this.is);
        this.writer_ = new CMsgWriterV3(this.cp, this.os);
        vlog.debug("Authentication success!");
        this.authSuccess();
        this.writer_.writeClientInit(this.shared);
    }
}

