/* pixmaps.c */



/* This module replaces the runtime pixmaps required by LUI with a
   compile-time equivalent.

   Written by:  Brian Paul  on 3-15-91
*/



#include <stdio.h>
#include <X11/Xlib.h>
#include "lui.h"


#define WIDTH 18
#define HEIGHT 18



static unsigned long data_option_in[] =
{ 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00a7a7a7, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00181818,
  0x00181818, 0x00181818, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00181818,
  0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00181818,
  0x001d1d1d, 0x00242424, 0x00262626, 0x001f1f1f, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00181818, 0x00181818,
  0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00202020, 0x00008c00,
  0x00363636, 0x003d3d3d, 0x00424242, 0x00424242, 0x00383838, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00181818, 0x00181818,
  0x00181818, 0x00181818, 0x0000b900, 0x0000bc00, 0x0000b500, 0x0000a900,
  0x00009800, 0x00008200, 0x00006100, 0x005b5b5b, 0x00585858, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00181818, 0x00181818, 0x00181818,
  0x00181818, 0x0000bc00, 0x0000c100, 0x0000bd00, 0x0000b400, 0x0000a600,
  0x00009600, 0x00008200, 0x00006a00, 0x00004800, 0x006f6f6f, 0x00666666,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00181818, 0x00181818, 0x00181818,
  0x0000af00, 0x0000bc00, 0x0001bd01, 0x003de63d, 0x003de63d, 0x00009e00,
  0x00008e00, 0x00007b00, 0x00006400, 0x00004800, 0x00001e00, 0x007d7d7d,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00181818, 0x00181818, 0x00181818,
  0x0000ae00, 0x0000b300, 0x0007b807, 0x00ffffff, 0x003de63d, 0x00009e00,
  0x00008100, 0x00006f00, 0x00005900, 0x00003f00, 0x00001c00, 0x008e8e8e,
  0x00ffffff, 0x00ffffff, 0x00a7a7a7, 0x00181818, 0x00181818, 0x00202020,
  0x0000a200, 0x0000a500, 0x0000a200, 0x0006a006, 0x00019101, 0x00008200,
  0x00007200, 0x00005f00, 0x00004a00, 0x00003100, 0x00001800, 0x009c9c9c,
  0x007c7c7c, 0x00ffffff, 0x00ffffff, 0x00181818, 0x00181818, 0x00006f00,
  0x00009100, 0x00009300, 0x00008f00, 0x00008700, 0x00007d00, 0x00006f00,
  0x00006000, 0x00004d00, 0x00003800, 0x00001f00, 0x00001800, 0x00a7a7a7,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00181818, 0x001e1e1e, 0x00363636,
  0x00007b00, 0x00007e00, 0x00007a00, 0x00007300, 0x00006800, 0x00005b00,
  0x00004b00, 0x00003900, 0x00002300, 0x00001800, 0x00001800, 0x00afafaf,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00181818, 0x00242424, 0x003d3d3d,
  0x00006000, 0x00006600, 0x00006300, 0x00005b00, 0x00005100, 0x00004400,
  0x00003400, 0x00002100, 0x00001800, 0x00001800, 0x00001800, 0x00b2b2b2,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00262626, 0x00424242,
  0x00003b00, 0x00004800, 0x00004700, 0x00004100, 0x00003700, 0x00002a00,
  0x00001a00, 0x00001800, 0x00001800, 0x00001800, 0x00001800, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x001f1f1f, 0x00434343,
  0x005b5b5b, 0x00002200, 0x00002600, 0x00002200, 0x00001900, 0x00001800,
  0x00001800, 0x00001800, 0x00001800, 0x00001800, 0x00b6b6b6, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00383838,
  0x00595959, 0x00707070, 0x00001800, 0x00001800, 0x00001800, 0x00001800,
  0x00001800, 0x00001800, 0x00001800, 0x00b6b6b6, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00666666, 0x007d7d7d, 0x008e8e8e, 0x009c9c9c, 0x00001800,
  0x00afafaf, 0x00b2b2b2, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x007d7d7d, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff };


static unsigned long data_option_out[] =
{ 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x08181818, 0x08181818, 0x08181818, 0x08181818, 0x08181818,
  0x08181818, 0x08181818, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x08181818,
  0x08181818, 0x08181818, 0x08181818, 0x08181818, 0x08181818, 0x08181818,
  0x081d1d1d, 0x08242424, 0x08262626, 0x081f1f1f, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x08181818,
  0x08181818, 0x08181818, 0x08181818, 0x08181818, 0x08202020, 0x082c2c2c,
  0x08363636, 0x083d3d3d, 0x08424242, 0x08424242, 0x08383838, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x08181818,
  0x08181818, 0x08181818, 0x08181818, 0x08272727, 0x08353535, 0x08404040,
  0x084a4a4a, 0x08535353, 0x08585858, 0x085b5b5b, 0x08585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x08181818, 0x08181818,
  0x08181818, 0x081a1a1a, 0x082b2b2b, 0x083a3a3a, 0x08474747, 0x08535353,
  0x085d5d5d, 0x08656565, 0x086c6c6c, 0x08707070, 0x086f6f6f, 0x08666666,
  0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x08181818, 0x08181818,
  0x08181818, 0x082b2b2b, 0x083b3b3b, 0x084a4a4a, 0x08575757, 0x08636363,
  0x086d6d6d, 0x08767676, 0x087d7d7d, 0x08818181, 0x08828282, 0x087d7d7d,
  0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x08181818, 0x08181818,
  0x08272727, 0x083a3a3a, 0x084a4a4a, 0x08595959, 0x08666666, 0x08727272,
  0x087c7c7c, 0x08858585, 0x088c8c8c, 0x08919191, 0x08929292, 0x088e8e8e,
  0x00585858, 0x00585858, 0x08181818, 0x08181818, 0x08181818, 0x08202020,
  0x08353535, 0x08474747, 0x08575757, 0x08666666, 0x08737373, 0x087f7f7f,
  0x088a8a8a, 0x08939393, 0x089a9a9a, 0x089e9e9e, 0x08a0a0a0, 0x089c9c9c,
  0x087c7c7c, 0x00585858, 0x00585858, 0x08181818, 0x08181818, 0x082c2c2c,
  0x08414141, 0x08535353, 0x08636363, 0x08727272, 0x087f7f7f, 0x088c8c8c,
  0x089b9b9b, 0x08a7a7a7, 0x08a8a8a8, 0x08aaaaaa, 0x08ababab, 0x08a7a7a7,
  0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x081e1e1e, 0x08363636,
  0x084b4b4b, 0x085d5d5d, 0x086e6e6e, 0x087c7c7c, 0x088a8a8a, 0x089b9b9b,
  0x08d1d1d1, 0x08fdfdfd, 0x08c2c2c2, 0x08b4b4b4, 0x08b5b5b5, 0x08afafaf,
  0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x08242424, 0x083d3d3d,
  0x08535353, 0x08666666, 0x08767676, 0x08858585, 0x08939393, 0x08a8a8a8,
  0x08fdfdfd, 0x08ffffff, 0x08cacaca, 0x08bbbbbb, 0x08bbbbbb, 0x08b2b2b2,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x08262626, 0x08424242,
  0x08595959, 0x086c6c6c, 0x087d7d7d, 0x088c8c8c, 0x089a9a9a, 0x08a8a8a8,
  0x08c2c2c2, 0x18cacaca, 0x18bfbfbf, 0x18c0c0c0, 0x18bdbdbd, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x081f1f1f, 0x08434343,
  0x085b5b5b, 0x08707070, 0x08818181, 0x08919191, 0x089e9e9e, 0x08aaaaaa,
  0x08b4b4b4, 0x18bcbcbc, 0x38c0c0c0, 0x38c1c1c1, 0x38b6b6b6, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x08383838,
  0x08595959, 0x08707070, 0x08828282, 0x08929292, 0x08a0a0a0, 0x08acacac,
  0x08b5b5b5, 0x18bbbbbb, 0x38bebebe, 0x38b6b6b6, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x08666666, 0x087d7d7d, 0x088e8e8e, 0x089c9c9c, 0x08a8a8a8,
  0x08afafaf, 0x18b2b2b2, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x087d7d7d, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858 };


static unsigned long data_radio_out[] =
{ 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x08181818, 0x08181818, 0x08181818, 0x08181818, 0x08181818,
  0x08181818, 0x08181818, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x08181818,
  0x08181818, 0x08181818, 0x08181818, 0x08181818, 0x08181818, 0x08181818,
  0x081d1d1d, 0x08242424, 0x08262626, 0x081f1f1f, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x08181818,
  0x08181818, 0x08181818, 0x08181818, 0x08181818, 0x08202020, 0x082c2c2c,
  0x08363636, 0x083d3d3d, 0x08424242, 0x08424242, 0x08383838, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x08181818,
  0x08181818, 0x08181818, 0x08181818, 0x08272727, 0x08353535, 0x08404040,
  0x084a4a4a, 0x08535353, 0x08585858, 0x085b5b5b, 0x08585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x08181818, 0x08181818,
  0x08181818, 0x081a1a1a, 0x082b2b2b, 0x083a3a3a, 0x08474747, 0x08535353,
  0x085d5d5d, 0x08656565, 0x086c6c6c, 0x08707070, 0x086f6f6f, 0x08666666,
  0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x08181818, 0x08181818,
  0x08181818, 0x082b2b2b, 0x083b3b3b, 0x084a4a4a, 0x08575757, 0x08636363,
  0x086d6d6d, 0x08767676, 0x087d7d7d, 0x08818181, 0x08828282, 0x087d7d7d,
  0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x08181818, 0x08181818,
  0x08272727, 0x083a3a3a, 0x084a4a4a, 0x08595959, 0x08666666, 0x08727272,
  0x087c7c7c, 0x08858585, 0x088c8c8c, 0x08919191, 0x08929292, 0x088e8e8e,
  0x00585858, 0x00585858, 0x08181818, 0x08181818, 0x08181818, 0x08202020,
  0x08353535, 0x08474747, 0x08575757, 0x08666666, 0x08737373, 0x087f7f7f,
  0x088a8a8a, 0x08939393, 0x089a9a9a, 0x089e9e9e, 0x08a0a0a0, 0x089c9c9c,
  0x087c7c7c, 0x00585858, 0x00585858, 0x08181818, 0x08181818, 0x082c2c2c,
  0x08414141, 0x08535353, 0x08636363, 0x08727272, 0x087f7f7f, 0x088c8c8c,
  0x089b9b9b, 0x08a7a7a7, 0x08a8a8a8, 0x08aaaaaa, 0x08ababab, 0x08a7a7a7,
  0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x081e1e1e, 0x08363636,
  0x084b4b4b, 0x085d5d5d, 0x086e6e6e, 0x087c7c7c, 0x088a8a8a, 0x089b9b9b,
  0x08d1d1d1, 0x08fdfdfd, 0x08c2c2c2, 0x08b4b4b4, 0x08b5b5b5, 0x08afafaf,
  0x00585858, 0x00585858, 0x00585858, 0x08181818, 0x08242424, 0x083d3d3d,
  0x08535353, 0x08666666, 0x08767676, 0x08858585, 0x08939393, 0x08a8a8a8,
  0x08fdfdfd, 0x08ffffff, 0x08cacaca, 0x08bbbbbb, 0x08bbbbbb, 0x08b2b2b2,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x08262626, 0x08424242,
  0x08595959, 0x086c6c6c, 0x087d7d7d, 0x088c8c8c, 0x089a9a9a, 0x08a8a8a8,
  0x08c2c2c2, 0x18cacaca, 0x18bfbfbf, 0x18c0c0c0, 0x18bdbdbd, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x081f1f1f, 0x08434343,
  0x085b5b5b, 0x08707070, 0x08818181, 0x08919191, 0x089e9e9e, 0x08aaaaaa,
  0x08b4b4b4, 0x18bcbcbc, 0x38c0c0c0, 0x38c1c1c1, 0x38b6b6b6, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x08383838,
  0x08595959, 0x08707070, 0x08828282, 0x08929292, 0x08a0a0a0, 0x08acacac,
  0x08b5b5b5, 0x18bbbbbb, 0x38bebebe, 0x38b6b6b6, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x08666666, 0x087d7d7d, 0x088e8e8e, 0x089c9c9c, 0x08a8a8a8,
  0x08afafaf, 0x18b2b2b2, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x087d7d7d, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858,
  0x00585858, 0x00585858 };


static unsigned long data_radio_in[] =
{ 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x08181818, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x08181818, 0x08181818, 0x08181818, 0x08181818, 0x08181818,
  0x08181818, 0x08181818, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x08181818,
  0x08181818, 0x08181818, 0x08181818, 0x08181818, 0x08181818, 0x08181818,
  0x081d1d1d, 0x08242424, 0x08262626, 0x081f1f1f, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x08181818, 0x08181818,
  0x08181818, 0x08181818, 0x08181818, 0x08181818, 0x08202020, 0x388c0000,
  0x08363636, 0x083d3d3d, 0x08424242, 0x08424242, 0x08383838, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x08181818, 0x08181818,
  0x08181818, 0x08181818, 0x38b90000, 0x38bc0000, 0x38b50000, 0x38a90000,
  0x38980000, 0x18820000, 0x08610000, 0x085b5b5b, 0x08585858, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x08181818, 0x08181818, 0x08181818,
  0x08181818, 0x08bc0000, 0x18c10000, 0x38bd0000, 0x38b40000, 0x38a60000,
  0x38960000, 0x38820000, 0x186a0000, 0x18480000, 0x086f6f6f, 0x08666666,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x08181818, 0x08181818, 0x08181818,
  0x08af0000, 0x08bc0000, 0x08bd0101, 0x18e63131, 0x38c71c1c, 0x389e0000,
  0x388e0000, 0x387b0000, 0x38640000, 0x38480000, 0x381e0000, 0x087d7d7d,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x08181818, 0x08181818, 0x08181818,
  0x08ae0000, 0x08b30000, 0x08b80707, 0x08ff6969, 0x18c22323, 0x38920000,
  0x38810000, 0x386f0000, 0x38590000, 0x383f0000, 0x381c0000, 0x088e8e8e,
  0x00ffffff, 0x00ffffff, 0x08181818, 0x08181818, 0x08181818, 0x08202020,
  0x08a20000, 0x08a50000, 0x08a20000, 0x08a00606, 0x08910101, 0x18820000,
  0x38720000, 0x385f0000, 0x384a0000, 0x38310000, 0x38180000, 0x089c9c9c,
  0x087c7c7c, 0x00ffffff, 0x00ffffff, 0x08181818, 0x08181818, 0x086f0000,
  0x08910000, 0x08930000, 0x088f0000, 0x08870000, 0x087d0000, 0x186f0000,
  0x38600000, 0x384d0000, 0x38380000, 0x381f0000, 0x38180000, 0x38180000,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x08181818, 0x081e1e1e, 0x08363636,
  0x087b0000, 0x087e0000, 0x087a0000, 0x08730000, 0x18680000, 0x385b0000,
  0x384b0000, 0x38390000, 0x38230000, 0x38180000, 0x38180000, 0x08afafaf,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x08181818, 0x08242424, 0x083d3d3d,
  0x08600000, 0x08660000, 0x08630000, 0x185b0000, 0x38510000, 0x38440000,
  0x38340000, 0x38210000, 0x38180000, 0x38180000, 0x38180000, 0x08b2b2b2,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x08262626, 0x08424242,
  0x083b0000, 0x08480000, 0x18470000, 0x38410000, 0x38370000, 0x382a0000,
  0x381a0000, 0x38180000, 0x18180000, 0x18180000, 0x38180000, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x081f1f1f, 0x08434343,
  0x085b5b5b, 0x18220000, 0x38260000, 0x38220000, 0x38190000, 0x38180000,
  0x38180000, 0x18180000, 0x08180000, 0x08180000, 0x38b6b6b6, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x08383838,
  0x08595959, 0x08707070, 0x38180000, 0x38180000, 0x38180000, 0x38180000,
  0x18180000, 0x08180000, 0x08180000, 0x38b6b6b6, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x08666666, 0x087d7d7d, 0x088e8e8e, 0x089c9c9c, 0x18180000,
  0x08afafaf, 0x18b2b2b2, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x087d7d7d, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff, 0x00ffffff,
  0x00ffffff, 0x00ffffff };




Pixmap LUI_PixmapOptionIn, LUI_PixmapOptionOut,
       LUI_PixmapRadioIn, LUI_PixmapRadioOut;


#define MAKEIMAGE 1


void LUI_InitButtonPixmaps( void )
{
    XImage *ximage_option_in, *ximage_option_out,
           *ximage_radio_in, *ximage_radio_out;
    int format, offset, xpad, bytes_per_line;

    /* Setup for image */
    format         = ZPixmap;
    offset         = 0;
    xpad           = 32;
    bytes_per_line = 0;

    /*** Make Option.In pixmap ***/
    ximage_option_in = XCreateImage(LUI_Display, LUI_Visual,
       LUI_Depth, format, offset, (char *) data_option_in,
       WIDTH, HEIGHT, xpad, bytes_per_line);

    LUI_PixmapOptionIn = XCreatePixmap(LUI_Display, LUI_RootWindow, 
       WIDTH, HEIGHT, LUI_Depth);
#ifdef MAKEIMAGE
    XPutImage(LUI_Display, LUI_PixmapOptionIn,
              LUI_GC_black, ximage_option_in,
              0, 0, 0, 0, WIDTH, HEIGHT);
#endif
    /*** Make Option.Out pixmap ***/
    ximage_option_out = XCreateImage(LUI_Display, LUI_Visual,
       LUI_Depth, format, offset, (char *) data_option_out,
       WIDTH, HEIGHT, xpad, bytes_per_line);

    LUI_PixmapOptionOut = XCreatePixmap(LUI_Display, LUI_RootWindow, 
       WIDTH, HEIGHT, LUI_Depth);

#ifdef MAKEIMAGE
    XPutImage(LUI_Display, LUI_PixmapOptionOut,
              LUI_GC_black, ximage_option_out,
              0, 0, 0, 0, WIDTH, HEIGHT);
#endif


    /*** Make Radio.In pixmap ***/
    ximage_radio_in = XCreateImage(LUI_Display, LUI_Visual,
       LUI_Depth, format, offset, (char *) data_radio_in,
       WIDTH, HEIGHT, xpad, bytes_per_line);

    LUI_PixmapRadioIn = XCreatePixmap(LUI_Display, LUI_RootWindow, 
       WIDTH, HEIGHT, LUI_Depth);

#ifdef MAKEIMAGE
    XPutImage(LUI_Display, LUI_PixmapRadioIn,
              LUI_GC_black, ximage_radio_in,
              0, 0, 0, 0, WIDTH, HEIGHT);
#endif


    /*** Make Radio.Out pixmap ***/
    ximage_radio_out = XCreateImage(LUI_Display, LUI_Visual,
       LUI_Depth, format, offset, (char *) data_radio_out,
       WIDTH, HEIGHT, xpad, bytes_per_line);

    LUI_PixmapRadioOut = XCreatePixmap(LUI_Display, LUI_RootWindow, 
       WIDTH, HEIGHT, LUI_Depth);

#ifdef MAKEIMAGE
    XPutImage(LUI_Display, LUI_PixmapRadioOut,
              LUI_GC_black, ximage_radio_out,
              0, 0, 0, 0, WIDTH, HEIGHT);
#endif

}
