/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2001 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef MATRIX_H
#define MATRIX_H

#include <Types.h>

class Matrix
{
public:
  Matrix();
  Matrix(uint size);
  Matrix(uint rows, uint cols);
  Matrix(const Matrix&);
  ~Matrix();

  Matrix& operator=(const Matrix&);
  TComplex& operator()(uint row, uint col);
  Matrix operator+(const Matrix&);
  Matrix operator-(const Matrix&);
  Matrix operator*(const Matrix&);
  Matrix& operator~();

  Matrix subMatrix(uint startRow, uint startCol,
		   uint noRows, uint noCols);

  void clear();
  void resize( uint size );
  void resize( uint rows, uint cols );
  void zero();

  uint rows() const;
  uint columns() const;
  
  void swapRows(uint a, uint b);
  void swapColumns(uint a, uint b);
  void delRow(uint a);
  void delColumn(uint a);
  void conj();
  void coFactor(uint r, uint c);
  void negate();
  void diagonal(TComplex n);
  void reduce( uint nrPorts );

  void insertComponent(TComplex& y, uint node[4]);
  void insertComponent(TComplex& y, uint node0, uint node1);
  void insertGm(TComplex& y, uint node[4]);
  void insertGm(TComplex& y, uint node0, uint node1, uint node2, uint node3);
  void insertTwoPort(Matrix& y, uint node[4]);
  void insertCoupledLine(Matrix& y, uint node[4]);

  void dump();

  //Exceptions
  class ExceptionMatrixSingular { };
  class ExceptionMatrixSizeMismatch { };
  class ExceptionMatrixBoundsOverrun { };

private:
  void allocateMemory();
  
private:
  static uint counter_;
  uint rows_;
  uint cols_;
  TComplex **matrix_;
};
#endif
