/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2001 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef CIRCUITNODE_H
#define CIRCUITNODE_H

#include <SchematicElement.h>
#include <CircuitLine.h>

#include <qlist.h>
#include <qpoint.h>

class Schematic;

class CircuitNode : public SchematicElement
{
public:
  CircuitNode( const QPoint& pos, 
	       bool isComponentNode = FALSE,
	       bool isPortNode = FALSE,
	       bool isGndNode = FALSE,
	       bool isFloatAllowed = FALSE );
  virtual ~CircuitNode();

  QPoint& pos();

  bool isComponentNode();
  bool isFree();
  bool isPortNode();
  bool isGndNode();
  bool isFloatingAllowed();
  void makeComponentNode();
  void makeFloatingNode();

  void setCircuit( Schematic* circuit );
 
  TReal getImpedance() const;
  void  setImpedance( TReal z );

  int  getNodeNumber();
  void setNodeNumber( int nr );

  void addLine( CircuitLine* line );
  void removeLine( CircuitLine* line );

  void replaceWith( CircuitNode* node );

  void draw( QPainter* p );

  void buildLineList( QList<CircuitLine>& lineList );

private:
  CircuitNode( const CircuitNode& );
  CircuitNode& operator=( const CircuitNode& );

private:
  QPoint pos_;
  Schematic* schematic_;
  int nodeNumber_;
  bool isComponentNode_;
  bool isPortNode_;
  bool isGndNode_;
  bool isFloatAllowed_;
  TReal z_; 
  QList<CircuitLine> lineList_;
};

#endif
