/*
			 View Background Image IO
 */
#ifndef VIEWBG_H
#define VIEWBG_H

#include <gtk/gtk.h>
#include "v3dtex.h"


/*
 *	View background image flags:
 */
#define VIEW_BGIMAGE_FLAG_VIEW_2D		(1 << 1)
#define VIEW_BGIMAGE_FLAG_VIEW_3D		(1 << 2)


/*
 *	View background image structure:
 */
typedef struct {

	/* Flags, any of VIEW_BGIMAGE_FLAG_*. */
	guint flags;

	/* Pointer back to view structure, view structure type is
	 * defined in member flags if VIEW_BGIMAGE_FLAG_VIEW_2D or
	 * VIEW_BGIMAGE_FLAG_VIEW_3D flag is set (never both).
	 */
	gpointer view_ptr;

	/* Full path to background image file. */
	gchar *path;

	/* Texture used as the background image. */
	v3d_texture_ref_struct *texture;

	/* Texture size in pixels. */
	gint tex_width, tex_height;
	gdouble tex_aspect;		/* tex_width / tex_height. */

	/* Offset in meters. */
	gdouble v_offset_i, v_offset_j;
	/* Size in meters. */
	gdouble v_length_i, v_length_j;

} view_bgimage_struct;


extern view_bgimage_struct *ViewBGImageLoad(
	guint flags,
	gpointer view_ptr,
	const gchar *path,
	gdouble v_offset_i, gdouble v_offset_j,	/* In meters. */
	gdouble v_scale_i, gdouble v_scale_j    /* Pielx to meters coeff. */
);
extern void ViewBGImageUnload(view_bgimage_struct *bgimg);
extern void ViewBGImageDraw(view_bgimage_struct *bgimg);


#endif	/* VIEWBG_H */
