/*
			  Splash System and Splash Window
 */

#ifndef SPLASH_H
#define SPLASH_H

#include <gtk/gtk.h>

#ifndef gbool
# define gbool	gboolean
#endif


/*
 *	Splash window return codes:
 */
#define SPLASH_SUCCESS	0
#define SPLASH_ERROR	-1
#define SPLASH_ABORT	-4


/*
 *	Splash window structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
	gint width, height;	/* Size (approx) of toplevel. */
	GtkWidget *toplevel;

	GdkFont *font_title;

	GtkWidget **pbar;
	gint total_pbars;

} splash_win_struct;


extern splash_win_struct *SplashNew(
	gint total_pbars, const gchar *splash_path
);
extern gint SplashUpdate(
	splash_win_struct *sw,
	gint pbar_num,		/* Progress bar number. */
	gdouble pos,		/* Position from 0.0 to 1.0. */
	const gchar *mesg,	/* Message, can be NULL. */
	gbool allow_iteration	/* Allow call to gtk_main_iteration. */
);
extern void SplashWinMap(splash_win_struct *sw);
extern void SplashWinUnmap(splash_win_struct *sw);
extern void SplashDelete(splash_win_struct *sw);



#endif	/* SPLASH_H */
