#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#include "../include/string.h"

#include "v3dmodel.h"
#include "v3dmp.h"

#include "guiutils.h"
#include "cdialog.h"
#include "csd.h"

#include "editor.h"
#include "editorlist.h"
#include "editorviewcb.h"
#include "editortdialog.h"

#include "texbrowser.h"

#include "scratchpad.h"

#include "prefwin.h"
#include "prefwinop.h"
#include "vpiinternal.h"

#include "vmacfg.h"
#include "vmacfglist.h"
#include "vmastyles.h"
#include "vma.h"

#ifdef MEMWATCH
# include "memwatch.h"
#endif


void PrefDoApply(vma_pref_struct *pref);
void PrefDoFetch(vma_pref_struct *pref);


#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))

#define RADTODEG(r)     ((r) * 180 / PI)
#define DEGTORAD(d)     ((d) * PI / 180)


/*
 *	Procedure to set values on preferences window to its core
 *	structure windows and resources.
 */
void PrefDoApply(vma_pref_struct *pref)
{
	gint i;
	GtkWidget *w;
	GdkColormap *colormap;
	const gchar *cfg_parm_name;
	vma_core_struct *core_ptr;
	vma_plugin_struct *plugin_ptr;

	gint tool_bar_style = 2;

	u_int8_t val_u8;
	u_int32_t val_u32;
	gdouble val_d;
	gchar *path_ptr;
	gint path_max;
	struct stat stat_buf;


	if(pref == NULL)
	    return;

	core_ptr = (vma_core_struct *)pref->core_ptr;
	if(core_ptr == NULL)
	    return;


#define DO_APPLY_FONT		\
if(((w == NULL) ? 0 : GTK_IS_ENTRY(w)) && \
   (cfg_parm_name != NULL) \
) \
{ \
 const gchar *cstrptr = (const gchar *)gtk_entry_get_text(GTK_ENTRY(w)); \
 if(cstrptr != NULL) \
  VMACFGItemListMatchSetValue( \
   option, cfg_parm_name, (const void *)cstrptr, FALSE \
  ); \
}


/* Macro to get csd_color_struct from the widget w (which is a
 * GtkDrawingArea) and allocate a GdkColor and set the widget w's
 * background color to it and clear the widget's window. Also updates
 * the configuration item value.
 */
#define DO_APPLY_COLOR		\
if(((w == NULL) ? 0 : !GTK_WIDGET_NO_WINDOW(w)) && \
   (cfg_parm_name != NULL) \
) \
{ \
 GdkColor gdk_color; \
 vma_color_struct view_color; \
 \
 csd_color_struct *color_ptr = (csd_color_struct *) \
  gtk_object_get_user_data(GTK_OBJECT(w)); \
 \
 colormap = gdk_window_get_colormap(w->window); \
 \
 gdk_color.red = (guint16)(color_ptr->r * 65535.0); \
 gdk_color.green = (guint16)(color_ptr->g * 65535.0); \
 gdk_color.blue = (guint16)(color_ptr->b * 65535.0); \
 \
 view_color.a = color_ptr->a; \
 view_color.r = color_ptr->r; \
 view_color.g = color_ptr->g; \
 view_color.b = color_ptr->b; \
 \
 VMACFGItemListMatchSetValue( \
  option, cfg_parm_name, (void *)&view_color, FALSE \
 ); \
}

/* Macro to get value from GtkEntry widget w and set value to string
 * pointed to by path_ptr with a maximum of path_max bytes.
 */
#define DO_APPLY_PATH_ENTRY	\
if(((w == NULL) ? 0 : GTK_IS_ENTRY(w)) && \
   (path_ptr != NULL) && (path_max > 0) \
) \
{ \
 const char *value = (const char *)gtk_entry_get_text( \
  GTK_ENTRY(w) \
 ); \
 if(value != NULL) \
 { \
  while(ISBLANK(*value)) \
   value++; \
  strncpy(path_ptr, value, path_max); \
  path_ptr[path_max - 1] = '\0'; \
 } \
}

	/* Apperance. */

	/* Record window positions and sizes. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_RECORD_WIN_POS_AND_SIZES))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_RECORD_LAST_POS_AND_SIZE,
	    (void *)&val_u8, FALSE
	);

	/* Show tooltips. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_TOOLTIPS))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_SHOW_TOOLTIPS, (void *)&val_u8, FALSE
	);
	/* Update global tooltips state on gui system. */
	GUISetGlobalTipsState((val_u8) ? TRUE : FALSE);

	/* Show tip of day. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_SHOW_TIP_OF_DAY))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_SHOW_TIPOFDAY, (void *)&val_u8, FALSE
	);


	/* Tool bar style. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_TOOLBAR_P))
	    tool_bar_style = 1;
	else if(PrefParmGetValueB(pref, VMA_PREF_PARM_TOOLBAR_T))
	    tool_bar_style = 0;
	else
	    tool_bar_style = 2;

	val_u8 = (u_int8_t)tool_bar_style;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_TOOLBAR_STYLE, (void *)&val_u8, FALSE
	);


	/* Fonts. */

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_FONT_EDITABLE);
	cfg_parm_name = VMA_CFG_PARM_FONT_NAME_EDITABLE;
	DO_APPLY_FONT

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_FONT_TERMINAL);
	cfg_parm_name = VMA_CFG_PARM_FONT_NAME_TERMINAL;
	DO_APPLY_FONT


	/* Colors. */

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_BG);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_BACKGROUND;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_POINT);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_POINT;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_LINE);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_LINE;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_LINE_STRIP);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_LINE_STRIP;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_LINE_LOOP);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_LINE_LOOP;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_TRIANGLE);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_TRIANGLE;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_TRIANGLE_STRIP);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_TRIANGLE_STRIP;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_TRIANGLE_FAN);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_TRIANGLE_FAN;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_QUAD);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_QUAD;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_QUAD_STRIP);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_QUAD_STRIP;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_POLYGON);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_POLYGON;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_TEXTURE_OUTLINE);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_TEXTURE_OUTLINE;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_TEXTURE_SELECTED);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_TEXTURE_OUTLINE_SELECTED;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_HEIGHTFIELD);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_HEIGHTFIELD;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_GRID);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_GRID;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_SELECTED);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_SELECTED;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_SELECTED_VERTEX);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_SELECTED_VERTEX;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_CURSORY);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_CURSORY;
	DO_APPLY_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_NORMAL_VECTOR);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_NORMAL_VECTOR;
	DO_APPLY_COLOR



	/* Precision. */
	/* Vertex coordinate decimals. */
	val_u32 = (u_int32_t)PrefParmGetValueI(
	    pref, VMA_PREF_PARM_DATA_DECIMALS_POSITION
	);
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_DATA_DECIMALS_POSITION,
	    (void *)&val_u32, FALSE
	);
	/* Vertex angle decimals. */
	val_u32 = (u_int32_t)PrefParmGetValueI(
	    pref, VMA_PREF_PARM_DATA_DECIMALS_ANGLE
	);
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_DATA_DECIMALS_ANGLE,
	    (void *)&val_u32, FALSE
	);

	/* View position decimals. */
	val_u32 = (u_int32_t)PrefParmGetValueI(
	    pref, VMA_PREF_PARM_VIEW_DECIMALS_POSITION
	);
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_VIEW_DECIMALS_POSITION,
	    (void *)&val_u32, FALSE
	);
	/* View angle decimals. */
	val_u32 = (u_int32_t)PrefParmGetValueI(
	    pref, VMA_PREF_PARM_VIEW_DECIMALS_ANGLE
	);
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_VIEW_DECIMALS_ANGLE,
	    (void *)&val_u32, FALSE
	);


	/* Rendering. */
	/* Render state. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_VIEW_RENDER))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_VIEW_RENDER, (void *)&val_u8, FALSE
	);

	/* Cull face state. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_VIEW_CULL_FACES))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_VIEW_CULL_FACES, (void *)&val_u8, FALSE
	);

	/* Cull face winding direction, true if counter-clockwise and
	 * false if clockwise.
	 */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_CULL_DIRECTION_CCW))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_CULL_DIRECTION, (void *)&val_u8, FALSE
	);

	/* Perform rotations and translations. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_VIEW_TRANSLATIONS_STATE))
	    val_u8 = 1;
	else        
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_VIEW_TRANSLATIONS_STATE,
	    (void *)&val_u8, FALSE
	);

	/* Enable alpha channel. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_VIEW_ENABLE_ALPHA_CHANNEL))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_VIEW_ENABLE_ALPHA_CHANNEL,
	    (void *)&val_u8, FALSE
	);


	/* Camera clip near. */
	val_d = PrefParmGetValueD(
	    pref, VMA_PREF_PARM_VIEW_CAM_CLIP_NEAR
	);
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_VIEW_CAM_CLIP_NEAR,
	    (void *)&val_d, FALSE
	);

	/* Camera clip far. */
	val_d = PrefParmGetValueD(
	    pref, VMA_PREF_PARM_VIEW_CAM_CLIP_FAR
	);
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_VIEW_CAM_CLIP_FAR,
	    (void *)&val_d, FALSE
	);

	/* Camera field of view. */
	val_d = DEGTORAD(PrefParmGetValueD(
	    pref, VMA_PREF_PARM_VIEW_CAM_FOV
	));
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_VIEW_CAM_FOV,
	    (void *)&val_d, FALSE
	);


	/* Devices. */
	/* Pointer emulated as 2 buttons. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_DEVICES_POINTER_2BUTTON))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_POINTER_EMULATE_2BUTTON, (void *)&val_u8, FALSE
	);


	/* Editor. */
	/* Maximum undo items. */
	val_u32 = PrefParmGetValueI(
	    pref, VMA_PREF_PARM_EDITOR_UNDO_MAX
	);
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_UNDO_MAX, (void *)&val_u32, FALSE
	);	


	/* Locations. */
	/* Local data dir. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_LOCAL);
	path_ptr = dname.data_local;
	path_max = PATH_MAX;
	DO_APPLY_PATH_ENTRY
	if(stat(path_ptr, &stat_buf))
	{
	    CDialogSetTransientFor(pref->toplevel);
	    CDialogGetResponse(
"Local Data Directory Not Found",
"The specified local data directory could not be found.\n\
\n\
If you believe this is an error, then you should go back and\n\
specify the correct value.\n\
\n\
If you are planning to rename or move your local data\n\
directory, then you need to make sure that you specify the\n\
-f <configuration_file> argument on the command line the\n\
next time you run this application (for example\n\
\"vertex -f /home/me/newplace/vertex.ini\").",
		NULL,
		CDIALOG_ICON_WARNING,
		CDIALOG_BTNFLAG_OK,
		CDIALOG_BTNFLAG_OK
	    );
	    CDialogSetTransientFor(NULL);
	}

	/* Global data dir. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_GLOBAL);
	path_ptr = dname.data_global;
	path_max = PATH_MAX;
	DO_APPLY_PATH_ENTRY

	/* Local and global preset models directories. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_PRESET_MODELS_LOCAL);
	path_ptr = dname.preset_models_local;
	path_max = PATH_MAX;
	DO_APPLY_PATH_ENTRY
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_PRESET_MODELS_GLOBAL);
	path_ptr = dname.preset_models_global;
	path_max = PATH_MAX;
	DO_APPLY_PATH_ENTRY

	/* Local and global preset primitives directories. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_PRESET_PRIMITIVES_LOCAL);
	path_ptr = dname.preset_primitives_local;
	path_max = PATH_MAX;
	DO_APPLY_PATH_ENTRY
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_PRESET_PRIMITIVES_GLOBAL);
	path_ptr = dname.preset_primitives_global;
	path_max = PATH_MAX;
	DO_APPLY_PATH_ENTRY

	/* Tmp dir. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_TMP);
	path_ptr = dname.tmp;
	path_max = PATH_MAX;
	DO_APPLY_PATH_ENTRY

	/* Scratchpad file. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_FILE_SCRATCHPAD);
	path_ptr = fname.scratchpad;
	path_max = PATH_MAX + NAME_MAX;
	DO_APPLY_PATH_ENTRY

	/* Plug-ins file. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_FILE_PLUGINS);
	path_ptr = fname.plugins;
	path_max = PATH_MAX + NAME_MAX;
	DO_APPLY_PATH_ENTRY


	/* V3D Format Options. */
	/* Prompt on save. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_V3DFMT_PROMPT_ON_SAVE))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_V3DFMT_PROMPT_ON_SAVE, (void *)&val_u8, FALSE
	);

	/* Optimization level. */
	val_u32 = PrefParmGetValueI(pref, VMA_PREF_PARM_V3DFMT_OPTIMIZATION);
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_V3DFMT_OPTIMIZATION, (void *)&val_u32, FALSE
	);

	/* Strip extranous data. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_V3DFMT_STRIP_EXTRAS))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_V3DFMT_STRIP_EXTRAS, (void *)&val_u8, FALSE
	);


	/* Backup. */
	/* Backup when opening file. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_BACKUP_ON_OPEN))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_BACKUP_ON_OPEN, (void *)&val_u8, FALSE
	);

	/* Backup when saving file. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_BACKUP_ON_SAVE))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_BACKUP_ON_SAVE, (void *)&val_u8, FALSE
	);

	/* Backup periodic interval. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_BACKUP_PERIODIC))
	{
	    val_u32 = PrefParmGetValueI(
		pref, VMA_PREF_PARM_BACKUP_PERIODIC_INT
	    );
	}
	else
	{
	    val_u32 = 0;
	}
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_BACKUP_PERIODIC_INT, (void *)&val_u32, FALSE
	);

	/* New backups at highest index. */
	if(PrefParmGetValueB(pref, VMA_PREF_PARM_BACKUP_NEW_HIGHEST_INDEX))
	    val_u8 = 1;
	else
	    val_u8 = 0;
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_BACKUP_NEW_INDEX_HIGHEST,
	    (void *)&val_u8, FALSE
	);

	/* Backup maximum. */
	val_u32 = CLIP(PrefParmGetValueI(
	    pref, VMA_PREF_PARM_BACKUP_MAX
	), 0, VMA_BACKUP_MAX);
	VMACFGItemListMatchSetValue(
	    option, VMA_CFG_PARM_BACKUP_MAX, (void *)&val_u32, FALSE
	);



	/* ********************************************************* */
	/* With global configuration options list now updated, we need
	 * to update related resources to notify them so they can enact
	 * these changes.
	 */

	/* Apply global GTK+ style changes. */
	VMAStylesListUpdate(&styles_list);

	/* Update backup callback. */
	if(core_ptr->backup_toid != (guint)-1)
	{
	    gtk_timeout_remove(core_ptr->backup_toid);
	    core_ptr->backup_toid = (guint)-1;
	}
	i = VMACFGItemListGetValueI(option, VMA_CFG_PARM_BACKUP_PERIODIC_INT);
	if(i > 0)
	    core_ptr->backup_toid = gtk_timeout_add(
		i * 60 * 1000,  /* Convert to milliseconds. */
		VMABackupTimeoutCB,
		(gpointer)core_ptr
	    );


	/* Begin applying values to each editor. */
	for(i = 0; i < core_ptr->total_editors; i++)
	    EditorUpdateAppearance(core_ptr->editor[i]);


	/* Scratch pad, update appearance and menus. */
	ScratchPadUpdateAppearance(core_ptr->scratch_pad);



	/* Update plug-ins by calling their configuration changed
	 * operation callbacks.
	 */
	for(i = 0; i < core_ptr->total_plugins; i++)
	{
	    plugin_ptr = core_ptr->plugin[i];
	    if((plugin_ptr == NULL) ?
		1 : (plugin_ptr->handle == NULL)
	    )
		continue;

	    /* Skip if plug-in is busy processing. */
	    if(plugin_ptr->processing)
		continue;

	    /* Call configuration changed callback. */
	    VPIDoOpConfigurationChanged(plugin_ptr);
	}

/* Add additional resources that need to be updated when
 * preferences are applied.
 */

#undef DO_APPLY_PATH_ENTRY
#undef DO_APPLY_COLOR

	return;
}

/*
 *      Procedure to get values from global configuration options list and
 *	store them on the preferences window structure.
 *
 *	Note that this function isn't widly used since the values are
 *	fetched when the preferences window is created.
 */
void PrefDoFetch(vma_pref_struct *pref)
{
	gint type;
	gbool state;
	GtkWidget *w;
	const gchar *cfg_parm_name;
	const gchar *path_ptr;
	vma_core_struct *core_ptr;
	gint tool_bar_style = 2;


	if(pref == NULL)
	    return;

	core_ptr = (vma_core_struct *)pref->core_ptr;
	if(core_ptr == NULL)
	    return;

#define DO_FETCH_ENTRY		\
if((w == NULL) ? 0 : GTK_IS_ENTRY(GTK_OBJECT(w))) \
{ \
 char *value = VMACFGItemListGetValueS( \
  option, cfg_parm_name \
 ); \
 if(value != NULL) \
  gtk_entry_set_text(GTK_ENTRY(w), value); \
}

#define DO_FETCH_PATH_ENTRY	\
if((w == NULL) ? 0 : GTK_IS_ENTRY(GTK_OBJECT(w))) \
{ \
 if(path_ptr != NULL) \
  gtk_entry_set_text(GTK_ENTRY(w), path_ptr); \
}


#define DO_FETCH_SPIN_I		\
if((w == NULL) ? 0 : GTK_IS_SPIN_BUTTON(GTK_OBJECT(w))) \
{ \
 gint value_i = VMACFGItemListGetValueI(option, cfg_parm_name); \
  gtk_spin_button_set_value( \
   GTK_SPIN_BUTTON(w), (gfloat)value_i \
  ); \
}

#define DO_FETCH_SPIN_D		\
if((w == NULL) ? 0 : GTK_IS_SPIN_BUTTON(GTK_OBJECT(w))) \
{ \
 gdouble value_d = VMACFGItemListGetValueD(option, cfg_parm_name); \
  gtk_spin_button_set_value( \
   GTK_SPIN_BUTTON(w), (gfloat)value_d \
  ); \
}

#define DO_FETCH_FONT		\
if(((w == NULL) ? 0 : GTK_IS_ENTRY(w)) && \
   (cfg_parm_name != NULL) \
) \
{ \
 const gchar *cstrptr = VMACFGItemListGetValueS( \
   option, cfg_parm_name \
 ); \
 if(cstrptr != NULL) \
  gtk_entry_set_text(GTK_ENTRY(w), cstrptr); \
}

#define DO_FETCH_COLOR		\
if(((w == NULL) ? 0 : !GTK_WIDGET_NO_WINDOW(w)) && \
   (cfg_parm_name != NULL) \
) \
{ \
 GdkColor gdk_color; \
 GdkColormap *colormap; \
 csd_color_struct *color_ptr = (csd_color_struct *)gtk_object_get_user_data( \
  GTK_OBJECT(w) \
 ); \
 vma_color_struct *view_color_ptr = (vma_color_struct *) \
  VMACFGItemListMatchGetValue( \
   option, cfg_parm_name, &type \
  ); \
 if((view_color_ptr != NULL) && \
    (type == VMA_CFG_ITEM_TYPE_COLOR) && \
    (color_ptr != NULL) \
 ) \
 { \
  color_ptr->a = view_color_ptr->a; \
  color_ptr->r = view_color_ptr->r; \
  color_ptr->g = view_color_ptr->g; \
  color_ptr->b = view_color_ptr->b; \
 \
  gdk_color.red = (guint16)(color_ptr->r * (guint16)(-1)); \
  gdk_color.green = (guint16)(color_ptr->g * (guint16)(-1)); \
  gdk_color.blue = (guint16)(color_ptr->b * (guint16)(-1)); \
 \
  colormap = gdk_window_get_colormap(w->window); \
  if(colormap != NULL) \
   gdk_colormap_alloc_color(colormap, &gdk_color, TRUE, TRUE); \
  gdk_window_set_background(w->window, &gdk_color); \
  gdk_window_clear(w->window); \
  gdk_colormap_free_colors(colormap, &gdk_color, 1); \
 } \
}

	/* Fetch apperance. */

	/* Record last window positions. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_RECORD_WIN_POS_AND_SIZES);
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_RECORD_LAST_POS_AND_SIZE
	) ? TRUE : FALSE);
	if(w != NULL)
	    GTK_TOGGLE_BUTTON(w)->active = state;

	/* Tool bar style. */
	tool_bar_style = VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_TOOLBAR_STYLE
	);
	switch(tool_bar_style)
	{
	  case 2:
	    w = PrefParmGetWidget(pref, VMA_PREF_PARM_TOOLBAR_PT);
	    if(w != NULL)
		GTK_TOGGLE_BUTTON(w)->active = TRUE;
	    w = PrefParmGetWidget(pref, VMA_PREF_PARM_TOOLBAR_P);
	    if(w != NULL)
		GTK_TOGGLE_BUTTON(w)->active = FALSE;
	    w = PrefParmGetWidget(pref, VMA_PREF_PARM_TOOLBAR_T);
	    if(w != NULL)
		GTK_TOGGLE_BUTTON(w)->active = FALSE;
	    break;

	  case 1:
	    w = PrefParmGetWidget(pref, VMA_PREF_PARM_TOOLBAR_PT);
	    if(w != NULL)
		GTK_TOGGLE_BUTTON(w)->active = FALSE;
	    w = PrefParmGetWidget(pref, VMA_PREF_PARM_TOOLBAR_P);
	    if(w != NULL)
		GTK_TOGGLE_BUTTON(w)->active = TRUE;
	    w = PrefParmGetWidget(pref, VMA_PREF_PARM_TOOLBAR_T);
	    if(w != NULL)
		GTK_TOGGLE_BUTTON(w)->active = FALSE;
	    break;

	  case 0:
	    w = PrefParmGetWidget(pref, VMA_PREF_PARM_TOOLBAR_PT);
	    if(w != NULL)
		GTK_TOGGLE_BUTTON(w)->active = FALSE;
	    w = PrefParmGetWidget(pref, VMA_PREF_PARM_TOOLBAR_P);
	    if(w != NULL)
		GTK_TOGGLE_BUTTON(w)->active = FALSE;
	    w = PrefParmGetWidget(pref, VMA_PREF_PARM_TOOLBAR_T);
	    if(w != NULL)
		GTK_TOGGLE_BUTTON(w)->active = TRUE;
	    break;
	}

	/* Show tool tips. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_TOOLTIPS);
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_SHOW_TOOLTIPS
	) ? TRUE : FALSE);
	if(w != NULL)
	    GTK_TOGGLE_BUTTON(w)->active = state;

	/* Show tip of day. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_SHOW_TIP_OF_DAY);
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_SHOW_TIPOFDAY
	) ? TRUE : FALSE);
	if(w != NULL)
	    GTK_TOGGLE_BUTTON(w)->active = state;


	/* Fetch fonts. */

	/* Editable. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_FONT_EDITABLE);
	cfg_parm_name = VMA_CFG_PARM_FONT_NAME_EDITABLE;
	DO_FETCH_FONT

	/* Terminal. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_FONT_TERMINAL);
	cfg_parm_name = VMA_CFG_PARM_FONT_NAME_TERMINAL;
	DO_FETCH_FONT





	/* Fetch colors. */

	/* View colors. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_BG);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_BACKGROUND;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_POINT);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_POINT;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_LINE);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_LINE;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_LINE_STRIP);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_LINE_STRIP;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_LINE_LOOP);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_LINE_LOOP;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_TRIANGLE);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_TRIANGLE;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_TRIANGLE_STRIP);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_TRIANGLE_STRIP;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_TRIANGLE_FAN);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_TRIANGLE_FAN;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_QUAD);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_QUAD;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_QUAD_STRIP);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_QUAD_STRIP;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_POLYGON);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_POLYGON;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_TEXTURE_OUTLINE);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_TEXTURE_OUTLINE;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_TEXTURE_SELECTED);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_TEXTURE_OUTLINE_SELECTED;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_HEIGHTFIELD);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_HEIGHTFIELD;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_GRID);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_GRID;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_SELECTED);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_SELECTED;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_SELECTED_VERTEX);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_SELECTED_VERTEX;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_CURSORY);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_CURSORY;
	DO_FETCH_COLOR

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_COLOR_VIEW_NORMAL_VECTOR);
	cfg_parm_name = VMA_CFG_PARM_VIEW_COLOR_NORMAL_VECTOR;
	DO_FETCH_COLOR


	/* Precision. */
	/* Vertex coordinate decimals. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DATA_DECIMALS_POSITION);
	cfg_parm_name = VMA_CFG_PARM_DATA_DECIMALS_POSITION;
	DO_FETCH_SPIN_I
	/* Vertex angle decimals. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DATA_DECIMALS_ANGLE);
	cfg_parm_name = VMA_CFG_PARM_DATA_DECIMALS_ANGLE;
	DO_FETCH_SPIN_I

	/* View position decimals. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_VIEW_DECIMALS_POSITION);
	cfg_parm_name = VMA_CFG_PARM_VIEW_DECIMALS_POSITION;
	DO_FETCH_SPIN_I
	/* View angle decimals. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_VIEW_DECIMALS_ANGLE);
	cfg_parm_name = VMA_CFG_PARM_VIEW_DECIMALS_ANGLE;
	DO_FETCH_SPIN_I


	/* Rendering. */
	/* Views. */
	/* Render state. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_VIEW_RENDER);
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_VIEW_RENDER
	) ? TRUE : FALSE);
	if(w != NULL)
	    gtk_toggle_button_set_active(
		GTK_TOGGLE_BUTTON(w), state
	    );
	/* Cull faces state. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_VIEW_CULL_FACES);
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_VIEW_CULL_FACES
	) ? TRUE : FALSE);
	if(w != NULL)
	{
	    gtk_toggle_button_set_active(
		GTK_TOGGLE_BUTTON(w), state
	    );
	    gtk_signal_emit_by_name(
		(GtkObject *)w, "toggled",
		(gpointer)pref
	    );
	}

	/* Cull face winding direction, true if counter-clockwise and
	 * false if clockwise.
	 */
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_CULL_DIRECTION
	) ? TRUE : FALSE);
	/* Clockwise radio button. */
	w = PrefParmGetWidget(
	    pref, VMA_PREF_PARM_CULL_DIRECTION_CW
	);
	if(w != NULL)
	    gtk_toggle_button_set_active(
		GTK_TOGGLE_BUTTON(w), !state
	    );
	/* Counter-clockwise radio button. */
	w = PrefParmGetWidget(
	    pref, VMA_PREF_PARM_CULL_DIRECTION_CCW
	);
	if(w != NULL)
	    gtk_toggle_button_set_active(
		GTK_TOGGLE_BUTTON(w), state
	    );

	/* Perform rotation and translations check button. */
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_VIEW_TRANSLATIONS_STATE
	) ? TRUE : FALSE);
	w = PrefParmGetWidget(
	    pref, VMA_PREF_PARM_VIEW_TRANSLATIONS_STATE
	);
	if(w != NULL)
	    gtk_toggle_button_set_active(
		GTK_TOGGLE_BUTTON(w), state
	    );

	/* Enable alpha channel check button. */ 
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_VIEW_ENABLE_ALPHA_CHANNEL
	) ? TRUE : FALSE);
	w = PrefParmGetWidget(
	    pref, VMA_PREF_PARM_VIEW_ENABLE_ALPHA_CHANNEL
	);
	if(w != NULL)
	    gtk_toggle_button_set_active(
		GTK_TOGGLE_BUTTON(w), state
	    );

	/* Camera clip near. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_VIEW_CAM_CLIP_NEAR);
	cfg_parm_name = VMA_CFG_PARM_VIEW_CAM_CLIP_NEAR;
	DO_FETCH_SPIN_D

	/* Camera clip far. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_VIEW_CAM_CLIP_FAR);
	cfg_parm_name = VMA_CFG_PARM_VIEW_CAM_CLIP_FAR;
	DO_FETCH_SPIN_D

	/* Camera field of view. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_VIEW_CAM_FOV);
	cfg_parm_name = VMA_CFG_PARM_VIEW_CAM_FOV;
	if((w == NULL) ? 0 : GTK_IS_SPIN_BUTTON(GTK_OBJECT(w)))
	{
	    gdouble value_d = VMACFGItemListGetValueD(option, cfg_parm_name);
	    gtk_spin_button_set_value(
		GTK_SPIN_BUTTON(w), (gfloat)RADTODEG(value_d)
	    );
	}


	/* Devices. */
	/* Pointer emulated as 2 buttons. */
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_POINTER_EMULATE_2BUTTON
	) ? TRUE : FALSE);
	w = PrefParmGetWidget(
	    pref, VMA_PREF_PARM_DEVICES_POINTER_2BUTTON
	);
	if(w != NULL)
	    gtk_toggle_button_set_active(
		GTK_TOGGLE_BUTTON(w), state
	    );


	/* Editor. */
	/* Maximum undo items. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_EDITOR_UNDO_MAX);
	cfg_parm_name = VMA_CFG_PARM_UNDO_MAX;
	DO_FETCH_SPIN_I



	/* Locations, here we fetch from the fnames and dnames
	 * structures and not from the global configuration options list.
	 */

	/* Local data directory. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_LOCAL);
	path_ptr = (const char *)dname.data_local;
	DO_FETCH_PATH_ENTRY
	/* Global data directory. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_GLOBAL);
	path_ptr = (const char *)dname.data_global;
	DO_FETCH_PATH_ENTRY

	/* Local preset models directory. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_PRESET_MODELS_LOCAL);
	path_ptr = (const char *)dname.preset_models_local;
	DO_FETCH_PATH_ENTRY
	/* Global preset models directory. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_PRESET_MODELS_GLOBAL);
	path_ptr = (const char *)dname.preset_models_global;
	DO_FETCH_PATH_ENTRY

	/* Local preset primitives directory. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_PRESET_PRIMITIVES_LOCAL);
	path_ptr = (const char *)dname.preset_primitives_local;
	DO_FETCH_PATH_ENTRY 
	/* Global preset primitives directory. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_PRESET_PRIMITIVES_GLOBAL);
	path_ptr = (const char *)dname.preset_primitives_global;
	DO_FETCH_PATH_ENTRY

	/* Tempory directory. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_DIRECTORY_TMP);
	path_ptr = (const char *)dname.tmp;
	DO_FETCH_PATH_ENTRY

	/* Scratchpad file. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_FILE_SCRATCHPAD);
	path_ptr = (const char *)fname.scratchpad;
	DO_FETCH_PATH_ENTRY
	/* Plugins file. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_FILE_PLUGINS);
	path_ptr = (const char *)fname.plugins;
	DO_FETCH_PATH_ENTRY


	/* V3D format options. */
	/* Prompt for V3D format options on save check */
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_V3DFMT_PROMPT_ON_SAVE
	) ? TRUE : FALSE);
	w = PrefParmGetWidget(
	    pref, VMA_PREF_PARM_V3DFMT_PROMPT_ON_SAVE
	);
	if(w != NULL)
	    GTK_TOGGLE_BUTTON(w)->active = state;

	/* Optimization level scale. */
	w = PrefParmGetWidget(
	    pref, VMA_PREF_PARM_V3DFMT_OPTIMIZATION
	);
	if((w == NULL) ? 0 : GTK_IS_RANGE(w))
	{
	    GtkAdjustment *adj = gtk_range_get_adjustment(GTK_RANGE(w));
	    if(adj != NULL)
	    {
		gtk_adjustment_set_value(
		    adj, (gfloat)VMACFGItemListGetValueI(
			option, VMA_CFG_PARM_V3DFMT_OPTIMIZATION
		    )
		);
/*
		adj->value = (gfloat)VMACFGItemListGetValueI(
		    option, VMA_CFG_PARM_V3DFMT_OPTIMIZATION
		);
		gtk_adjustment_value_changed(adj);
 */
	    }
	}

	/* Strip extraneous data. */
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_V3DFMT_STRIP_EXTRAS
	) ? TRUE : FALSE);
	w = PrefParmGetWidget(
	    pref, VMA_PREF_PARM_V3DFMT_STRIP_EXTRAS
	);
	if(w != NULL)
	    GTK_TOGGLE_BUTTON(w)->active = state;


	/* Backup. */
	/* Backup when opening file. */
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_BACKUP_ON_OPEN
	) ? TRUE : FALSE);
	w = PrefParmGetWidget(
	    pref, VMA_PREF_PARM_BACKUP_ON_OPEN
	);
	if(w != NULL)
	    GTK_TOGGLE_BUTTON(w)->active = state;

	/* Backup when saving file. */
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_BACKUP_ON_SAVE
	) ? TRUE : FALSE);
	w = PrefParmGetWidget(
	    pref, VMA_PREF_PARM_BACKUP_ON_SAVE
	);
	if(w != NULL)
	    GTK_TOGGLE_BUTTON(w)->active = state;

	/* Periodic (automatic) backup interval toggle. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_BACKUP_PERIODIC_INT);
	cfg_parm_name = VMA_CFG_PARM_BACKUP_PERIODIC_INT;
	DO_FETCH_SPIN_I

	w = PrefParmGetWidget(pref, VMA_PREF_PARM_BACKUP_PERIODIC);
	if(VMACFGItemListGetValueL(
	    option, VMA_CFG_PARM_BACKUP_PERIODIC_INT
	) > 0)
	{
	    if((w == NULL) ? 0 : GTK_IS_TOGGLE_BUTTON(w))
		gtk_toggle_button_set_active( 
		    GTK_TOGGLE_BUTTON(w), TRUE
		);
	}
	else
	{
	    if((w == NULL) ? 0 : GTK_IS_TOGGLE_BUTTON(w))
		gtk_toggle_button_set_active(
		    GTK_TOGGLE_BUTTON(w), FALSE
		);
	}
	if(w != NULL)
	    gtk_signal_emit_by_name(
		(GtkObject *)w, "toggled",
		(gpointer)pref
	    );

	/* New backups at highest index. */
	state = (VMACFGItemListGetValueI(
	    option, VMA_CFG_PARM_BACKUP_NEW_INDEX_HIGHEST
	) ? TRUE : FALSE);
	w = PrefParmGetWidget(
	    pref, VMA_PREF_PARM_BACKUP_NEW_HIGHEST_INDEX
	);
	if(w != NULL) 
	    GTK_TOGGLE_BUTTON(w)->active = state;
	/* New backups at lowest index. */
	w = PrefParmGetWidget(
	    pref, VMA_PREF_PARM_BACKUP_NEW_LOWEST_INDEX
	);
	if(w != NULL)
	    GTK_TOGGLE_BUTTON(w)->active = !state;

	/* Maximum backups per file. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_BACKUP_MAX);
	cfg_parm_name = VMA_CFG_PARM_BACKUP_MAX;
	DO_FETCH_SPIN_I


	/* Plug-ins. */
	/* Plug-ins list. */
	w = PrefParmGetWidget(pref, VMA_PREF_PARM_PLUGINS_LIST);
	if((w == NULL) ? 0 : GTK_IS_CLIST(w))
	{
	    GtkCList *clist = GTK_CLIST(w);

	    gtk_clist_freeze(clist);
	    gtk_clist_clear(clist);
	    VPICListAppend(clist, core_ptr->plugin, core_ptr->total_plugins);
	    gtk_clist_thaw(clist);
	}



#undef DO_FETCH_SPIN_I
#undef DO_FETCH_SPIN_D
#undef DO_FETCH_ENTRY
#undef DO_FETCH_PATH_ENTRY
#undef DO_FETCH_COLOR
#undef DO_FETCH_FONT

	return;
}
