/*
                       V3D Client Library IO Functions

	Include file for any application that links to the V3D library
	(libv3d). This is the master header file for libv3d, it
	#includes all dependent v3d header files and defines the
	libv3d version.

	For V3D format file IO, see v3dfio.h.

	For GL heightfield functions, see v3dhf.h.

	For GL texture functions, see v3dtex.h.

 */

#ifndef V3D_H
#define V3D_H

#include "v3dfio.h"		/* File IO. */
#include "v3dgl.h"		/* V3D to OpenGL interpritation. */
#include "v3dhf.h"		/* Heightfields. */
#include "v3dmh.h"		/* Model header items. */
#include "v3dmodel.h"		/* Models. */
#include "v3dmp.h"		/* Model primitives. */
#include "v3dtex.h"		/* Textures. */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/*
 *	Version of this library:
 */
#define LIBV3D_VERSION_MAJOR	0
#define LIBV3D_VERSION_MINOR	1
#define LIBV3D_VERSION_RELEASE	5


#ifdef __cplusplus
}  
#endif /* __cplusplus */

#endif	/* V3D_H */
