/*
                               Tool Bar
 */

#ifndef TOOLBAR_H
#define TOOLBAR_H

#include <gtk/gtk.h>

#ifndef gbool
# define gbool	gboolean
#endif

/*
 *	Tool bar item types:
 */
#define TOOLBAR_ITEM_SEPARATOR		0
#define TOOLBAR_ITEM_BUTTON		1
#define TOOLBAR_ITEM_TOGGLE_BUTTON	2

/*
 *	Tool bar item sizes:
 */
#define TOOLBAR_BUTTON_PICTURE_AND_TEXT_WIDTH	60
#define TOOLBAR_BUTTON_PICTURE_AND_TEXT_HEIGHT	50
#define TOOLBAR_BUTTON_PICTURE_WIDTH	30
#define TOOLBAR_BUTTON_PICTURE_HEIGHT	30
#define TOOLBAR_BUTTON_TEXT_WIDTH	-1
#define TOOLBAR_BUTTON_TEXT_HEIGHT	30


/*
 *	Tool bar item structure:
 */
typedef struct {

	gint type;			/* One of TOOLBAR_ITEM_*. */

	GtkWidget *w;

	/* Client function set values. */
	gchar *text;
        guint8 **icon_data;		/* Shared. */
	gchar *tooltip;

	/* Arbitary client set operation id code. */
	gint id;

	/* Function callbacks, sole argument is the respective
	 * client_data.
	 */

	/* "clicked" or "toggled" callback. */
	void (*func_cb)(gpointer);
	gpointer client_data;

	/* "enter_notify_event" and "leave_notify_event" callbacks. */
        void (*enter_cb)(gpointer);
	gpointer enter_client_data;
        void (*leave_cb)(gpointer);
        gpointer leave_client_data;

} toolbar_item_struct;


/*
 *	Tool bar structure:
 */
typedef struct {

#define TOOLBAR_DISPLAY_TEXT			0
#define TOOLBAR_DISPLAY_PICTURES		1
#define TOOLBAR_DISPLAY_PICTURES_AND_TEXT	2
	gint display;			/* One of TOOLBAR_DISPLAY_*. */

#define TOOLBAR_RELIEF_NORMAL			0
#define TOOLBAR_RELIEF_HALF			1
#define TOOLBAR_RELIEF_NONE			2
	gint relief;

	gbool vertical;			/* TRUE if vertical. */
	gbool map_state;
	GtkWidget *toplevel;		/* GtkHBox or GtkVBox. */
	toolbar_item_struct **item;
	gint total_items;

} toolbar_struct;


extern toolbar_item_struct *ToolBarItemNew(
	gint type,		/* One of TOOLBAR_ITEM_*. */
	const gchar *text,
	guint8 **icon_data,
	const gchar *tooltip,
	gint id,
	void (*func_cb)(gpointer),
	gpointer client_data,
        void (*enter_cb)(gpointer),
	gpointer enter_client_data,
        void (*leave_cb)(gpointer),
        gpointer leave_client_data
);
extern void ToolBarItemDelete(toolbar_item_struct *item);

extern toolbar_item_struct *ToolBarItemMatchByID(
        toolbar_item_struct **item, gint total_items,
        gint id
);

extern toolbar_struct *ToolBarNew(
	toolbar_item_struct **item, gint total_items,
	GtkWidget *parent,
	gint display,		/* One of TOOLBAR_DISPLAY_*. */
	gint relief,		/* One of TOOLBAR_RELIEF_*. */
	gbool vertical
);
extern void ToolBarSetDisplay(toolbar_struct *tb, gint display);
extern void ToolBarSetRelief(toolbar_struct *tb, gint relief);
extern void ToolBarItemUpdateByID(
	toolbar_struct *tb, gint id,
        const gchar *text,
        guint8 **icon_data,
        const gchar *tooltip
);
extern void ToolBarMap(toolbar_struct *tb);
extern void ToolBarUnmap(toolbar_struct *tb);
extern void ToolBarDelete(toolbar_struct *tb);

extern void ToolBarItemSetSensitiveID(
	toolbar_struct *tb, gint id, gbool sensitive
);
extern void ToolBarItemSetToggleID(
        toolbar_struct *tb, gint id, gbool toggled
);
extern gbool ToolBarItemGetToggleID(
        toolbar_struct *tb, gint id
);
extern void ToolBarItemMapID(
        toolbar_struct *tb, gint id
);
extern void ToolBarItemUnmapID(
        toolbar_struct *tb, gint id
);





#endif	/* TOOLBAR_H */

