/*
                      Editable GtkCList

	A plain GtkCList with menu and buttons for editing, cell editing
	provided by the float prompt.
 */

#ifndef EDITCLIST_H
#define EDITCLIST_H

#include <gtk/gtk.h>

/*
 *	Editable GtkCList structure:
 */
typedef struct {

	gboolean initialized;
	gboolean map_state;

	GtkWidget	*toplevel,
			*add_btn,
			*edit_btn,
			*remove_btn,
			*up_btn,
			*down_btn,
			*clist,
			*menu,
			*add_mi,
			*edit_mi,
			*remove_mi,
			*up_mi,
			*down_mi;

	/* Last selected row and column. */
	gint sel_row, sel_column;

	/* Row and column that the float prompt is mapped over. */
	gint fprompt_row, fprompt_column;

	/* Row changed callback, inputs; editclist_struct, clist, row,
	 * column, client_data
	 */
	void (*row_changed_cb)(gpointer, GtkCList *, gint, gint, gpointer);
	gpointer client_data;

} editclist_struct;

#define EDITCLIST(p)	((editclist_struct *)(p))
#define EDITCLIST_TOPLEVEL(p)	(((p) != NULL) ? \
 (EDITCLIST(p)->toplevel) : NULL)
#define EDITCLIST_CLIST(p)	(((p) != NULL) ? \
 (EDITCLIST(p)->clist) : NULL)


extern GtkWidget *EditCListGetCList(editclist_struct *ec);

extern editclist_struct *EditCListNew(
	GtkWidget *parent,	/* A GtkBox. */
	gint width, gint height,
	gboolean expand, gboolean fill, guint padding,
        gchar **heading, gint columns,
	void (*row_changed_cb)(gpointer, GtkCList *, gint, gint, gpointer),
        gpointer client_data
);
extern void EditCListUpdateMenus(editclist_struct *ec);
extern void EditCListMap(editclist_struct *ec);
extern void EditCListUnmap(editclist_struct *ec);
extern void EditCListDelete(editclist_struct *ec);




#endif	/* EDITCLIST_H */
