/*
                     Vertex 3D Compile Time Configuration
 */

#ifndef CONFIG_H
#define CONFIG_H


/*
 *      Languages (define only one):
 */
#define PROG_LANGUAGE_ENGLISH   1
/* #define PROG_LANGUAGE_SPANISH        2 */
/* #define PROG_LANGUAGE_FRENCH         3 */
/* incomplete #define PROG_LANGUAGE_GERMAN      4 */
/* incomplete #define PROG_LANGUAGE_ITALIAN     5 */
/* incomplete #define PROG_LANGUAGE_NORWEGIAN   6 */
/* incomplete #define PROG_LANGUAGE_PORTUGUESE  7 */


/*
 *	Program name and version:
 */
#define PROG_NAME	"Vertex"
#define PROG_VERSION	"0.1.14"

#define PROG_VERSION_MAJOR	0
#define PROG_VERSION_MINOR	1
#define PROG_VERSION_RELEASE	14

/*
 *	Credits lines:
 */
#define CREDITS_LINES	{ \
 "        Director: Capt Taura Milana", \
 " ", \
 "     Programmers: Dan Stimits", \
 "                  Capt Taura Milana", \
 " ", \
 " Graphics Artist: Capt Taura Milana", \
 " ", \
 "   Documentation: Capt Taura Milana", \
 " ", \
 "    Contributors: Brian Paul - Mesa3D", \
 "                  Janne Lf - GtkGLArea", \
 "                  Jessica Blank - Implementation Consultant", \
 "                  Magenta (aka Pascal) - OpenGL consultant", \
 "                  Stefan Maron - GUI Consultant", \
 NULL \
}


/*
 *	Environment variable names:
 */
#define VMA_ENVNAME_DATA_GLOBAL_DIR	"VERTEX_GLOBAL_DIR"
#define VMA_ENVNAME_DATA_LOCAL_DIR	"VERTEX_LOCAL_DIR"


/*
 *	Default tempory files directory, name of this program with
 *	user's name will be appended, ie if value is /tmp and user
 *	name is jane then the result would be /tmp/vertex-jane
 */
#define VMA_DEF_TMP_DIR			"/tmp"


/*
 *	File and directory paths:
 */
#define VMA_DEF_DATA_GLOBAL_DIR		"/usr/share/vertex"

/* Local data directory, user's home dir will be prefixed. */
#define VMA_DEF_DATA_LOCAL_DIR		".vertex"

/* Configuration file, local data dir will be prefixed. */
#define VMA_DEF_PREFERENCES_FILE	"vertex.ini"

/* Preset models file directory, local and global data dir will be prefixed. */
#define VMA_DEF_PRESET_MODELS_DIR	"preset_models"
/* Preset primitives file directory, local and global dir will be
 * prefixed.
 */
#define VMA_DEF_PRESET_PRIMITIVES_DIR	"preset_primitives"
/* Plug-ins directory, local and global data dir will be prefixed. */
#define VMA_DEF_PLUGINS_DIR		"plugins"

#define VMA_DEF_SCRATCHPAD_FILE		"scratchpad.ini"

/* Contains both global and local plugins information but only
 * stored locally.
 */
#define VMA_DEF_PLUGINS_FILE		"plugins.ini"

/*
 *	Splash image (VMA_DEF_DATA_GLOBAL_DIR will be prefixed):
 */
#define VMA_DEF_SPLASH_IMAGE_BG		"images/splash.xpm"

/*
 *	Help files (VMA_DEF_DATA_GLOBAL_DIR will be prefixed):
 */
#define VMA_HELP_FILE_CONTENTS		"help/index.html"
#define VMA_HELP_FILE_TUTORIALS		"help/tutorials.html"
#define VMA_HELP_FILE_VIEWING		"help/viewing.html"
#define VMA_HELP_FILE_KEYBOARD		"help/keyboard.html"
#define VMA_HELP_FILE_V3D_FORMAT	"help/v3dformat.html"
#define VMA_HELP_FILE_PLUGINS		"help/plugins.html"


/*
 *	Installer images (VMA_DEF_DATA_GLOBAL_DIR will be prefixed):
 */
#define VMA_DEF_INSTALLER_IMAGE_BG_HEADING	"images/installer_heading.xpm"
#define VMA_DEF_INSTALLER_IMAGE_BG_MAIN		"images/installer_main.xpm"
#define VMA_DEF_INSTALLER_IMAGE_BG_FOOTER	"images/installer_footer.xpm"

/*
 *      License file (VMA_DEF_DATA_GLOBAL_DIR will be prefixed):
 */
#define VMA_DEF_FILE_LICENSE		"LICENSE"


/*
 *	Default print command:
 *
 *	Any occurance of %f will be replaced with the postscript file 
 *	to be printed.
 */
#define DEF_PRINT_COMMAND	"lpr %f"

/*
 *	Default print to file postscript file name:
 */
#define DEF_PRINT_FILE		"vertex.ps"

/*
 *	Default print resolution (pixels per inch):
 */
#define VMA_DEF_PRINT_PPI_X	72.0
#define VMA_DEF_PRINT_PPI_Y	72.0


/*
 *	Default editor window size (in pixels):
 */
#define VMA_EDITOR_DEF_WIDTH	950
#define VMA_EDITOR_DEF_HEIGHT	720

/*
 *      Default editor's text dialog window size when
 *	`pulled out' (in pixels):
 */
#define VMA_EDITOR_TDIALOG_DEF_WIDTH    650
#define VMA_EDITOR_TDIALOG_DEF_HEIGHT   440


/*
 *	Default texture browser window size (in pixels):
 */
#define VMA_TEXBROWSER_DEF_WIDTH	450
#define VMA_TEXBROWSER_DEF_HEIGHT	500

/*
 *      Default Preferences window size in pixels:
 */
#define VMA_PREF_DEF_WIDTH		640
#define VMA_PREF_DEF_HEIGHT		480

/*
 *      Default ScratchPad window size in pixels:
 */
#define VMA_SCRATCHPAD_DEF_WIDTH	400
#define VMA_SCRATCHPAD_DEF_HEIGHT	400

/*
 *	Paned widget handle and gutter size (in pixels):
 */
#define VMA_DEF_PANED_GUTTER_SIZE	12
#define VMA_DEF_PANED_HANDLE_SIZE	10

/*
 *	Default maximum undo items:
 *
 *	Note, redo maximum will also be this value.
 */
#define VMA_EDITOR_DEF_UNDO_MAX		50


/*
 *	Default precisions (in number of decimals):
 */
#define VMA_DEF_VERTEX_DECIMALS_POSITION	2
#define VMA_DEF_VERTEX_DECIMALS_ANGLE		2

#define VMA_DEF_VIEW_DECIMALS_POSITION		1
#define VMA_DEF_VIEW_DECIMALS_ANGLE		2



/*
 *	Limit of managed backup files allowed (this can be pretty high):
 */
#define VMA_BACKUP_MAX		1000000

/*
 *	Default grid spacing in meters:
 */
#define VMA_DEF_GRID_SPACING	5.0

/*
 *	Default 3d move rate in meters in pixel:
 */
#define VMA_DEF_VIEW3D_MOVE_RATE	0.25

/*
 *	Default 2d viewable dimension:
 */
#define VMA_DEF_VIEW2D_VIEWABLE_DIM	18.0


/*
 *	Spacing between each list row (height of each item):
 */
#define VMA_LIST_ROW_SPACING		20

/*
 *	Spacing between pixmap and text in lists (in pixels):
 */
#define VMA_LIST_PIXMAP_TEXT_SPACING	2

/*
 *	Maximum viewer widgets per editor window:
 */
#define VMA_MAX_2D_VIEWS_PER_EDITOR	3
#define VMA_MAX_3D_VIEWS_PER_EDITOR	1

/*
 *	Maximum number of lights:
 */
#define VMA_LIGHTS_MAX		8


/*
 *	Number of bytes for values input text prompts to hold a
 *	reasonably big number.
 */
#define VMA_VALUE_TEXT_MAX	256

/*
 *	Maximum number of values per finite primitive:
 *
 *	This value should be big enough to have enough value labels
 *	and prompts for any given primitive for input.
 *	Highest would be 3 vertex coordinates, plus 3 normal coordinates,
 *	plus 3 texture coordinates which totals to 9.
 */
#define VMA_PRIMITIVES_MAX_VALUES	9

/*
 *	Directory deliminator:
 */
#ifndef DIR_DELIMINATOR
# define DIR_DELIMINATOR	'/'
#endif

/*
 *	Comment character (for file parsing):
 */
#define VMA_CFG_COMMENT_CHAR	'#'

/*
 *	Deliminator character between parameter and value:
 */
#define VMA_CFG_DELIMINATOR_CHAR	'='



/*
 *	Default GTK+ font names:
 */
#define VMA_GTK_FONT_NAME_PREF_BANNER	\
        "-adobe-helvetica-medium-r-normal-*-20-*-*-*-p-*-iso8859-1"
#define VMA_GTK_FONT_NAME_TEXT_EDITABLE	\
	"-adobe-courier-medium-r-*-*-14-*-*-*-*-*-iso8859-1"
#define VMA_GTK_FONT_NAME_TEXT_TERMINAL	\
        "-adobe-courier-medium-r-*-*-12-*-*-*-*-*-iso8859-1"

/* ```Fine print''' for license and other legal text. */
#define VMA_GTK_FONT_NAME_TEXT_LICENSE	\
	"-adobe-courier-medium-r-*-*-10-*-*-*-*-*-iso8859-1"

#define VMA_GTK_FONT_NAME_TEXT_HEADING1 \
        "-adobe-helvetica-medium-r-normal-*-24-*-*-*-p-*-iso8859-1"
#define VMA_GTK_FONT_NAME_TEXT_HEADING2 \
        "-adobe-helvetica-medium-r-normal-*-20-*-*-*-p-*-iso8859-1"
#define VMA_GTK_FONT_NAME_TEXT_HEADING3 \
	"-adobe-helvetica-medium-r-normal-*-18-*-*-*-p-*-iso8859-1"
#define VMA_GTK_FONT_NAME_TEXT_HEADING4 \
	"-adobe-helvetica-medium-r-normal-*-14-*-*-*-p-*-iso8859-1"
#define VMA_GTK_FONT_NAME_TEXT_HEADING5 \
	"-adobe-helvetica-medium-r-normal-*-12-*-*-*-p-*-iso8859-1"
#define VMA_GTK_FONT_NAME_TEXT_HEADING6	\
	"-adobe-helvetica-medium-r-normal-*-8-*-*-*-p-*-iso8859-1"


/*
 *	File extensions type list, used to pass as a list of file
 *	type extensions to the file browser. These lists are used
 *	in the creation of fb_type_struct lists in main.c.
 *
 *	Each line contains four pointers; first pointer is a space
 *	separated string of extensions (includes the . character),
 *	second pointer is the description string, third and fourth
 *	are reserved.
 *
 *	Very last item set in the list contain four NULL pointers.
 */
#define FILE_EXT_TYPE_LIST_SELECT_DIRECTORY	{ \
        "*.*", \
        "All files", \
        (char *)0, \
        (char *)0, \
 \
        NULL, NULL, NULL, NULL \
}

#define FILE_EXT_TYPE_LIST_LOAD_MODEL	{ \
	".v3d .3d", \
	"Vertex Model Assembler models", \
	(char *)0, \
	(char *)0, \
 \
	"*.*", \
	"All files", \
        (char *)0, \
        (char *)0, \
 \
	NULL, NULL, NULL, NULL \
}

#define FILE_EXT_TYPE_LIST_SAVE_MODEL   { \
        ".v3d .3d", \
        "Vertex Model Assembler models", \
        (char *)0, \
        (char *)0, \
 \
        NULL, NULL, NULL, NULL \
}

#define FILE_EXT_TYPE_LIST_LOAD_TEXTURE	{ \
        ".tga .tex .hf", \
        "Targa texture images", \
        (char *)0, \
        (char *)0, \
 \
        "*.*", \
        "All files", \
        (char *)0, \
        (char *)0, \
 \
        NULL, NULL, NULL, NULL \
}

#define FILE_EXT_TYPE_LIST_VIEW_BACKGROUND_IMAGE { \
        "*.*", \
        "Image files", \
        (char *)0, \
        (char *)0, \
 \
        "*.*", \
        "All files", \
        (char *)0, \
        (char *)0, \
 \
        NULL, NULL, NULL, NULL \
}


#endif	/* CONFIG_H */
